/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer;

import com.install4j.api.Util;
import com.install4j.api.beans.ReplacementMode;
import com.install4j.api.beans.UndefinedVariableException;
import com.install4j.api.beans.VariableErrorHandling;
import com.install4j.api.beans.VariableErrorHandlingDescriptor;
import com.install4j.api.context.Context;
import com.install4j.api.context.UserCanceledException;
import com.install4j.api.windows.WinFileSystem;
import com.install4j.runtime.installer.ContextImpl;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.installer.frontend.VariableResourceBundleWrapper;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.VariableEncoding;
import com.install4j.runtime.installer.helper.comm.ExecutionContext;
import com.install4j.runtime.installer.helper.comm.HelperCommunication;
import com.install4j.runtime.installer.helper.comm.actions.FetchBooleanAction;
import com.install4j.runtime.installer.helper.comm.actions.FetchObjectAction;
import com.install4j.runtime.installer.helper.comm.actions.RunAction;
import com.install4j.runtime.installer.platform.macos.VolumeInfo;
import com.install4j.runtime.installer.platform.win32.FolderInfo;
import com.install4j.runtime.util.StringUtil;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeMap;

public class InstallerVariables {
    private static Map props = new TreeMap();
    private static Map variableProviders = new HashMap();
    private static Set responseFileVariables = new HashSet();
    private static boolean replaceInstallerAndCompilerVariables = false;
    private static boolean replaceI18nVariables = false;
    private static DesignTimeVariableProcessor designTimeVariableProcessor;
    public static final String INSTALLER_PREFIX = "installer:";
    public static final String COMPILER_PREFIX = "compiler:";
    private static final String I18N_PREFIX = "i18n:";
    private static final String VARFILE_SUFFIX = ".varfile";
    public static final String VARIABLE_PATHLIST_SEPARATOR = "sys.pathlistSeparator";
    public static final String VARIABLE_FILE_SEPARATOR = "sys.fileSeparator";
    public static final String VARIABLE_USER_HOME = "sys.userHome";
    public static final String VARIABLE_USER_NAME = "sys.userName";
    public static final String VARIABLE_TEMP_DIR = "sys.tempDir";
    public static final String VARIABLE_WORKING_DIR = "sys.workingDir";
    public static final String VARIABLE_WINDOWS_DIR = "sys.windowsDir";
    public static final String VARIABLE_SYSTEM32_DIR = "sys.system32Dir";
    public static final String VARIABLE_COMMON_DIR = "sys.commonDir";
    public static final String VARIABLE_PROGRAM_FILES_DIR = "sys.programFilesDir";
    public static final String VARIABLE_PROGRAM_DATA_DIR = "sys.programDataDir";
    public static final String VARIABLE_DESKTOP_DIR = "sys.desktopDir";
    public static final String VARIABLE_STARTMENU_DIR = "sys.startMenuDir";
    public static final String VARIABLE_PROGRAMS_DIR = "sys.programsDir";
    public static final String VARIABLE_STARTUP_DIR = "sys.startupDir";
    public static final String VARIABLE_SENDTO_DIR = "sys.sendToDir";
    public static final String VARIABLE_FONTS_DIR = "sys.fontsDir";
    public static final String VARIABLE_APPDATA_DIR = "sys.appdataDir";
    public static final String VARIABLE_DOCS_DIR = "sys.docsDir";
    public static final String VARIABLE_TEMPLATES_DIR = "sys.templatesDir";
    public static final String VARIABLE_FAVORITES_DIR = "sys.favoritesDir";
    public static final String VARIABLE_LOCAL_APPDATA_DIR = "sys.localAppdataDir";
    public static final String VARIABLE_INSTALLATION_DIR = "sys.installationDir";
    public static final String VARIABLE_CONTENT_DIR = "sys.contentDir";
    public static final String VARIABLE_RESOURCE_DIR = "sys.resourceDir";
    public static final String VARIABLE_MEDIA_FILE = "sys.mediaFile";
    public static final String VARIABLE_MEDIA_DIR = "sys.mediaDir";
    public static final String VARIABLE_INSTALLER_DIR = "sys.installerDir";
    public static final String VARIABLE_INSTALLER_FILE = "sys.installerFile";
    public static final String VARIABLE_PROGRAM_GROUP_DIR = "sys.programGroupDir";
    public static final String VARIABLE_PROGRAM_GROUP_NAME = "sys.programGroupName";
    public static final String VARIABLE_PROGRAM_GROUP_DISABLED = "sys.programGroupDisabled";
    public static final String VARIABLE_PROGRAM_GROUP_ALL_USERS = "sys.programGroupAllUsers";
    public static final String VARIABLE_SYMLINK_DIR = "sys.symlinkDir";
    public static final String VARIABLE_REBOOT_REQUIRED = "sys.rebootRequired";
    public static final String VARIABLE_PREFERRED_JRE = "sys.preferredJre";
    public static final String VARIABLE_INSTALLATION_TYPE_ID = "sys.installationTypeId";
    public static final String VARIABLE_VERSION = "sys.version";
    public static final String VARIABLE_LANGUAGE_ID = "sys.languageId";
    public static final String VARIABLE_LOGFILE = "sys.logFile";
    public static final String VARIABLE_RESPONSE_FILE = "sys.responseFile";
    public static final String VARIABLE_JAVA_HOME = "sys.javaHome";
    public static final String VARIABLE_JAVA_VERSION = "sys.javaVersion";
    public static final String VARIABLE_CONFIRMED_UPDATE_INSTALLATION = "sys.confirmedUpdateInstallation";
    public static final String VARIABLE_ADMIN_RIGHTS = "sys.adminRights";
    private static boolean installationDirectoryFromCommandLine;
    private static final StringUtil.ReplacementCallback REMOVAL_CALLBACK;
    private static final StringUtil.ReplacementCallback PLAIN_CALLBACK;
    private static final StringUtil.ReplacementCallback I18N_ONLY_CALLBACK;
    private static final StringUtil.ReplacementCallback REGEXP_MATCH_CALLBACK;
    private static final StringUtil.ReplacementCallback REGEXP_REPLACEMENT_CALLBACK;
    private static final StringUtil.ReplacementCallback PROPERTIES_FILE_CALLBACK;

    public static void setDesignTimeVariableProcessor(DesignTimeVariableProcessor designTimeVariableProcessor) {
        InstallerVariables.designTimeVariableProcessor = designTimeVariableProcessor;
    }

    public static String quoteRegexpSearch(String string) {
        int n = string.indexOf("\\E");
        if (n == -1) {
            return "\\Q" + string + "\\E";
        }
        StringBuffer stringBuffer = new StringBuffer(string.length() * 2);
        stringBuffer.append("\\Q");
        int n2 = 0;
        while ((n = string.indexOf("\\E", n2)) != -1) {
            stringBuffer.append(string.substring(n2, n));
            n2 = n + 2;
            stringBuffer.append("\\E\\\\E\\Q");
        }
        stringBuffer.append(string.substring(n2, string.length()));
        stringBuffer.append("\\E");
        return stringBuffer.toString();
    }

    private static String quoteRegexpReplacement(String string) {
        if (string.indexOf(92) == -1 && string.indexOf(36) == -1) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\\') {
                stringBuffer.append('\\');
                stringBuffer.append('\\');
                continue;
            }
            if (c == '$') {
                stringBuffer.append('\\');
                stringBuffer.append('$');
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    private static Object[] getArguments(String string) {
        ArrayList arrayList = new ArrayList();
        StringUtil.splitupQuotedList(arrayList, string, ",");
        ListIterator<String> listIterator = arrayList.listIterator();
        while (listIterator.hasNext()) {
            String string2 = (String)listIterator.next();
            if (!string2.startsWith("\"") || !string2.endsWith("\"")) continue;
            string2 = string2.substring(1, string2.length() - 1);
            listIterator.set(string2);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static boolean getBooleanVariable(String string) {
        return Boolean.valueOf(InstallerVariables.getStringVariable(string));
    }

    public static String getStringVariable(String string) {
        Object object = InstallerVariables.getVariable(string);
        return object == null ? null : object.toString();
    }

    public static Object getVariable(final String string) {
        return HelperCommunication.getInstance().fetchObject(ExecutionContext.UNELEVATED, new FetchObjectAction(){

            protected Object fetchValue(Context context) throws UserCanceledException {
                VariableProvider variableProvider = (VariableProvider)variableProviders.get(string);
                if (variableProvider != null) {
                    return variableProvider.getVariable();
                }
                return props.get(string);
            }
        });
    }

    public static void setVariable(final String string, final Object object) {
        HelperCommunication.getInstance().executeAction(ExecutionContext.UNELEVATED, new RunAction(){

            protected void run(Context context) {
                VariableProvider variableProvider = (VariableProvider)variableProviders.get(string);
                if (variableProvider != null) {
                    variableProvider.setVariable(object);
                } else {
                    props.put(string, object);
                }
            }
        });
    }

    public static void registerVariableProvider(String string, VariableProvider variableProvider) {
        HelperCommunication.helperUnsupported();
        variableProviders.put(string, variableProvider);
        if (props.containsKey(string)) {
            variableProvider.setVariable(props.remove(string));
        }
    }

    public static void setReplaceInstallerAndCompilerVariables(final boolean bl) {
        HelperCommunication.getInstance().executeAction(ExecutionContext.ALL, new RunAction(){

            protected void run(Context context) {
                replaceInstallerAndCompilerVariables = bl;
            }
        });
    }

    public static void setReplaceI18nVariables(final boolean bl) {
        HelperCommunication.getInstance().executeAction(ExecutionContext.ALL, new RunAction(){

            protected void run(Context context) {
                replaceI18nVariables = bl;
            }
        });
    }

    public static String removeVariables(String string) {
        return StringUtil.replaceVariable(string, "${", "}", REMOVAL_CALLBACK, null);
    }

    public static String replaceVariables(String string) {
        return InstallerVariables.replaceVariables(string, ReplacementMode.PLAIN);
    }

    public static String replaceVariables(String string, ReplacementMode replacementMode) {
        return InstallerVariables.replaceVariables(string, replacementMode, VariableErrorHandlingDescriptor.DEFAULT);
    }

    public static String replaceVariables(String string, ReplacementMode replacementMode, VariableErrorHandlingDescriptor variableErrorHandlingDescriptor) {
        if (replaceInstallerAndCompilerVariables || replaceI18nVariables) {
            if (string == null) {
                return null;
            }
            if (designTimeVariableProcessor != null) {
                string = designTimeVariableProcessor.replaceDesignTimeVariables(string);
            }
            return StringUtil.replaceVariable(string, "${", "}", InstallerVariables.getCallback(replacementMode), variableErrorHandlingDescriptor);
        }
        return string;
    }

    private static StringUtil.ReplacementCallback getCallback(ReplacementMode replacementMode) {
        if (replacementMode == ReplacementMode.REGEXP_MATCH) {
            return REGEXP_MATCH_CALLBACK;
        }
        if (replacementMode == ReplacementMode.REGEXP_REPLACEMENT) {
            return REGEXP_REPLACEMENT_CALLBACK;
        }
        if (replacementMode == ReplacementMode.I18N_ONLY) {
            return I18N_ONLY_CALLBACK;
        }
        if (replacementMode == ReplacementMode.PROPERTIES_FILE) {
            return PROPERTIES_FILE_CALLBACK;
        }
        return PLAIN_CALLBACK;
    }

    public static File replaceVariables(File file) {
        if (replaceInstallerAndCompilerVariables || replaceI18nVariables) {
            if (file == null) {
                return null;
            }
            return new File(InstallerVariables.replaceVariables(file.getPath()));
        }
        return file;
    }

    public static String[] replaceVariables(Object[] objectArray, VariableErrorHandlingDescriptor variableErrorHandlingDescriptor) {
        if (objectArray == null) {
            return null;
        }
        ArrayList arrayList = new ArrayList();
        String string = "${installer:";
        for (int i = 0; i < objectArray.length; ++i) {
            String string2 = objectArray[i].toString();
            if (string2.startsWith(string) && string2.indexOf(125) == string2.length() - 1) {
                String string3 = string2.substring(string.length(), string2.length() - 1);
                Object object = InstallerVariables.getVariable(string3);
                if (object instanceof Object[]) {
                    Object[] objectArray2 = (Object[])object;
                    for (int j = 0; j < objectArray2.length; ++j) {
                        InstallerVariables.addIfNotEmpty(arrayList, InstallerVariables.replaceVariables(objectArray2[j].toString(), ReplacementMode.PLAIN, variableErrorHandlingDescriptor));
                    }
                    continue;
                }
                InstallerVariables.addIfNotEmpty(arrayList, InstallerVariables.replaceVariables(string2, ReplacementMode.PLAIN, variableErrorHandlingDescriptor));
                continue;
            }
            InstallerVariables.addIfNotEmpty(arrayList, InstallerVariables.replaceVariables(string2, ReplacementMode.PLAIN, variableErrorHandlingDescriptor));
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private static void addIfNotEmpty(List list, String string) {
        if (string != null && string.length() > 0) {
            list.add(string);
        }
    }

    public static Set getVariableNames() {
        return (Set)HelperCommunication.getInstance().fetchObject(ExecutionContext.UNELEVATED, new FetchObjectAction(){

            protected Object fetchValue(Context context) throws UserCanceledException {
                HashSet hashSet = new HashSet();
                hashSet.addAll(props.keySet());
                hashSet.addAll(variableProviders.keySet());
                return hashSet;
            }
        });
    }

    public static void initUserVars() {
        InstallerVariables.initUserVars(props);
    }

    public static void initHelperState() {
        replaceI18nVariables = HelperCommunication.getInstance().fetchBoolean(ExecutionContext.UNELEVATED, new FetchBooleanAction(){

            protected boolean fetchValue(Context context) throws UserCanceledException {
                return replaceI18nVariables;
            }
        });
        replaceInstallerAndCompilerVariables = HelperCommunication.getInstance().fetchBoolean(ExecutionContext.UNELEVATED, new FetchBooleanAction(){

            protected boolean fetchValue(Context context) throws UserCanceledException {
                return replaceInstallerAndCompilerVariables;
            }
        });
    }

    public static void initUserVars(Map map) {
        map.put(VARIABLE_USER_HOME, System.getProperty("user.home"));
        map.put(VARIABLE_USER_NAME, System.getProperty("user.name"));
        if (InstallerUtil.isWindows()) {
            try {
                map.put(VARIABLE_APPDATA_DIR, FolderInfo.getSpecialFolder(7, false).getAbsolutePath());
                map.put(VARIABLE_DESKTOP_DIR, FolderInfo.getSpecialFolder(1, false).getAbsolutePath());
                map.put(VARIABLE_DOCS_DIR, FolderInfo.getSpecialFolder(8, false).getAbsolutePath());
                map.put(VARIABLE_FAVORITES_DIR, FolderInfo.getSpecialFolder(10, false).getAbsolutePath());
                map.put(VARIABLE_FONTS_DIR, FolderInfo.getSpecialFolder(6, false).getAbsolutePath());
                map.put(VARIABLE_LOCAL_APPDATA_DIR, FolderInfo.getSpecialFolder(11, false).getAbsolutePath());
                map.put(VARIABLE_PROGRAMS_DIR, FolderInfo.getSpecialFolder(3, false).getAbsolutePath());
                map.put(VARIABLE_SENDTO_DIR, FolderInfo.getSpecialFolder(5, false).getAbsolutePath());
                map.put(VARIABLE_STARTMENU_DIR, FolderInfo.getSpecialFolder(2, false).getAbsolutePath());
                map.put(VARIABLE_STARTUP_DIR, FolderInfo.getSpecialFolder(4, false).getAbsolutePath());
                map.put(VARIABLE_TEMPLATES_DIR, FolderInfo.getSpecialFolder(9, false).getAbsolutePath());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public static void initSystemVars(Map map) {
        HelperCommunication.helperUnsupported();
        map.put(VARIABLE_PATHLIST_SEPARATOR, File.pathSeparator);
        map.put(VARIABLE_FILE_SEPARATOR, File.separator);
        map.put(VARIABLE_JAVA_HOME, System.getProperty("java.home"));
        map.put(VARIABLE_JAVA_VERSION, System.getProperty("java.version"));
        map.put(VARIABLE_RESOURCE_DIR, InstallerUtil.getInstallerFile("user").getAbsolutePath());
        map.put(VARIABLE_PROGRAM_FILES_DIR, InstallerUtil.getStandardApplicationsDirectory());
        InstallerVariables.initAdminRights();
        try {
            map.put(VARIABLE_WORKING_DIR, new File(".").getCanonicalPath());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        try {
            map.put(VARIABLE_TEMP_DIR, new File(System.getProperty("java.io.tmpdir")).getCanonicalPath());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        if (InstallerUtil.isWindows()) {
            try {
                map.put(VARIABLE_SYSTEM32_DIR, WinFileSystem.getSystemDirectory().getAbsolutePath());
                map.put(VARIABLE_COMMON_DIR, WinFileSystem.getCommonFilesDirectory().getAbsolutePath());
                map.put(VARIABLE_PROGRAM_DATA_DIR, WinFileSystem.getProgramDataDirectory().getAbsolutePath());
                map.put(VARIABLE_WINDOWS_DIR, WinFileSystem.getWindowsDirectory().getAbsolutePath());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private static void initAdminRights() {
        final Boolean bl = Util.isAdminGroup() && Util.hasFullAdminRights();
        InstallerVariables.registerVariableProvider(VARIABLE_ADMIN_RIGHTS, new VariableProvider(){
            private Boolean val;
            {
                this.val = bl;
            }

            public Object getVariable() {
                return this.val;
            }

            public void setVariable(Object object) {
                if (!this.val.booleanValue() && object instanceof Boolean) {
                    this.val = (Boolean)object;
                }
            }
        });
        InstallerVariables.registerResponseFileVariable(VARIABLE_ADMIN_RIGHTS);
    }

    public static void initCommandLine(String string, Properties properties) {
        Object object;
        block13: {
            int n;
            HelperCommunication.helperUnsupported();
            InstallerVariables.addCommandLineVariables(InstallerConfig.getCurrentInstance().getApplicationConfigById(InstallerConfig.getCurrentApplicationId()).getInstallerVariables(), false, Collections.EMPTY_LIST);
            props.put(VARIABLE_REBOOT_REQUIRED, Boolean.FALSE);
            props.put(VARIABLE_VERSION, InstallerConfig.getCurrentInstance().getApplicationVersion());
            String string2 = System.getProperty("exe4j.moduleName");
            if (string2 != null) {
                File file = new File(string2);
                object = InstallerVariables.getMediaFile(file);
                props.put(VARIABLE_MEDIA_FILE, ((File)object).getAbsolutePath());
                props.put(VARIABLE_MEDIA_DIR, ((File)object).getParentFile().getAbsolutePath());
                props.put(VARIABLE_INSTALLER_FILE, file.getAbsolutePath());
                props.put(VARIABLE_INSTALLER_DIR, file.getParentFile().getAbsolutePath());
            } else {
                props.put(VARIABLE_MEDIA_DIR, new File(System.getProperty("user.dir")).getAbsolutePath());
                props.put(VARIABLE_INSTALLER_DIR, new File(System.getProperty("user.dir")).getAbsolutePath());
            }
            InstallerVariables.initSystemVars(props);
            boolean bl = true;
            if (string == null && string2 != null && (n = string2.lastIndexOf(46)) > -1) {
                String string3;
                File file = new File(string2.substring(0, n) + VARFILE_SUFFIX);
                if (file.exists() && file.isFile()) {
                    string = file.getPath();
                    bl = false;
                }
                if (string == null && (string3 = (String)props.get(VARIABLE_MEDIA_FILE)) != null && (n = string3.lastIndexOf(46)) > -1 && (file = new File(string3.substring(0, n) + VARFILE_SUFFIX)).exists() && file.isFile()) {
                    string = file.getPath();
                    bl = false;
                }
            }
            if (string != null) {
                object = new File(string);
                if (!((File)object).isAbsolute()) {
                    object = new File((String)props.get(VARIABLE_MEDIA_DIR), string);
                }
                try {
                    InstallerVariables.loadResponseFile((File)object, false, Collections.EMPTY_LIST);
                    props.put(VARIABLE_RESPONSE_FILE, ((File)object).getPath());
                }
                catch (IOException iOException) {
                    if (!bl) break block13;
                    System.err.println("Could not read file " + ((File)object).getAbsolutePath());
                    InstallerUtil.exit(1);
                }
            }
        }
        if ((object = System.getProperty("install4j.restartResponseFile")) != null) {
            try {
                InstallerVariables.loadResponseFile(new File((String)object), false, Collections.EMPTY_LIST);
            }
            catch (IOException iOException) {
                System.err.println("Could not read restart response file file " + (String)object);
                InstallerUtil.exit(1);
            }
        }
        if (properties != null) {
            InstallerVariables.addCommandLineVariables(properties, false, Collections.EMPTY_LIST);
        }
    }

    public static void setInstallationDirectoryFromCommandLine(boolean bl) {
        installationDirectoryFromCommandLine = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadResponseFile(File file, boolean bl, List list) throws IOException {
        InputStream inputStream = null;
        try {
            inputStream = new BufferedInputStream(new FileInputStream(file.getAbsoluteFile()));
            Properties properties = new Properties();
            properties.load(inputStream);
            InstallerVariables.addCommandLineVariables(properties, bl, list);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    Logger.getInstance().log(iOException);
                }
            }
        }
    }

    private static File getMediaFile(File file) {
        String string;
        Map map;
        if (Util.isMacOS() && file != null && (map = VolumeInfo.getMountPointToDiskFile()) != null && (string = (String)map.get(file.getParentFile().getAbsolutePath())) != null) {
            return new File(string);
        }
        return file;
    }

    private static void addCommandLineVariables(Map map, boolean bl, List list) {
        HashSet<String> hashSet = new HashSet<String>(list);
        if (installationDirectoryFromCommandLine) {
            hashSet.add(VARIABLE_INSTALLATION_DIR);
        }
        Map map2 = VariableEncoding.decodeVariables(map, false);
        Iterator iterator = map2.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String string = (String)entry.getKey();
            if (string.equals("sys.programGroup.name")) {
                string = VARIABLE_PROGRAM_GROUP_NAME;
            }
            if (hashSet.contains(string)) continue;
            Object v = entry.getValue();
            if (bl) {
                ContextImpl.getSingleContextInt().setVariable(string, v);
                continue;
            }
            InstallerVariables.setVariable(string, v);
        }
    }

    public static void registerResponseFileVariable(final String string) {
        HelperCommunication.getInstance().executeAction(ExecutionContext.UNELEVATED, new RunAction(){

            protected void run(Context context) throws Exception {
                responseFileVariables.add(string);
            }
        });
    }

    public static void unregisterResponseFileVariable(final String string) {
        HelperCommunication.getInstance().executeAction(ExecutionContext.UNELEVATED, new RunAction(){

            protected void run(Context context) throws Exception {
                responseFileVariables.remove(string);
            }
        });
    }

    public static byte[] getResponseFileContent(final String[] stringArray) throws IOException {
        return (byte[])HelperCommunication.getInstance().fetchObject(ExecutionContext.UNELEVATED, new FetchObjectAction(){

            protected Object fetchValue(Context context) throws Exception {
                HashSet<String> hashSet = new HashSet<String>();
                if (stringArray != null) {
                    hashSet.addAll(Arrays.asList(stringArray));
                }
                Properties properties = new Properties();
                Object object = responseFileVariables.iterator();
                while (object.hasNext()) {
                    String string = (String)object.next();
                    if (hashSet.contains(string)) continue;
                    Object object2 = InstallerVariables.getVariable(string);
                    VariableEncoding.encodeVariable(properties, string, object2);
                }
                object = new ByteArrayOutputStream();
                properties.store((OutputStream)object, "install4j response file for " + InstallerConfig.getCurrentInstance().getApplicationNameWithVersion());
                return ((ByteArrayOutputStream)object).toByteArray();
            }
        });
    }

    static {
        installationDirectoryFromCommandLine = false;
        REMOVAL_CALLBACK = new VariableRemovalCallback();
        PLAIN_CALLBACK = new InstallerReplacementCallback();
        I18N_ONLY_CALLBACK = new InstallerReplacementCallback(){

            protected boolean isReplaceInstallerVariables() {
                return false;
            }
        };
        REGEXP_MATCH_CALLBACK = new StringUtil.ReplacementCallback(){

            public String getReplacement(String string, Object object) {
                String string2 = PLAIN_CALLBACK.getReplacement(string, object);
                if (string2 != null) {
                    return InstallerVariables.quoteRegexpSearch(string2);
                }
                return null;
            }
        };
        REGEXP_REPLACEMENT_CALLBACK = new StringUtil.ReplacementCallback(){

            public String getReplacement(String string, Object object) {
                String string2 = PLAIN_CALLBACK.getReplacement(string, object);
                if (string2 != null) {
                    return InstallerVariables.quoteRegexpReplacement(string2);
                }
                return null;
            }
        };
        PROPERTIES_FILE_CALLBACK = new StringUtil.ReplacementCallback(){

            public String getReplacement(String string, Object object) {
                String string2 = PLAIN_CALLBACK.getReplacement(string, object);
                if (string2 != null) {
                    return StringUtil.escapeForPropertyFile(string2, false, false);
                }
                return null;
            }
        };
    }

    public static interface DesignTimeVariableProcessor {
        public String replaceDesignTimeVariables(String var1);
    }

    private static class InstallerReplacementCallback
    implements StringUtil.ReplacementCallback {
        private InstallerReplacementCallback() {
        }

        public String getReplacement(String string, Object object) {
            VariableErrorHandlingDescriptor variableErrorHandlingDescriptor = (VariableErrorHandlingDescriptor)object;
            if (string.startsWith(InstallerVariables.I18N_PREFIX) && this.isReplaceI18nVariables()) {
                Object object2;
                String string2 = string.substring(InstallerVariables.I18N_PREFIX.length());
                Object[] objectArray = null;
                int n = string2.indexOf(40);
                if (n > 0 && string2.endsWith(")")) {
                    object2 = string2.substring(n + 1, string2.length() - 1);
                    objectArray = InstallerVariables.getArguments((String)object2);
                    string2 = string2.substring(0, n);
                }
                try {
                    object2 = Messages.getMessages();
                    if (!this.isReplaceInstallerVariables()) {
                        ((VariableResourceBundleWrapper)object2).setNextReplacementMode(ReplacementMode.I18N_ONLY);
                    }
                    String string3 = ((ResourceBundle)object2).getString(string2);
                    if (objectArray == null) {
                        return string3;
                    }
                    return MessageFormat.format(string3, objectArray);
                }
                catch (MissingResourceException missingResourceException) {
                    return this.handleError("i18n key", string2, string, variableErrorHandlingDescriptor.getI18nKeys());
                }
            }
            if (string.startsWith(InstallerVariables.INSTALLER_PREFIX) && this.isReplaceInstallerVariables()) {
                String string4 = string.substring(InstallerVariables.INSTALLER_PREFIX.length());
                String string5 = InstallerVariables.getStringVariable(string4);
                if (string5 == null) {
                    return this.handleError("installer variable", string4, string, variableErrorHandlingDescriptor.getInstallerVariables());
                }
                return string5;
            }
            if (string.startsWith(InstallerVariables.COMPILER_PREFIX) && this.isReplaceCompilerVariables()) {
                String string6 = string.substring(InstallerVariables.COMPILER_PREFIX.length());
                String string7 = ContextImpl.getSingleContextInt().getCompilerVariable(string6);
                if (string7 == null) {
                    return this.handleError("compiler variable", string6, string, variableErrorHandlingDescriptor.getCompilerVariables());
                }
                return string7;
            }
            return null;
        }

        private String handleError(String string, String string2, String string3, VariableErrorHandling variableErrorHandling) {
            if (variableErrorHandling == VariableErrorHandling.ERROR_MESSAGE) {
                return "ERROR: Unresolved " + string + " \"" + string2 + "\"";
            }
            if (variableErrorHandling == VariableErrorHandling.EXCEPTION) {
                throw new UndefinedVariableException(string3);
            }
            return null;
        }

        protected boolean isReplaceI18nVariables() {
            return replaceI18nVariables;
        }

        protected boolean isReplaceInstallerVariables() {
            return replaceInstallerAndCompilerVariables;
        }

        protected boolean isReplaceCompilerVariables() {
            return replaceInstallerAndCompilerVariables;
        }
    }

    public static interface VariableProvider {
        public Object getVariable();

        public void setVariable(Object var1);
    }

    private static class VariableRemovalCallback
    implements StringUtil.ReplacementCallback {
        private VariableRemovalCallback() {
        }

        public String getReplacement(String string, Object object) {
            if (string.startsWith(InstallerVariables.I18N_PREFIX) || string.startsWith(InstallerVariables.INSTALLER_PREFIX) || string.startsWith(InstallerVariables.COMPILER_PREFIX)) {
                return "";
            }
            return null;
        }
    }
}

