/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer;

import com.exe4j.runtime.util.FileUtil;
import com.install4j.api.ApplicationRegistry;
import com.install4j.api.Util;
import com.install4j.api.actions.Action;
import com.install4j.api.actions.AutoUninstallAction;
import com.install4j.api.actions.InstallAction;
import com.install4j.api.beans.ExternalFile;
import com.install4j.api.context.Context;
import com.install4j.api.context.FileOptions;
import com.install4j.api.context.InstallerContext;
import com.install4j.api.context.ProgressInterface;
import com.install4j.api.context.UninstallMode;
import com.install4j.api.context.UserCanceledException;
import com.install4j.api.screens.InstallerScreen;
import com.install4j.api.screens.Screen;
import com.install4j.api.windows.RegistryRoot;
import com.install4j.api.windows.WinRegistry;
import com.install4j.runtime.beans.AutoUninstallHandler;
import com.install4j.runtime.beans.actions.InstallFilesAction;
import com.install4j.runtime.beans.actions.services.InstallServiceAction;
import com.install4j.runtime.installer.ContextImpl;
import com.install4j.runtime.installer.InstallerVariables;
import com.install4j.runtime.installer.WrapperInstallerContext;
import com.install4j.runtime.installer.config.AbstractBeanConfig;
import com.install4j.runtime.installer.config.ActionBeanConfig;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.config.LanguageConfig;
import com.install4j.runtime.installer.config.ScreenBeanConfig;
import com.install4j.runtime.installer.controller.ScreenExecutor;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.installer.frontend.ProgressAdapter;
import com.install4j.runtime.installer.helper.ClasspathModificator;
import com.install4j.runtime.installer.helper.InstallationProperties;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.comm.HelperCommunication;
import com.install4j.runtime.installer.helper.comm.actions.FetchObjectAction;
import com.install4j.runtime.installer.helper.comm.actions.RunAction;
import com.install4j.runtime.installer.helper.content.ContentInstaller;
import com.install4j.runtime.installer.helper.fileinst.FileInstaller;
import com.install4j.runtime.installer.helper.registry.InstallRegistry;
import com.install4j.runtime.installer.helper.versionspecific.VersionSpecificHelper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class InstallerContextImpl
extends ContextImpl
implements InstallerContext {
    private static final String REGKEY_INSTALL4J = "SOFTWARE\\ej-technologies\\install4j\\";
    private static final String REGVAL_REBOOT_CHECK_FILE = "RebootCheckFile";
    private List autoUninstallActions = new ArrayList();
    private static final String LOG_FILE_NAME = "installation.log";
    public static final String RESPONSE_FILE_NAME = "response.varfile";
    private Map idNamespaceToContext = new HashMap();
    private boolean updateInstallation;
    private File additionalUserJarsDir;
    private boolean keepAdditionalUserJars;

    public InstallerContextImpl(ScreenExecutor screenExecutor) {
        super(screenExecutor);
        InstallerVariables.registerVariableProvider("sys.installationDir", new InstallerVariables.VariableProvider(){

            public Object getVariable() {
                return InstallerContextImpl.this.getInstallationDirectory().getPath();
            }

            public void setVariable(Object object) {
                if (object != null && object instanceof String) {
                    InstallerContextImpl.this.setInstallationDirectory(new File((String)object), false);
                }
            }
        });
        InstallerVariables.registerResponseFileVariable("sys.installationDir");
        this.initUpdateInstallation();
    }

    public File getAdditionalUserJarsDir() {
        return this.additionalUserJarsDir;
    }

    public File getInstallerFile() {
        String string = System.getProperty("exe4j.moduleName");
        if (string == null) {
            return null;
        }
        return new File(string);
    }

    public String getMediaName() {
        return InstallerConfig.getCurrentInstance().getMediaName();
    }

    public void applyToScreen(Screen screen, ScreenBeanConfig screenBeanConfig) {
        if (screen instanceof InstallerScreen) {
            ((InstallerScreen)screen).setInstallerContext(this.getIdWrapperInstallerContext(screenBeanConfig));
        }
    }

    public Context getIdWrapperContext(AbstractBeanConfig abstractBeanConfig) {
        return this.getIdWrapperInstallerContext(abstractBeanConfig);
    }

    private InstallerContext getIdWrapperInstallerContext(AbstractBeanConfig abstractBeanConfig) {
        String string = abstractBeanConfig.getIdNamespace();
        if (string.length() == 0) {
            return this;
        }
        InstallerContext installerContext = (InstallerContext)this.idNamespaceToContext.get(string);
        if (installerContext == null) {
            installerContext = new WrapperInstallerContext(this, string);
            this.idNamespaceToContext.put(string, installerContext);
        }
        return installerContext;
    }

    public boolean installFile(File file, File file2) throws UserCanceledException {
        return FileInstaller.getInstance().install(file, file2);
    }

    public boolean installFile(File file, File file2, FileOptions fileOptions) throws UserCanceledException {
        return FileInstaller.getInstance().install(file, file2, fileOptions);
    }

    public void registerUninstallFile(File file) {
        FileInstaller.getInstance().registerUninstallFile(file);
    }

    public boolean installFile(File file, File file2, FileOptions fileOptions, ProgressInterface progressInterface, int n, int n2) throws UserCanceledException {
        if (progressInterface != null) {
            progressInterface = new ProgressAdapter(progressInterface, n, n2);
        }
        return FileInstaller.getInstance().install(file, file2, fileOptions, progressInterface);
    }

    public void installDirectory(File file, UninstallMode uninstallMode) {
        FileInstaller.getInstance().createDirectory(file, uninstallMode);
    }

    public boolean performActionInt(ActionBeanConfig actionBeanConfig) throws UserCanceledException {
        InstallerContext installerContext = this.getIdWrapperInstallerContext(actionBeanConfig);
        boolean bl = InstallerContextImpl.performActionIntStatic(actionBeanConfig, installerContext);
        Action action = actionBeanConfig.getOrInstantiateAction(false);
        if (bl && action instanceof AutoUninstallAction) {
            this.autoUninstallActions.add(action);
        }
        return bl;
    }

    private static boolean performActionIntStatic(ActionBeanConfig actionBeanConfig, InstallerContext installerContext) throws UserCanceledException {
        ContextImpl.setCurrentContext(installerContext);
        final Action action = actionBeanConfig.getOrInstantiateAction(false);
        try {
            boolean bl = InstallerContextImpl.handlePostActionExecutionState(actionBeanConfig, (ContextImpl.PostActionExecutionState)HelperCommunication.getInstance().fetchObjectChecked(actionBeanConfig.getExecutionContext(), new FetchObjectAction(){

                protected Object fetchValue(Context context) throws UserCanceledException {
                    boolean bl = ((InstallAction)action).install((InstallerContext)context);
                    return new ContextImpl.PostActionExecutionState(action, bl);
                }
            }));
            return bl;
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        finally {
            ContextImpl.setCurrentContext(null);
        }
    }

    public void rollbackActionInt(ActionBeanConfig actionBeanConfig) {
        Action action = actionBeanConfig.getOrInstantiateAction(false);
        InstallerContext installerContext = this.getIdWrapperInstallerContext(actionBeanConfig);
        InstallerContextImpl.rollbackActionIntStatic(actionBeanConfig, (InstallAction)action, installerContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void rollbackActionIntStatic(ActionBeanConfig actionBeanConfig, final InstallAction installAction, InstallerContext installerContext) {
        ContextImpl.setCurrentContext(installerContext);
        try {
            HelperCommunication.getInstance().executeAction(actionBeanConfig.getExecutionContext(), new RunAction(){

                protected void run(Context context) {
                    installAction.rollback((InstallerContext)context);
                }
            });
        }
        finally {
            ContextImpl.setCurrentContext(null);
        }
    }

    public String getLanguageId() {
        if (super.getLanguageId() == null) {
            InstallerConfig installerConfig = InstallerConfig.getCurrentInstance();
            List list = installerConfig.getLanguages();
            if (list.size() == 1) {
                this.setLanguageId(((LanguageConfig)list.get(0)).getId());
            } else if (installerConfig.isSkipLanguageSelection() || this.isUnattended() || installerConfig.isArchive()) {
                String string = InstallerUtil.getSupportedSystemLanguageId();
                if (string != null) {
                    this.setLanguageId(string);
                } else if (this.isUnattended() || installerConfig.isArchive()) {
                    this.setLanguageId(((LanguageConfig)InstallerConfig.getCurrentInstance().getLanguages().get(0)).getId());
                }
            }
        }
        return super.getLanguageId();
    }

    public boolean checkStart() {
        boolean bl;
        if (Util.isWindows() && InstallerConfig.isInstaller()) {
            if (this.checkReboot(RegistryRoot.HKEY_CURRENT_USER)) {
                return false;
            }
            if (this.checkReboot(RegistryRoot.HKEY_LOCAL_MACHINE)) {
                return false;
            }
        }
        if ((bl = super.checkStart()) && (Util.isMacosInstaller() || Util.isUnixInstaller())) {
            this.unpackAdditionalUserFiles();
        }
        return bl;
    }

    private void unpackAdditionalUserFiles() {
        String string = System.getProperty("install4j.addUserDir");
        if (string != null) {
            this.additionalUserJarsDir = new File(string);
        } else {
            File[] fileArray = InstallerUtil.getInstallerFile("user").listFiles();
            if (fileArray != null) {
                int n;
                boolean bl = false;
                for (n = 0; n < fileArray.length; ++n) {
                    if (!fileArray[n].getName().endsWith(".pack")) continue;
                    bl = true;
                    break;
                }
                if (bl) {
                    try {
                        File file = File.createTempFile("i4jau", "");
                        this.additionalUserJarsDir = new File(file.getAbsolutePath() + ".dir");
                        while (!this.additionalUserJarsDir.mkdir()) {
                            file.deleteOnExit();
                            file = File.createTempFile("i4jau", "");
                            this.additionalUserJarsDir = new File(file.getAbsolutePath() + ".dir");
                        }
                        file.delete();
                        for (int i = 0; i < fileArray.length; ++i) {
                            File file2;
                            String string2 = fileArray[i].getName();
                            if (string2.endsWith(".pack")) {
                                file2 = new File(this.additionalUserJarsDir, string2.substring(0, string2.length() - ".pack".length()));
                                if (!VersionSpecificHelper.unpack(fileArray[i], file2, null)) {
                                    FileUtil.copyFile(fileArray[i], file2);
                                }
                            } else {
                                file2 = new File(this.additionalUserJarsDir, string2);
                                FileUtil.copyFile(fileArray[i], file2);
                            }
                            if (!file2.getName().endsWith(".jar") && !file2.getName().endsWith(".zip")) continue;
                            ClasspathModificator.addClassPath(file2);
                        }
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                } else {
                    for (n = 0; n < fileArray.length; ++n) {
                        if (!fileArray[n].getName().endsWith(".jar") && !fileArray[n].getName().endsWith(".zip")) continue;
                        ClasspathModificator.addClassPath(fileArray[n]);
                    }
                }
            }
        }
    }

    private boolean checkReboot(RegistryRoot registryRoot) {
        String string = (String)WinRegistry.getValue(registryRoot, REGKEY_INSTALL4J, REGVAL_REBOOT_CHECK_FILE);
        if (string != null) {
            if (new File(string).exists()) {
                String string2 = MessageFormat.format(Messages.getMessages().getString("PreviousInstallNotCompleted"), InstallerConfig.getCurrentInstance().getApplicationNameWithVersion());
                Util.showMessage(string2, 2);
                return true;
            }
            WinRegistry.deleteValue(registryRoot, REGKEY_INSTALL4J, REGVAL_REBOOT_CHECK_FILE);
        }
        return false;
    }

    public void exit(int n) {
        if (this.additionalUserJarsDir != null && !this.keepAdditionalUserJars) {
            FileUtil.deleteDirectory(this.additionalUserJarsDir);
        }
        super.exit(n);
    }

    public void finish(int n) {
        block8: {
            try {
                Object object;
                InstallerConfig installerConfig = InstallerConfig.getCurrentInstance();
                if (InstallerConfig.isInstaller()) {
                    object = null;
                    if (Util.isMacosInstaller() && installerConfig.getMacSpecificConfig().isSingleBundle()) {
                        object = installerConfig.getMacSpecificConfig().getSingleBundleName();
                    }
                    InstallRegistry.registerApplication(installerConfig.getApplicationId(), installerConfig.getInstallationDirectory(), (String)object);
                }
                object = this.getRuntimeDirectory();
                String string = "";
                if (InstallerConfig.getCurrentInstance().isAddOnInstaller()) {
                    string = "." + InstallerConfig.getCurrentInstance().getProjectCrc();
                }
                File file = new File((File)object, LOG_FILE_NAME + string);
                File file2 = new File((File)object, RESPONSE_FILE_NAME + string);
                byte[] byArray = null;
                if (((File)object).exists()) {
                    InstallationProperties installationProperties = null;
                    if (InstallerConfig.isInstaller() && !Boolean.getBoolean("install4j.dontStoreInstallationLog")) {
                        installationProperties = this.finishInstallationProperties();
                        FileInstaller.getInstance().registerUninstallFile(file);
                        Logger.getImpl().setFinalLogFile(file);
                        byArray = InstallerVariables.getResponseFileContent(null);
                        FileInstaller.getInstance().registerUninstallFile(file2);
                    }
                    byte[] byArray2 = AutoUninstallHandler.getPropertyFileBytes(this.autoUninstallActions);
                    InstallerContextImpl.writeFinalRuntimeContent(byArray2, (File)object, file2, byArray, installationProperties);
                    FileInstaller.getInstance().setLogDir(this.getDestinationFile(".install4j"));
                    FileInstaller.getInstance().writeLog();
                }
            }
            catch (UserCanceledException userCanceledException) {
            }
            catch (IOException iOException) {
                if (!InstallerConfig.isInstaller() || this.getFirstAction(InstallFilesAction.class, null) == null) break block8;
                this.handleCriticalException(iOException);
            }
        }
        super.finish(n);
    }

    private static void writeFinalRuntimeContent(final byte[] byArray, final File file, final File file2, final byte[] byArray2, final InstallationProperties installationProperties) throws IOException, UserCanceledException {
        final String string = System.getProperty("install4j.runtimeAccessMode");
        HelperCommunication.getInstance().executeActionChecked(ContentInstaller.getExecutionContext(), new RunAction(){

            protected void run(Context context) throws IOException {
                if (installationProperties != null) {
                    installationProperties.store(file);
                }
                AutoUninstallHandler.writeFile(byArray, file);
                if (byArray2 != null && file2 != null) {
                    FileOutputStream fileOutputStream = new FileOutputStream(file2);
                    fileOutputStream.write(byArray2);
                    fileOutputStream.close();
                }
                if (string != null && !Util.isWindows()) {
                    VersionSpecificHelper.setPosixFilePermissionsRecursive(file, string);
                }
            }
        });
    }

    private InstallationProperties finishInstallationProperties() throws IOException {
        Object object;
        InstallationProperties installationProperties = this.getInstallationProperties();
        installationProperties.setLanguageId(this.getLanguageId());
        InstallerConfig installerConfig = InstallerConfig.getCurrentInstance();
        ArrayList arrayList = new ArrayList(installerConfig.getFileOptionsConfig().getLaunchers());
        Iterator iterator = InstallServiceAction.getInstalledServices().iterator();
        while (iterator.hasNext()) {
            object = (InstallServiceAction.Info)iterator.next();
            arrayList.remove(((InstallServiceAction.Info)object).getExecutable());
            installationProperties.addStringToSet("serviceName", ((InstallServiceAction.Info)object).getServiceName());
        }
        iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            installationProperties.addFileToSet("launcher", this.getDestinationFile((String)object));
        }
        return installationProperties;
    }

    public void setInstallationDirectory(File file) {
        this.setInstallationDirectory(file, true);
    }

    public boolean isUpdateInstallation() {
        return this.updateInstallation;
    }

    private void initUpdateInstallation() {
        this.updateInstallation = ApplicationRegistry.isUpdateDirectory(this.getInstallationDirectory());
    }

    public void setInstallationDirectory(File file, boolean bl) {
        InstallerConfig installerConfig = InstallerConfig.getCurrentInstance();
        File file2 = installerConfig.getInstallationDirectory();
        installerConfig.setInstallationDirectory(file);
        if (!file2.equals(file)) {
            this.initUpdateInstallation();
            if (bl) {
                this.variableChanged("sys.installationDir");
            }
        }
    }

    public File getExternalFile(ExternalFile externalFile, boolean bl) {
        if (bl || InstallerContextImpl.isDistributionExternal(externalFile) || !InstallerConfig.isInstaller()) {
            return super.getExternalFile(externalFile, bl);
        }
        if (externalFile == null || externalFile.getPath().trim().length() == 0) {
            return null;
        }
        return externalFile.getAbsoluteFile();
    }

    protected String getRebootMessageId() {
        return "FinishedRestartMessage";
    }

    public void setKeepAdditionalUserJars(boolean bl) {
        this.keepAdditionalUserJars = bl;
    }
}

