/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.screens.components;

import com.install4j.api.SystemInfo;
import com.install4j.api.Util;
import com.install4j.api.beans.Bean;
import com.install4j.api.beans.ScriptProperty;
import com.install4j.api.context.Context;
import com.install4j.api.context.InstallerContext;
import com.install4j.api.context.UserCanceledException;
import com.install4j.api.events.InstallerEvent;
import com.install4j.api.events.InstallerEventListener;
import com.install4j.api.events.InstallerVariableEvent;
import com.install4j.api.formcomponents.FormEnvironment;
import com.install4j.api.screens.Console;
import com.install4j.runtime.installer.ContextImpl;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.installer.frontend.components.DirectorySelector;
import com.install4j.runtime.installer.frontend.components.FileValidator;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.content.ContentInstaller;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.MissingResourceException;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class InstallationDirectorySelector
extends JPanel
implements DirectorySelector.InternalValidator,
FileValidator {
    private JLabel lblSpace;
    private JLabel lblFreeSpace;
    private boolean showRequiredDiskSpace = true;
    private boolean showFreeDiskSpace = true;
    private boolean checkFreeSpace = true;
    private boolean suggestAppDir = true;
    private boolean existingDirWarning = true;
    private boolean validateApplicationId = true;
    private boolean allowSpacesOnUnix = false;
    private boolean manualEntryAllowed = true;
    private boolean allowNewFolderCreation = false;
    private ScriptProperty validationScript;
    private boolean compact = false;
    private DirectorySelector directorySelector;
    private boolean initialized;
    private Context context;
    private FormEnvironment formEnvironment;
    private Bean bean;
    private boolean designTime;

    public InstallationDirectorySelector(Bean bean) {
        this.bean = bean;
    }

    public void setDesignTime(boolean bl) {
        this.designTime = bl;
    }

    public void createComponent() {
        this.removeAll();
        this.setupControls();
        this.setupComponent();
    }

    public boolean isShowRequiredDiskSpace() {
        return this.showRequiredDiskSpace;
    }

    public void setShowRequiredDiskSpace(boolean bl) {
        this.showRequiredDiskSpace = bl;
    }

    public boolean isShowFreeDiskSpace() {
        return this.showFreeDiskSpace;
    }

    public void setShowFreeDiskSpace(boolean bl) {
        this.showFreeDiskSpace = bl;
    }

    public boolean isCheckFreeSpace() {
        return this.checkFreeSpace;
    }

    public void setCheckFreeSpace(boolean bl) {
        this.checkFreeSpace = bl;
    }

    public boolean isSuggestAppDir() {
        return this.suggestAppDir;
    }

    public void setSuggestAppDir(boolean bl) {
        this.suggestAppDir = bl;
    }

    public boolean isExistingDirWarning() {
        return this.existingDirWarning;
    }

    public void setExistingDirWarning(boolean bl) {
        this.existingDirWarning = bl;
    }

    public boolean isValidateApplicationId() {
        return this.validateApplicationId;
    }

    public void setValidateApplicationId(boolean bl) {
        this.validateApplicationId = bl;
    }

    public boolean isAllowSpacesOnUnix() {
        return this.allowSpacesOnUnix;
    }

    public void setAllowSpacesOnUnix(boolean bl) {
        this.allowSpacesOnUnix = bl;
    }

    public ScriptProperty getValidationScript() {
        return this.validationScript;
    }

    public void setValidationScript(ScriptProperty scriptProperty) {
        this.validationScript = scriptProperty;
    }

    public boolean isAllowNewFolderCreation() {
        return this.allowNewFolderCreation;
    }

    public void setAllowNewFolderCreation(boolean bl) {
        this.allowNewFolderCreation = bl;
    }

    public boolean isManualEntryAllowed() {
        return this.manualEntryAllowed;
    }

    public void setManualEntryAllowed(boolean bl) {
        this.manualEntryAllowed = bl;
    }

    public boolean isCompact() {
        return this.compact;
    }

    public void setCompact(boolean bl) {
        this.compact = bl;
    }

    public void update() {
        this.init();
        if (this.lblSpace != null) {
            long l = this.designTime ? 0L : (long)((double)ContentInstaller.getInstance().getMinSize() * (Boolean.getBoolean("install4j.allSizesWithSafety") ? 1.1 : 1.0));
            String string = MessageFormat.format(this.getMessage("ComponentSize2"), this.getMB(l, new DecimalFormat("#,###,##0.0")));
            this.lblSpace.setText(string);
        }
        if (this.lblFreeSpace != null) {
            String string = MessageFormat.format(this.getMessage("ComponentSize2"), this.getMB(this.designTime ? 0L : SystemInfo.getFreeDiskSpace(this.directorySelector.getSelectedFile()), new DecimalFormat("#,###,##0")));
            this.lblFreeSpace.setText(string);
        }
    }

    private void init() {
        if (!this.initialized && !this.designTime) {
            String string;
            File file;
            File file2 = this.context.getInstallationDirectory();
            InstallerConfig installerConfig = InstallerConfig.getCurrentInstance();
            if (!(!this.suggestAppDir || installerConfig.isAddOnInstaller() || Util.isMacosInstaller() && installerConfig.getMacSpecificConfig().isSingleBundle())) {
                file = file2.getParentFile();
                string = file2.getName();
            } else {
                file = file2;
                string = null;
            }
            if (file == null) {
                file = file2;
                string = installerConfig.getApplicationName();
            }
            this.directorySelector.initDirectory(file, string);
            this.directorySelector.setNoStandardDirectoryNameForUpdate(true);
            this.directorySelector.setAllowSpacesOnUnix(this.allowSpacesOnUnix);
            this.directorySelector.setAllowNewFolderCreation(this.allowNewFolderCreation);
            this.directorySelector.setManualEntryAllowed(this.manualEntryAllowed);
            this.initialized = true;
        }
    }

    private void setupControls() {
        this.ensureDirectorySelectorCreated();
        this.directorySelector.activateNextScreenOnEnter(this.context.getWizardContext());
        this.directorySelector.addPropertyChangeListener("selectedPath", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                InstallationDirectorySelector.this.update();
            }
        });
    }

    private void ensureDirectorySelectorCreated() {
        if (this.directorySelector == null) {
            this.directorySelector = new DirectorySelector(this.compact ? null : this.getMessage("ReadyMemoDir").replace(':', ' ').trim(), this.designTime);
            this.directorySelector.setInternalValidator(this);
            this.directorySelector.setValidator(this);
        }
    }

    private void setupComponent() {
        this.setOpaque(false);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        if (this.showRequiredDiskSpace || this.showFreeDiskSpace) {
            gridBagConstraints.insets.bottom = 5;
        }
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 2;
        this.add((Component)this.directorySelector, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        if (this.showRequiredDiskSpace) {
            this.lblSpace = this.addLabel("RequiredDiskSpaceLabel", gridBagConstraints);
        }
        if (this.showFreeDiskSpace && (Util.isWindows() || Util.isMacOS() || Util.isLinux())) {
            this.lblFreeSpace = this.addLabel("FreeDiskSpaceLabel", gridBagConstraints);
        }
        this.update();
    }

    private JLabel addLabel(String string, GridBagConstraints gridBagConstraints) {
        JLabel jLabel = new JLabel();
        gridBagConstraints.insets.right = 5;
        this.add((Component)new JLabel(this.getMessage(string)), gridBagConstraints);
        gridBagConstraints.insets.right = 0;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)jLabel, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        return jLabel;
    }

    private String getMB(long l, NumberFormat numberFormat) {
        double d = (double)l / 1048576.0;
        if (d < 0.0) {
            d = 0.0;
        }
        return numberFormat.format(d);
    }

    private String getMessage(String string) throws MissingResourceException {
        return Messages.getMessages().getString(string);
    }

    public void setContext(Context context) {
        this.context = context;
        context.addInstallerEventListener(new InstallerEventListener(){

            public void installerEvent(InstallerEvent installerEvent) {
                if (!InstallationDirectorySelector.this.context.isConsole() && !InstallationDirectorySelector.this.context.isUnattended() && installerEvent instanceof InstallerVariableEvent && ((InstallerVariableEvent)installerEvent).getVariableName().equals("sys.installationDir")) {
                    InstallationDirectorySelector.this.init();
                    InstallationDirectorySelector.this.directorySelector.setDirectory(InstallationDirectorySelector.this.context.getInstallationDirectory());
                }
            }
        });
    }

    public void setFormEnvironment(FormEnvironment formEnvironment) {
        this.formEnvironment = formEnvironment;
    }

    public File validateInternally(File file) {
        return ContentInstaller.validateInstallationDir(file, this.validateApplicationId, this.checkFreeSpace, this.existingDirWarning, this.context.isUnattended(), false);
    }

    public boolean isValidFile(File file) {
        if (this.validationScript != null) {
            Object[] objectArray = this.formEnvironment != null ? new Object[]{file, this.formEnvironment} : new Object[]{file};
            return ContextImpl.getContextInt(this.context).runBooleanScript(this.validationScript.getValue(), this.bean, objectArray);
        }
        return true;
    }

    private File getSelectedDir() {
        this.init();
        return this.directorySelector.getSelectedFile();
    }

    public boolean handleUnattended() {
        File file = this.validateInternally(this.context.getInstallationDirectory());
        if (file == null || !InstallerUtil.checkWritableInstallationDirectory(file, true)) {
            Util.showMessage(Messages.getMessages().getString("DestinationDirHelp"), 1);
            return false;
        }
        if (!Boolean.getBoolean("install4j.extraSilent")) {
            Util.showMessage(MessageFormat.format(Messages.getMessages().getString("UnattendedInstallationDir"), file), 1);
        }
        if (this.context instanceof InstallerContext) {
            ((InstallerContext)this.context).setInstallationDirectory(file);
        }
        return true;
    }

    public boolean handleConsole(Console console) throws UserCanceledException {
        this.ensureDirectorySelectorCreated();
        while (true) {
            String string = this.context.getInstallationDirectory().getAbsolutePath();
            String string2 = console.askString(MessageFormat.format(this.getMessage("SelectDirDesc"), InstallerConfig.getCurrentInstance().getApplicationName()), string);
            try {
                File file = new File(string2).getCanonicalFile();
                this.directorySelector.setSelectedFile(file);
                if (!new File(string2).isAbsolute() || file.exists() && !file.isDirectory()) {
                    console.println(MessageFormat.format(this.getMessage("InvalidDirectory"), string2));
                    continue;
                }
                if (!this.directorySelector.checkSelectedFile() || (file = this.directorySelector.getSelectedFile()) == null || !InstallerUtil.checkWritableInstallationDirectory(file, true)) continue;
                if (this.context instanceof InstallerContext) {
                    ((InstallerContext)this.context).setInstallationDirectory(file);
                }
                return true;
            }
            catch (IOException iOException) {
                console.println(MessageFormat.format(this.getMessage("InvalidDirectory"), string2));
                continue;
            }
            break;
        }
    }

    public DirectorySelector getDirectorySelector() {
        return this.directorySelector;
    }

    public void focusTextField() {
        this.directorySelector.focusTextField();
    }

    public boolean checkCompleted() {
        if (this.directorySelector.checkSelectedFile()) {
            File file = this.getSelectedDir();
            if (this.context instanceof InstallerContext) {
                ((InstallerContext)this.context).setInstallationDirectory(file);
            }
            return InstallerUtil.checkWritableInstallationDirectory(file, true);
        }
        return false;
    }

    public int getBaseline(int n, int n2) {
        return this.directorySelector.getBaseline(n, n2);
    }
}

