/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.screens;

import com.install4j.api.context.InstallerContext;
import com.install4j.api.context.UserCanceledException;
import com.install4j.api.formcomponents.FormEnvironment;
import com.install4j.api.screens.Console;
import com.install4j.api.screens.FormPanelContainer;
import com.install4j.runtime.beans.screens.BannerScreen;
import com.install4j.runtime.beans.screens.UpdatePanel;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.util.DisplayTextArea;
import com.install4j.runtime.util.HorizontalShrinkWrapper;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.text.MessageFormat;
import javax.swing.JPanel;

public class WelcomeScreen
extends BannerScreen
implements FormPanelContainer {
    private boolean updateCheck = true;
    private UpdatePanel updatePanel;
    private DisplayTextArea welcomeTextArea;
    private JPanel formPanel;
    private FormEnvironment formEnvironment;

    public boolean isUpdateCheck() {
        return this.updateCheck;
    }

    public void setUpdateCheck(boolean bl) {
        this.updateCheck = bl;
    }

    public boolean isPreviousVisible() {
        return false;
    }

    public void activated() {
        if (this.updatePanel != null && !InstallerUtil.checkWritableInstallationDirectory(this.getContext().getInstallationDirectory(), false)) {
            this.updatePanel.setVisible(false);
        }
        this.welcomeTextArea.setText(MessageFormat.format(WelcomeScreen.replaceVariables(this.getMessage(this.isAskForUpdate() ? "ConsoleWelcomeLabel" : "WelcomeLabel3")), this.getApplicationName()));
        super.activated();
        try {
            Logger.getInstance().log(this, "thread name " + Thread.currentThread().getName(), true);
        }
        catch (Throwable throwable) {
            Logger.getInstance().log(throwable);
        }
    }

    private boolean isAskForUpdate() {
        return this.updatePanel != null && this.updatePanel.isVisible();
    }

    protected void addScreenContent(JPanel jPanel, GridBagConstraints gridBagConstraints) {
        InstallerContext installerContext = this.getInstallerContext();
        this.welcomeTextArea = this.addDisplayTextArea("", jPanel, gridBagConstraints);
        gridBagConstraints.insets.top = 0;
        if (installerContext != null && this.updateCheck && installerContext.isUpdateInstallation()) {
            this.updatePanel = new UpdatePanel(this.getInstallerContext());
            gridBagConstraints.fill = 2;
            jPanel.add((Component)this.updatePanel, gridBagConstraints);
            ++gridBagConstraints.gridy;
        }
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)new HorizontalShrinkWrapper(this.formPanel), gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.addDisplayTextArea("\n" + this.getMessage("ClickNext"), jPanel, gridBagConstraints);
        String string = this.getExtraMessage();
        if (string != null) {
            DisplayTextArea displayTextArea = this.addDisplayTextArea("\n" + string, jPanel, gridBagConstraints);
            displayTextArea.setFont(displayTextArea.getFont().deriveFont(1));
        }
    }

    protected boolean checkCompleted() {
        if (this.isAskForUpdate()) {
            this.getContext().setVariable("sys.confirmedUpdateInstallation", this.updatePanel.isUpdate());
        }
        return super.checkCompleted();
    }

    public boolean handleConsole(Console console) throws UserCanceledException {
        if (!super.handleConsole(console)) {
            return false;
        }
        if (!console.askOkCancel(MessageFormat.format(WelcomeScreen.replaceVariables(this.getMessage("ConsoleWelcomeLabel")) + this.getExtraMessage(), this.getApplicationName()), true)) {
            return false;
        }
        InstallerContext installerContext = this.getInstallerContext();
        if (this.updateCheck && installerContext != null && installerContext.isUpdateInstallation()) {
            int n = console.askOption(this.getMessage("PreviousInstallationLabel"), new String[]{this.getMessage("RadioUpdateInstallation"), this.getMessage("RadioNewInstallation")}, null, 0, false, true);
            this.getContext().setVariable("sys.confirmedUpdateInstallation", n == 0);
        }
        return this.formEnvironment.handleConsole(console);
    }

    public String getTitle() {
        return MessageFormat.format(this.getMessage("WelcomeLabel1"), this.getApplicationName());
    }

    public String getSubTitle() {
        return "";
    }

    private String getExtraMessage() {
        String string = InstallerConfig.getCurrentInstance().getStatus();
        if (string == null || !string.equals("LCOK")) {
            return "This installer was created with an evaluation version of install4j";
        }
        return "";
    }

    public void setFormPanel(JPanel jPanel, FormEnvironment formEnvironment) {
        this.formPanel = jPanel;
        this.formEnvironment = formEnvironment;
    }

    public boolean isScrollFormPanel() {
        return true;
    }

    public FormEnvironment getFormEnvironment() {
        return this.formEnvironment;
    }

    public boolean isFillVertical() {
        return false;
    }
}

