/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.api;

import com.install4j.api.context.Context;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.installer.InstallerVariables;
import com.install4j.runtime.installer.frontend.GUIHelper;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.comm.ExecutionContext;
import com.install4j.runtime.installer.helper.comm.HelperCommunication;
import com.install4j.runtime.installer.helper.comm.actions.FetchIntAction;
import com.install4j.runtime.installer.helper.comm.actions.RunAction;
import com.install4j.runtime.installer.platform.UserInfo;
import java.awt.Window;
import java.io.IOException;
import java.net.URL;
import java.util.Iterator;

public class Util {
    public static String getUserHome() {
        String string = InstallerVariables.getStringVariable("sys.userHome");
        if (string == null) {
            string = System.getProperty("user.home");
        }
        return string;
    }

    public static boolean isSolaris() {
        return InstallerUtil.isSolaris();
    }

    public static boolean isLinux() {
        return InstallerUtil.isLinux();
    }

    public static boolean isWindows() {
        return InstallerUtil.isWindows();
    }

    public static boolean isWindows9X() {
        return InstallerUtil.isWindows9X();
    }

    public static boolean isWindowsNT() {
        return InstallerUtil.isWindowsNT();
    }

    public static boolean isAtLeastWindowsVista() {
        return InstallerUtil.isAtLeastWindowsVista();
    }

    public static boolean isAtLeastWindows7() {
        return InstallerUtil.isAtLeastWindows7();
    }

    public static boolean isAtLeastWindowsXP() {
        return InstallerUtil.isAtLeastWindowsXP();
    }

    public static boolean isWindowsVista() {
        return InstallerUtil.isWindowsVista();
    }

    public static boolean isWindows7() {
        return InstallerUtil.isWindows7();
    }

    public static boolean isWindowsXP() {
        return InstallerUtil.isWindowsXP();
    }

    public static boolean isWindows2000() {
        return InstallerUtil.isWindows2000();
    }

    public static boolean isWindows2003() {
        return InstallerUtil.isWindows2003();
    }

    public static boolean isWindows2008() {
        return InstallerUtil.isWindows2008();
    }

    public static boolean is64BitWindows() {
        return Util.isWindows() && InstallerUtil.is64BitWindows();
    }

    public static boolean isMacOS() {
        return InstallerUtil.isMacOS();
    }

    public static boolean isHpux() {
        return InstallerUtil.isHpux();
    }

    public static boolean isAix() {
        return InstallerUtil.isAix();
    }

    public static boolean isWindowsInstaller() {
        return InstallerUtil.getInstallerType().equals("windows");
    }

    public static boolean isUnixInstaller() {
        return InstallerUtil.getInstallerType().equals("unix");
    }

    public static boolean isMacosInstaller() {
        return InstallerUtil.getInstallerType().equals("macos");
    }

    public static String getStandardApplicationsDirectory() {
        return InstallerUtil.getStandardApplicationsDirectory();
    }

    public static void showUrl(final URL uRL) {
        HelperCommunication.getInstance().executeAction(ExecutionContext.UNELEVATED, new RunAction(){

            protected void run(Context context) {
                GUIHelper.showURL(uRL.toExternalForm());
            }
        });
    }

    public static void showMessage(final String string, final int n) {
        HelperCommunication.getInstance().executeAction(ExecutionContext.UNELEVATED, new RunAction(){

            protected void run(Context context) {
                GUIHelper.showMessage(null, string, n);
            }
        });
    }

    public static void showMessage(String string) {
        Util.showMessage(string, 1);
    }

    public static void showErrorMessage(String string) {
        Util.showMessage(string, 0);
    }

    public static void showWarningMessage(String string) {
        Util.showMessage(string, 2);
    }

    public static int showOptionDialog(final String string, final String[] stringArray, final int n) throws UserCanceledException {
        try {
            return HelperCommunication.getInstance().fetchIntChecked(ExecutionContext.UNELEVATED, new FetchIntAction(){

                protected int fetchValue(Context context) throws UserCanceledException {
                    return GUIHelper.showOptionDialog(null, string, stringArray, n);
                }
            });
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public static void fatalError(final Throwable throwable) {
        try {
            HelperCommunication.getInstance().executeAction(ExecutionContext.UNELEVATED, new RunAction(){

                protected void run(Context context) throws Exception {
                    InstallerUtil.reportException(throwable);
                    InstallerUtil.exit(1);
                }
            });
        }
        catch (Throwable throwable2) {
            throwable2.printStackTrace();
        }
    }

    public static Window getParentWindow() {
        return GUIHelper.getParentWindow();
    }

    public static void logInfo(Object object, String string) {
        Logger.getInstance().info(object, string);
    }

    public static void logError(Object object, String string) {
        Logger.getInstance().error(object, string);
    }

    public static void log(Throwable throwable) {
        Logger.getInstance().log(throwable);
    }

    public static void dumpVariables(Context context) {
        System.err.println();
        System.err.println("Defined installer variables:");
        System.err.println("----------------------------");
        Iterator iterator = context.getVariableNames().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Object object = context.getVariable(string);
            System.err.println(InstallerUtil.getVerboseVariableDefinition(string, object));
        }
        System.err.println("----------------------------");
        System.err.println();
    }

    public static boolean isAdminUser() {
        return UserInfo.isAdminUser();
    }

    public static boolean isAdminGroup() {
        return UserInfo.isAdminGroup();
    }

    public static boolean hasFullAdminRights() {
        return UserInfo.hasFullAdminRights();
    }

    public static String getAnnotatedStackTrace(Throwable throwable) {
        return InstallerUtil.getAnnotatedStackTrace(throwable);
    }

    public static void printAnnotatedStackTrace(Throwable throwable) {
        System.err.print(Util.getAnnotatedStackTrace(throwable));
    }

    public static void showPath(final String string) {
        HelperCommunication.getInstance().executeAction(ExecutionContext.UNELEVATED, new RunAction(){

            protected void run(Context context) {
                GUIHelper.showPath(string);
            }
        });
    }
}

