/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.crafted.localisation.properties.extension;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.Optional;
import org.mule.runtime.properties.api.ConfigurationProperty;
import org.mule.runtime.properties.api.DefaultConfigurationPropertiesProvider;
import org.mule.runtime.properties.api.ResourceProvider;

public class LocalisationConfigurationPropertiesProvider
extends DefaultConfigurationPropertiesProvider {
    private static final String LOCALE_PREFIX = "locale::";
    private final String language;
    private final String region;

    public LocalisationConfigurationPropertiesProvider(ResourceProvider resourceProvider, String file, String locale) {
        super(file, resourceProvider);
        String[] localeElements = locale.split("_");
        this.language = localeElements[0];
        this.region = localeElements[1];
    }

    public Optional<ConfigurationProperty> provide(String configurationAttributeKey) {
        if (configurationAttributeKey.startsWith(LOCALE_PREFIX)) {
            final String effectiveKey = configurationAttributeKey.substring(LOCALE_PREFIX.length());
            final ConfigurationProperty property = (ConfigurationProperty)super.provide("language.pattern").get();
            return Optional.of(new ConfigurationProperty(){

                public Object getSource() {
                    return this;
                }

                public String getValue() {
                    NumberFormat nf = NumberFormat.getInstance(new Locale(LocalisationConfigurationPropertiesProvider.this.language, LocalisationConfigurationPropertiesProvider.this.region));
                    DecimalFormat formatter = (DecimalFormat)nf;
                    formatter.applyPattern(property.getValue());
                    return formatter.format(Double.parseDouble(effectiveKey));
                }

                public String getKey() {
                    return effectiveKey;
                }
            });
        }
        return Optional.empty();
    }

    protected String createValue(String key, String value) {
        return String.format("%s", value);
    }
}

