/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tests.internal;

import java.util.concurrent.TimeUnit;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Content;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.process.CompletionCallback;
import org.mule.tests.internal.NonBlockingConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NonBlockingOperations {
    private static final Logger LOGGER = LoggerFactory.getLogger(NonBlockingOperations.class);

    @MediaType(value="*/*", strict=false)
    public void nonBlocking(@Config NonBlockingConfiguration configuration, @Content(primary=true) @Optional(defaultValue="#[payload]") TypedValue<Object> content, @Optional Long delayMillis, CompletionCallback<Object, Object> callback) {
        Runnable command = () -> {
            LOGGER.debug("nonBlocking after");
            callback.success(Result.builder().output(content.getValue()).build());
        };
        LOGGER.debug("nonBlocking before");
        if (delayMillis == null) {
            configuration.getCustomScheduler().execute(command);
        } else {
            configuration.getCustomScheduler().schedule(command, delayMillis.longValue(), TimeUnit.MILLISECONDS);
        }
    }
}

