/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tests.internal;

import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashSet;
import java.util.Set;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.process.CompletionCallback;

public class StreamWithSizeOperation {
    private static final Set<String> THREADS = new LinkedHashSet<String>();

    @MediaType(value="*/*")
    public void nonBlockingResultWithSizedStream(String message, CompletionCallback<InputStream, Void> callback) {
        final byte[] messageBytes = message.getBytes();
        long length = messageBytes.length;
        InputStream inputStream = new InputStream(){
            private int idx = 0;

            @Override
            public int read() throws IOException {
                THREADS.add(Thread.currentThread().getName());
                if (this.idx == messageBytes.length) {
                    return -1;
                }
                return messageBytes[this.idx++];
            }
        };
        callback.success(Result.builder().output((Object)inputStream).length(length).build());
    }

    @MediaType(value="*/*", strict=false)
    public int sizedStreamThreadsCount() {
        return THREADS.size();
    }

    public void clearThreads() {
        THREADS.clear();
    }
}

