/*
 * Decompiled with CFR 0.152.
 */
package org.mule.functional.api.component;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.processor.Processor;

public class InvocationCountMessageProcessor
extends AbstractComponent
implements Processor,
Initialisable,
Startable {
    private static Map<String, AtomicInteger> invocationCountPerMessageProcessor = new HashMap<String, AtomicInteger>();
    private AtomicInteger invocationCount;
    private String name;

    public CoreEvent process(CoreEvent event) throws MuleException {
        this.invocationCount.incrementAndGet();
        return event;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void initialise() throws InitialisationException {
        this.invocationCount = invocationCountPerMessageProcessor.computeIfAbsent(this.name, k -> new AtomicInteger(0));
    }

    public void start() throws MuleException {
        this.invocationCount.set(0);
    }

    public static int getNumberOfInvocationsFor(String componentName) {
        AtomicInteger count = invocationCountPerMessageProcessor.get(componentName);
        if (count == null) {
            throw new IllegalArgumentException("No invocation-counter component registered under name: " + componentName + ", registered components: " + String.valueOf(invocationCountPerMessageProcessor.keySet()));
        }
        return count.get();
    }
}

