/*
 * Decompiled with CFR 0.152.
 */
package org.mule.functional.api.flow;

import org.junit.Assert;
import org.mule.functional.api.flow.TestEventBuilder;
import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.message.ItemSequenceInfo;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.message.GroupCorrelation;
import org.mule.runtime.core.internal.util.message.ItemSequenceInfoUtils;
import org.mule.runtime.core.privileged.event.BaseEventContext;

public abstract class FlowConstructRunner<R extends FlowConstructRunner>
implements Disposable {
    protected Registry registry;
    protected TestEventBuilder eventBuilder = new TestEventBuilder();
    private CoreEvent requestEvent;

    public R withPayload(Object payload) {
        this.eventBuilder.withPayload(payload);
        return (R)this;
    }

    public R withMediaType(MediaType mediaType) {
        this.eventBuilder.withMediaType(mediaType);
        return (R)this;
    }

    public R withAttributes(Object attributes) {
        this.eventBuilder.withAttributes(attributes);
        return (R)this;
    }

    public R withSourceCorrelationId(String sourceCorrelationId) {
        this.eventBuilder.withSourceCorrelationId(sourceCorrelationId);
        return (R)this;
    }

    @Deprecated
    public R withCorrelation(GroupCorrelation correlation) {
        return this.withItemSequenceInfo(ItemSequenceInfoUtils.fromGroupCorrelation((GroupCorrelation)correlation));
    }

    public R withItemSequenceInfo(ItemSequenceInfo itemSequenceInfo) {
        this.eventBuilder.withItemSequenceInfo(itemSequenceInfo);
        return (R)this;
    }

    public R withVariable(String key, Object value) {
        this.eventBuilder.withVariable(key, value);
        return (R)this;
    }

    public R withVariable(String key, Object value, DataType dataType) {
        this.eventBuilder.withVariable(key, value, dataType);
        return (R)this;
    }

    public R spyObjects() {
        this.eventBuilder.spyObjects();
        return (R)this;
    }

    public FlowConstructRunner(Registry registry) {
        this.registry = registry;
    }

    protected CoreEvent getOrBuildEvent() {
        if (this.requestEvent == null) {
            this.doBuildEvent();
        }
        return this.requestEvent;
    }

    public CoreEvent buildEvent() {
        if (this.requestEvent == null) {
            this.doBuildEvent();
            return this.requestEvent;
        }
        Assert.fail((String)"An event has already been build. Maybe you forgot to call reset()?");
        return null;
    }

    private void doBuildEvent() {
        FlowConstruct flow = this.getFlowConstruct();
        this.requestEvent = this.eventBuilder.build(flow);
    }

    protected FlowConstruct getFlowConstruct() {
        return (FlowConstruct)this.registry.lookupByName(this.getFlowConstructName()).orElseThrow(() -> new NullPointerException(String.format("No flow with name '%s' found.", this.getFlowConstructName())));
    }

    public void reset() {
        this.completeEventContext();
        this.requestEvent = null;
    }

    public abstract String getFlowConstructName();

    public void dispose() {
        this.completeEventContext();
    }

    private void completeEventContext() {
        if (this.requestEvent != null) {
            ((BaseEventContext)this.requestEvent.getContext()).success();
        }
    }
}

