/*
 * Decompiled with CFR 0.152.
 */
package org.mule.functional.client;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.util.StringUtils;

public class TestConnectorConfig {
    public static final String DEFAULT_CONFIG_ID = "_defaultTestConnectorConfig";
    private final Map<String, BlockingQueue<CoreEvent>> queues = new HashMap<String, BlockingQueue<CoreEvent>>();

    public CoreEvent poll(String queueName, long timeout) {
        Preconditions.checkArgument((!StringUtils.isEmpty((String)queueName) ? 1 : 0) != 0, (String)"Queue name cannot be empty");
        Preconditions.checkArgument((timeout >= 0L ? 1 : 0) != 0, (String)"Timeout cannot be negative");
        BlockingQueue<CoreEvent> queue = this.getQueue(queueName);
        try {
            return queue.poll(timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            return null;
        }
    }

    public CoreEvent take(String queueName) {
        Preconditions.checkArgument((!StringUtils.isEmpty((String)queueName) ? 1 : 0) != 0, (String)"Queue name cannot be empty");
        BlockingQueue<CoreEvent> queue = this.getQueue(queueName);
        try {
            return queue.take();
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            return null;
        }
    }

    public void write(String queueName, CoreEvent event) {
        Preconditions.checkArgument((!StringUtils.isEmpty((String)queueName) ? 1 : 0) != 0, (String)"Queue name cannot be empty");
        Preconditions.checkArgument((event != null ? 1 : 0) != 0, (String)"Event cannot be null");
        BlockingQueue<CoreEvent> queue = this.getQueue(queueName);
        try {
            queue.put(event);
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            throw new IllegalStateException(e);
        }
    }

    public int countPendingEvents(String queueName) {
        BlockingQueue<CoreEvent> queue = this.queues.get(queueName);
        return queue.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BlockingQueue<CoreEvent> getQueue(String queueName) {
        BlockingQueue<CoreEvent> queue = this.queues.get(queueName);
        if (queue == null) {
            Map<String, BlockingQueue<CoreEvent>> map = this.queues;
            synchronized (map) {
                queue = this.queues.get(queueName);
                if (queue == null) {
                    queue = new LinkedBlockingDeque<CoreEvent>(100);
                    this.queues.put(queueName, queue);
                }
            }
        }
        return queue;
    }
}

