/*
 * Decompiled with CFR 0.152.
 */
package org.mule.functional.api.component;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsEqual;
import org.mule.functional.api.component.AbstractLogChecker;
import org.mule.runtime.api.exception.MuleException;

public class EqualsLogChecker
extends AbstractLogChecker {
    private String expectedLogMessage = "";
    private boolean shouldFilterLogMessage;

    @Override
    public void check(String logMessage) {
        StringBuilder errors = new StringBuilder();
        List<String> expectedLines = this.splitLines(this.expectedLogMessage);
        List<String> actualLines = this.getMessageLinesFromLogLines(this.splitLines(logMessage));
        this.checkLineCount(expectedLines, actualLines, errors);
        this.compareLines(expectedLines, actualLines, errors);
        String errorMessage = errors.toString();
        if (StringUtils.isNotBlank((CharSequence)errorMessage)) {
            throw new AssertionError((Object)(System.lineSeparator() + errorMessage));
        }
    }

    private void checkLineCount(List<String> expectedLog, List<String> actualLog, StringBuilder errorCatcher) {
        this.assertAndSaveError(actualLog.size(), CoreMatchers.is((Matcher)IsEqual.equalTo((Object)expectedLog.size())), "Log lines differs from expected ones:", errorCatcher);
    }

    private void compareLines(List<String> expectedLogLines, List<String> actualLogLines, StringBuilder errorCatcher) {
        for (int i = 0; i < expectedLogLines.size(); ++i) {
            if (i >= actualLogLines.size()) {
                errorCatcher.append(String.format("%sMissing expected line[%d]: %s%s", System.lineSeparator(), i, expectedLogLines.get(i), System.lineSeparator()));
                continue;
            }
            this.assertAndSaveError(actualLogLines.get(i), CoreMatchers.is((Matcher)Matchers.equalToIgnoringWhiteSpace((String)expectedLogLines.get(i))), String.format("Difference found in line %d:", i), errorCatcher);
        }
        if (actualLogLines.size() > expectedLogLines.size()) {
            errorCatcher.append(System.lineSeparator());
            errorCatcher.append("Actual log has extra lines:");
            errorCatcher.append(System.lineSeparator());
            for (int j = i; j < actualLogLines.size(); ++j) {
                errorCatcher.append(actualLogLines.get(j));
                errorCatcher.append(System.lineSeparator());
            }
        }
    }

    @Override
    protected List<String> splitLines(String wholeMessage) {
        if (this.shouldFilterLogMessage) {
            return this.filterLines(super.splitLines(wholeMessage));
        }
        return super.splitLines(wholeMessage);
    }

    private List<String> filterLines(List<String> splittedLog) {
        return splittedLog.stream().filter(line -> StringUtils.isNotBlank((CharSequence)line) && !line.trim().equals(MuleException.EXCEPTION_MESSAGE_DELIMITER.trim())).collect(Collectors.toList());
    }

    public void setExpectedLogMessage(String expectedLogMessage) {
        this.expectedLogMessage = expectedLogMessage;
    }

    public String getExpectedLogMessage() {
        return this.expectedLogMessage;
    }

    public void setShouldFilterLogMessage(boolean shouldFilterLogMessage) {
        this.shouldFilterLogMessage = shouldFilterLogMessage;
    }

    public boolean getShouldFilterLogMessage() {
        return this.shouldFilterLogMessage;
    }
}

