/*
 * Decompiled with CFR 0.152.
 */
package org.mule.functional.api.component;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.mule.functional.api.component.EventCallback;
import org.mule.functional.api.exception.FunctionalTestException;
import org.mule.functional.api.notification.FunctionalTestNotification;
import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.location.ConfigurationComponentLocator;
import org.mule.runtime.api.exception.DefaultMuleException;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Lifecycle;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.notification.Notification;
import org.mule.runtime.api.notification.NotificationDispatcher;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.el.ExtendedExpressionManager;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.api.transformer.TransformerException;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.core.api.util.StringMessageUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FunctionalTestProcessor
extends AbstractComponent
implements Processor,
Lifecycle {
    private static final Logger LOGGER = LoggerFactory.getLogger(FunctionalTestProcessor.class);
    @Inject
    private MuleContext muleContext;
    @Inject
    private ExtendedExpressionManager expressionManager;
    @Inject
    private NotificationDispatcher notificationFirer;
    private ReactiveProcessor.ProcessingType processingType;
    private EventCallback eventCallback;
    private Object returnData = null;
    private boolean throwException = false;
    private Class<? extends Throwable> exceptionToThrow;
    private String exceptionText = "";
    private boolean enableMessageHistory = true;
    private boolean enableNotifications = true;
    private String appendString;
    private long waitTime = 0L;
    private boolean logMessageDetails = false;
    private String id = "<none>";
    private String processorClass;
    private Processor processor;
    private static List<LifecycleCallback> lifecycleCallbacks = new ArrayList<LifecycleCallback>();
    private List<CoreEvent> messageHistory;

    public void initialise() throws InitialisationException {
        if (this.enableMessageHistory) {
            this.messageHistory = new CopyOnWriteArrayList<CoreEvent>();
        }
        for (LifecycleCallback callback : lifecycleCallbacks) {
            callback.onTransition(this.id, "initialise");
        }
        if (this.processorClass != null) {
            try {
                this.processor = (Processor)ClassUtils.instantiateClass((String)this.processorClass, (Object[])new Object[0]);
                LifecycleUtils.initialiseIfNeeded((Object)this.processor, (boolean)true, (MuleContext)this.muleContext);
            }
            catch (Exception e) {
                throw new InitialisationException((Throwable)e, (Initialisable)this);
            }
        }
    }

    public void start() throws MuleException {
        for (LifecycleCallback callback : lifecycleCallbacks) {
            callback.onTransition(this.id, "start");
        }
        if (this.processor != null) {
            LifecycleUtils.startIfNeeded((Object)this.processor);
        }
    }

    public void stop() throws MuleException {
        for (LifecycleCallback callback : lifecycleCallbacks) {
            callback.onTransition(this.id, "stop");
        }
        if (this.processor != null) {
            LifecycleUtils.stopIfNeeded((Object)this.processor);
        }
    }

    public void dispose() {
        for (LifecycleCallback callback : lifecycleCallbacks) {
            callback.onTransition(this.id, "dispose");
        }
        if (this.processor != null) {
            LifecycleUtils.disposeIfNeeded((Object)this.processor, (Logger)LOGGER);
        }
    }

    public CoreEvent process(CoreEvent event) throws MuleException {
        try {
            if (this.isThrowException()) {
                this.throwException();
            }
            return this.doProcess(event);
        }
        catch (Throwable t) {
            if (t instanceof MuleException) {
                throw (MuleException)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            throw new DefaultMuleException(t);
        }
    }

    protected void throwException() throws Exception {
        if (this.getExceptionToThrow() != null) {
            if (StringUtils.isNotBlank((CharSequence)this.exceptionText)) {
                Throwable exception = (Throwable)ClassUtils.instantiateClass(this.getExceptionToThrow(), (Object[])new Object[]{this.exceptionText});
                throw (Exception)exception;
            }
            throw (Exception)this.getExceptionToThrow().newInstance();
        }
        if (StringUtils.isNotBlank((CharSequence)this.exceptionText)) {
            throw new FunctionalTestException(this.exceptionText);
        }
        throw new FunctionalTestException();
    }

    protected String append(String contents, CoreEvent event) {
        return contents + this.expressionManager.parse(this.appendString, event, this.getLocation());
    }

    protected CoreEvent doProcess(CoreEvent event) throws Exception {
        if (this.enableMessageHistory) {
            this.messageHistory.add(event);
        }
        Message message = event.getMessage();
        if (LOGGER.isInfoEnabled()) {
            String msg = StringMessageUtils.getBoilerPlate((String)("Message Received in flow: " + this.getLocation().getRootContainerName() + ". Content is: " + StringMessageUtils.truncate((String)message.getPayload().getValue().toString(), (int)100, (boolean)true)), (char)'*', (int)80);
            LOGGER.info(msg);
        }
        if (this.isLogMessageDetails() && LOGGER.isInfoEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Full Message: ").append(SystemUtils.LINE_SEPARATOR);
            sb.append(message.getPayload().getValue().toString()).append(SystemUtils.LINE_SEPARATOR);
            sb.append(message.toString());
            LOGGER.info(sb.toString());
        }
        if (this.eventCallback != null) {
            this.eventCallback.eventReceived(event, (Object)this, this.muleContext);
        }
        if (this.processor != null) {
            return this.processor.process(event);
        }
        Message.Builder replyBuilder = Message.builder((Message)message);
        if (this.returnData != null) {
            replyBuilder = this.returnData instanceof String && this.expressionManager.isExpression(this.returnData.toString()) ? replyBuilder.value((Object)this.expressionManager.parse(this.returnData.toString(), event, this.getLocation())) : replyBuilder.value(this.returnData);
        } else if (this.appendString != null) {
            replyBuilder = replyBuilder.value((Object)this.append(this.muleContext.getTransformationService().transform(event.getMessage(), DataType.STRING).getPayload().getValue().toString(), event));
        }
        CoreEvent replyMessage = CoreEvent.builder((CoreEvent)event).message(replyBuilder.build()).build();
        if (this.isEnableNotifications()) {
            this.notificationFirer.dispatch((Notification)this.buildEventReceivedNotification(message, replyMessage));
        }
        if (this.waitTime > 0L) {
            try {
                Thread.sleep(this.waitTime);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                LOGGER.info("FunctionalTestProcessor waitTime was interrupted");
            }
        }
        return replyMessage;
    }

    protected FunctionalTestNotification buildEventReceivedNotification(Message message, CoreEvent replyMessage) throws TransformerException {
        return new FunctionalTestNotification(message, this.getLocation().getRootContainerName(), replyMessage, -999999);
    }

    public EventCallback getEventCallback() {
        return this.eventCallback;
    }

    public void setEventCallback(EventCallback eventCallback) {
        this.eventCallback = eventCallback;
    }

    public Object getReturnData() {
        return this.returnData;
    }

    public void setReturnData(Object returnData) {
        this.returnData = returnData;
    }

    public boolean isThrowException() {
        return this.throwException;
    }

    public void setThrowException(boolean throwException) {
        this.throwException = throwException;
    }

    public boolean isEnableMessageHistory() {
        return this.enableMessageHistory;
    }

    public void setEnableMessageHistory(boolean enableMessageHistory) {
        this.enableMessageHistory = enableMessageHistory;
    }

    public int getReceivedMessagesCount() {
        if (this.messageHistory != null) {
            return this.messageHistory.size();
        }
        return -1;
    }

    public CoreEvent getReceivedMessage(int number) {
        CoreEvent message = null;
        if (this.messageHistory != null && number <= this.messageHistory.size()) {
            message = this.messageHistory.get(number - 1);
        }
        return message;
    }

    public CoreEvent getLastReceivedMessage() {
        if (this.messageHistory != null) {
            return this.messageHistory.get(this.messageHistory.size() - 1);
        }
        return null;
    }

    public String getAppendString() {
        return this.appendString;
    }

    public void setAppendString(String appendString) {
        this.appendString = appendString;
    }

    public boolean isEnableNotifications() {
        return this.enableNotifications;
    }

    public void setEnableNotifications(boolean enableNotifications) {
        this.enableNotifications = enableNotifications;
    }

    public Class<? extends Throwable> getExceptionToThrow() {
        return this.exceptionToThrow;
    }

    public void setExceptionToThrow(Class<? extends Throwable> exceptionToThrow) {
        this.exceptionToThrow = exceptionToThrow;
    }

    public long getWaitTime() {
        return this.waitTime;
    }

    public void setWaitTime(long waitTime) {
        this.waitTime = waitTime;
    }

    public boolean isLogMessageDetails() {
        return this.logMessageDetails;
    }

    public void setLogMessageDetails(boolean logMessageDetails) {
        this.logMessageDetails = logMessageDetails;
    }

    public String getExceptionText() {
        return this.exceptionText;
    }

    public void setExceptionText(String text) {
        this.exceptionText = text;
    }

    public void setId(String id) {
        this.id = id;
    }

    public static void addLifecycleCallback(LifecycleCallback callback) {
        lifecycleCallbacks.add(callback);
    }

    public static void removeLifecycleCallback(LifecycleCallback callback) {
        lifecycleCallbacks.remove(callback);
    }

    public static FunctionalTestProcessor getFromFlow(ConfigurationComponentLocator locator, String flowName) throws Exception {
        return locator.find(ComponentIdentifier.builder().namespace("test").name("processor").build()).stream().filter(c -> flowName.equals(c.getRootContainerLocation().toString())).map(c -> (FunctionalTestProcessor)((Object)c)).findAny().get();
    }

    public void setProcessorClass(String processorClass) {
        this.processorClass = processorClass;
    }

    public ReactiveProcessor.ProcessingType getProcessingType() {
        return this.processingType;
    }

    public void setProcessingType(ReactiveProcessor.ProcessingType processingType) {
        this.processingType = processingType;
    }

    public static interface LifecycleCallback {
        public void onTransition(String var1, String var2);
    }
}

