/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.tck;

import java.io.IOException;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mule.functional.api.component.FunctionalTestProcessor;
import org.mule.functional.api.exception.FunctionalTestException;
import org.mule.runtime.api.exception.MuleException;
import org.mule.tck.junit4.AbstractMuleTestCase;

public class FunctionalTestProcessorTestCase
extends AbstractMuleTestCase {
    FunctionalTestProcessor ftc;
    @Rule
    public ExpectedException expected = ExpectedException.none();

    @Before
    public void initFunctionaTestComponent() {
        this.ftc = new FunctionalTestProcessor();
        this.ftc.setThrowException(true);
    }

    @Test
    public void defaultExceptionWithDefaultText() throws Exception {
        this.checkExceptionThrown(FunctionalTestException.class, "Functional Test Service Exception");
    }

    @Test
    public void defaultExceptionWithCustomText() throws Exception {
        String exceptionText = "BOOM";
        this.ftc.setExceptionText(exceptionText);
        this.checkExceptionThrown(FunctionalTestException.class, exceptionText);
    }

    @Test
    public void customExceptionWithoutText() throws Exception {
        this.ftc.setExceptionToThrow(IOException.class);
        this.checkWrappedExceptionThrown(IOException.class, null);
    }

    @Test
    public void customExceptionWithCustomText() throws Exception {
        String exceptionText = "BOOM";
        this.ftc.setExceptionToThrow(IOException.class);
        this.ftc.setExceptionText(exceptionText);
        this.checkWrappedExceptionThrown(IOException.class, exceptionText);
    }

    @Test
    public void customRuntimeExceptionWithoutText() throws Exception {
        this.ftc.setExceptionToThrow(NullPointerException.class);
        this.checkExceptionThrown(NullPointerException.class, null);
    }

    @Test
    public void customRuntimeExceptionWithCustomText() throws Exception {
        String exceptionText = "BOOM";
        this.ftc.setExceptionToThrow(NullPointerException.class);
        this.ftc.setExceptionText(exceptionText);
        this.checkExceptionThrown(NullPointerException.class, exceptionText);
    }

    private void checkExceptionThrown(Class<? extends Exception> exceptionClass, String expectedMessage) throws MuleException {
        this.expected.expect(Matchers.instanceOf(exceptionClass));
        if (expectedMessage != null) {
            this.expected.expectMessage(Matchers.startsWith((String)expectedMessage));
        }
        this.ftc.process(null);
    }

    private void checkWrappedExceptionThrown(Class<? extends Exception> exceptionClass, String expectedMessage) throws MuleException {
        this.expected.expectCause(Matchers.instanceOf(exceptionClass));
        if (expectedMessage != null) {
            this.expected.expectMessage(Matchers.startsWith((String)expectedMessage));
        }
        this.ftc.process(null);
    }
}

