/*
 * Decompiled with CFR 0.152.
 */
package org.mule.functional.api.component;

import java.util.Arrays;
import java.util.HashMap;
import javax.xml.namespace.QName;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.After;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mule.functional.api.component.LogChecker;
import org.mule.functional.api.component.OnErrorCheckLogHandler;
import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.privileged.exception.DefaultExceptionListener;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;

public class OnErrorCheckLogHandlerTestCase
extends AbstractMuleContextTestCase {
    private static final LogChecker successfulChecker = (LogChecker)Mockito.mock(LogChecker.class);
    private static final LogChecker failingChecker = (LogChecker)Mockito.mock(LogChecker.class);
    private OnErrorCheckLogHandler checkLogHandler;

    @BeforeClass
    public static void serMocks() {
        ((LogChecker)Mockito.doNothing().when((Object)successfulChecker)).check((String)ArgumentMatchers.any());
        ((LogChecker)Mockito.doThrow((Throwable[])new Throwable[]{new AssertionError()}).when((Object)failingChecker)).check((String)ArgumentMatchers.any());
    }

    @Before
    public void resetLogHandler() throws Exception {
        this.checkLogHandler = new OnErrorCheckLogHandler();
        HashMap<QName, String> annotations = new HashMap<QName, String>();
        annotations.put(AbstractComponent.ROOT_CONTAINER_NAME_KEY, "someContainerName");
        ComponentLocation location = (ComponentLocation)Mockito.mock(ComponentLocation.class);
        Mockito.when((Object)location.getLocation()).thenReturn((Object)"location");
        annotations.put(AbstractComponent.LOCATION_KEY, (String)location);
        this.checkLogHandler.setAnnotations(annotations);
        this.checkLogHandler.setExceptionListener(new DefaultExceptionListener());
        LifecycleUtils.initialiseIfNeeded((Object)this.checkLogHandler, (MuleContext)muleContext);
        this.checkLogHandler.start();
    }

    @After
    public void disposeLogHandler() {
        LifecycleUtils.disposeIfNeeded((Object)this.checkLogHandler, (Logger)LoggerFactory.getLogger(((Object)((Object)this)).getClass()));
    }

    @Test
    public void handlerFailsIfThereIsNoExceptionToHandle() throws Exception {
        AssertionError thrown = (AssertionError)((Object)Assertions.assertThrows(AssertionError.class, () -> this.checkLogHandler.verify()));
        MatcherAssert.assertThat((Object)((Throwable)((Object)thrown)).getMessage(), (Matcher)Is.is((Object)"Handler could not check any exception log because no exception was raised"));
    }

    @Test
    public void handlerSucceedsByDefault() throws Exception {
        this.assertHandler();
    }

    @Test
    public void handlerSucceedsIfSuccessfulChecker() throws Exception {
        this.checkLogHandler.setCheckers(Arrays.asList(successfulChecker));
        this.assertHandler();
    }

    @Test
    public void handlerFailsIfFailingChecker() throws Exception {
        this.checkLogHandler.setCheckers(Arrays.asList(failingChecker));
        Assertions.assertThrows(AssertionError.class, () -> this.assertHandler());
    }

    @Test
    public void handlerFailsIfAtLeastOneFailingChecker() throws Exception {
        this.checkLogHandler.setCheckers(Arrays.asList(successfulChecker, successfulChecker, failingChecker, successfulChecker));
        Assertions.assertThrows(AssertionError.class, () -> this.assertHandler());
    }

    @Test
    public void failIfNoLogAndFlagNotSet() throws Exception {
        this.handleException();
        Assertions.assertThrows(AssertionError.class, () -> this.checkLogHandler.verify());
    }

    @Test
    public void succeedsIfNotLogAndFlagSet() throws Exception {
        this.checkLogHandler.setSucceedIfNoLog(true);
        this.handleException();
        this.checkLogHandler.verify();
    }

    private void assertHandler() throws Exception {
        this.handleException();
        this.checkLogHandler.logException((Throwable)new Exception(), null);
        this.checkLogHandler.verify();
    }

    private void handleException() {
        Flux.from((Publisher)this.checkLogHandler.route((Publisher)Flux.just((Object)((CoreEvent)Mockito.mock(CoreEvent.class))))).subscribe(e -> {}, e -> {});
    }
}

