/*
 * Decompiled with CFR 0.152.
 */
package org.mule.functional.api.component;

import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.processor.Processor;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Hooks;

public class EventDropperProcessor
extends AbstractComponent
implements Processor {
    public Publisher<CoreEvent> apply(Publisher<CoreEvent> p) {
        Hooks.onNextDropped(event -> System.out.println("Event dropped: " + String.valueOf(event)));
        Hooks.onErrorDropped(error -> System.out.println("Error dropped: " + error.getMessage()));
        return Flux.from(p).map(event -> {
            throw new RuntimeException("Forced error in EventDropperProcessor");
        }).onErrorContinue((error, obj) -> {
            throw new RuntimeException("Secondary error: " + error.getMessage());
        });
    }

    public CoreEvent process(CoreEvent event) throws MuleException {
        return event;
    }
}

