/*
 * Decompiled with CFR 0.152.
 */
package org.mule.functional.api.flow;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.mule.functional.api.flow.FlowConstructRunner;
import org.mule.functional.api.flow.TransactionConfigEnum;
import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.construct.Flow;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.execution.ExecutionCallback;
import org.mule.runtime.core.api.execution.ExecutionTemplate;
import org.mule.runtime.core.api.execution.TransactionalExecutionTemplate;
import org.mule.runtime.core.api.transaction.MuleTransactionConfig;
import org.mule.runtime.core.api.transaction.TransactionConfig;
import org.mule.runtime.core.api.transaction.TransactionFactory;
import org.mule.runtime.core.privileged.exception.EventProcessingException;
import org.mule.tck.junit4.matcher.ErrorTypeMatcher;
import org.mule.tck.junit4.matcher.EventMatcher;
import org.mule.tck.processor.FlowAssert;

public class FlowRunner
extends FlowConstructRunner<FlowRunner>
implements Disposable {
    private String flowName;
    private ExecutionTemplate<CoreEvent> txExecutionTemplate = callback -> (CoreEvent)callback.process();
    private Function<CoreEvent, CoreEvent> responseEventTransformer = input -> input;
    private Scheduler scheduler;
    private CompletableFuture<Void> externalCompletionCallback = new CompletableFuture();

    public FlowRunner(Registry registry, String flowName) {
        super(registry);
        this.flowName = flowName;
    }

    public FlowRunner transactionally(TransactionConfigEnum action, TransactionFactory factory) {
        MuleTransactionConfig transactionConfig = new MuleTransactionConfig(action.getAction());
        transactionConfig.setFactory(factory);
        this.txExecutionTemplate = TransactionalExecutionTemplate.createTransactionalExecutionTemplate((MuleContext)((MuleContext)this.registry.lookupByType(MuleContext.class).get()), (TransactionConfig)transactionConfig);
        return this;
    }

    public FlowRunner keepStreamsOpen() {
        this.eventBuilder.setExternalCompletionCallback(this.externalCompletionCallback);
        return this;
    }

    public FlowRunner withScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
        return this;
    }

    public CoreEvent run() throws Exception {
        return this.runAndVerify(this.flowName);
    }

    public CoreEvent runNoVerify() throws Exception {
        return this.runAndVerify(new String[0]);
    }

    public CoreEvent runAndVerify(String ... flowNamesToVerify) throws Exception {
        CoreEvent response;
        Flow flow = (Flow)this.getFlowConstruct();
        if (this.scheduler == null) {
            response = (CoreEvent)this.txExecutionTemplate.execute(this.getFlowRunCallback(flow));
        } else {
            try {
                response = (CoreEvent)this.scheduler.submit(() -> (CoreEvent)this.txExecutionTemplate.execute(this.getFlowRunCallback(flow))).get();
            }
            catch (ExecutionException executionException) {
                Throwable cause = executionException.getCause();
                throw cause instanceof Exception ? (Exception)cause : new RuntimeException(cause);
            }
        }
        this.verify(flowNamesToVerify);
        return this.responseEventTransformer.apply(response);
    }

    public void dispatch() throws Exception {
        Flow flow = (Flow)this.getFlowConstruct();
        try {
            this.txExecutionTemplate.execute(this.getFlowDispatchCallback(flow));
        }
        catch (Exception exception) {
            // empty catch block
        }
        FlowAssert.verify((String)this.flowName);
    }

    public void dispatchAsync(Scheduler scheduler) throws Exception {
        this.scheduler = scheduler;
        Flow flow = (Flow)this.getFlowConstruct();
        try {
            scheduler.submit(() -> (CoreEvent)this.txExecutionTemplate.execute(this.getFlowDispatchCallback(flow)));
        }
        catch (Exception exception) {
            // empty catch block
        }
        FlowAssert.verify((String)this.flowName);
    }

    private ExecutionCallback<CoreEvent> getFlowRunCallback(Flow flow) {
        return () -> flow.process(this.getOrBuildEvent());
    }

    private ExecutionCallback<CoreEvent> getFlowDispatchCallback(Flow flow) {
        return () -> {
            flow.process(this.getOrBuildEvent());
            return null;
        };
    }

    private void verify(String ... flowNamesToVerify) throws Exception {
        for (String flowNameToVerify : flowNamesToVerify) {
            FlowAssert.verify((String)flowNameToVerify);
        }
    }

    public Exception runExpectingException() throws Exception {
        try {
            this.runNoVerify();
            Assert.fail((String)"Flow executed successfully. Expecting exception");
            return null;
        }
        catch (EventProcessingException e) {
            this.verify(this.getFlowConstructName());
            return e;
        }
    }

    public void runExpectingException(ErrorTypeMatcher matcher) throws Exception {
        try {
            this.runNoVerify();
            Assert.fail((String)"Flow executed successfully. Expecting exception");
        }
        catch (EventProcessingException e) {
            this.verify(this.getFlowConstructName());
            Assert.assertThat((Object)((Error)e.getEvent().getError().get()).getErrorType(), (Matcher)matcher);
        }
    }

    public void runExpectingException(Matcher<Throwable> causeMatcher) throws Exception {
        try {
            this.runNoVerify();
            Assert.fail((String)"Flow executed successfully. Expecting exception");
        }
        catch (EventProcessingException e) {
            this.verify(this.getFlowConstructName());
            Assert.assertThat((Object)((Error)e.getEvent().getError().get()).getCause(), causeMatcher);
        }
    }

    public void runExpectingException(EventMatcher errorEventMatcher) throws Exception {
        try {
            this.runNoVerify();
            Assert.fail((String)"Flow executed successfully. Expecting exception");
        }
        catch (EventProcessingException e) {
            this.verify(this.getFlowConstructName());
            Assert.assertThat((Object)e.getEvent(), (Matcher)errorEventMatcher);
        }
    }

    public void runExpectingException(ErrorTypeMatcher matcher, Matcher<CoreEvent> errorEventMatcher) throws Exception {
        try {
            this.runNoVerify();
            Assert.fail((String)"Flow executed successfully. Expecting exception");
        }
        catch (EventProcessingException e) {
            this.verify(this.getFlowConstructName());
            Assert.assertThat((Object)((Error)e.getEvent().getError().get()).getErrorType(), (Matcher)matcher);
            Assert.assertThat((Object)e.getEvent(), errorEventMatcher);
        }
    }

    public void runExpectingException(Matcher<Throwable> causeMatcher, Matcher<CoreEvent> errorEventMatcher) throws Exception {
        try {
            this.runNoVerify();
            Assert.fail((String)"Flow executed successfully. Expecting exception");
        }
        catch (EventProcessingException e) {
            this.verify(this.getFlowConstructName());
            Assert.assertThat((Object)((Error)e.getEvent().getError().get()).getCause(), causeMatcher);
            Assert.assertThat((Object)e.getEvent(), errorEventMatcher);
        }
    }

    @Override
    public String getFlowConstructName() {
        return this.flowName;
    }

    public void dispose() {
        if (this.scheduler != null) {
            this.scheduler.stop();
        }
        this.externalCompletionCallback.complete(null);
    }
}

