/*
 * Decompiled with CFR 0.152.
 */
package org.mule.functional.client;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.InternalEvent;
import org.mule.runtime.core.api.util.StringUtils;

public class TestConnectorConfig {
    public static final String DEFAULT_CONFIG_ID = "_defaultTestConnectorConfig";
    private final Map<String, BlockingQueue<InternalEvent>> queues = new HashMap<String, BlockingQueue<InternalEvent>>();

    public InternalEvent poll(String queueName, long timeout) {
        Preconditions.checkArgument((!StringUtils.isEmpty((String)queueName) ? 1 : 0) != 0, (String)"Queue name cannot be empty");
        Preconditions.checkArgument((timeout >= 0L ? 1 : 0) != 0, (String)"Timeout cannot be negative");
        BlockingQueue<InternalEvent> queue = this.getQueue(queueName);
        try {
            return queue.poll(timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            return null;
        }
    }

    public InternalEvent take(String queueName) {
        Preconditions.checkArgument((!StringUtils.isEmpty((String)queueName) ? 1 : 0) != 0, (String)"Queue name cannot be empty");
        BlockingQueue<InternalEvent> queue = this.getQueue(queueName);
        try {
            return queue.take();
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            return null;
        }
    }

    public void write(String queueName, InternalEvent event) {
        Preconditions.checkArgument((!StringUtils.isEmpty((String)queueName) ? 1 : 0) != 0, (String)"Queue name cannot be empty");
        Preconditions.checkArgument((event != null ? 1 : 0) != 0, (String)"Event cannot be null");
        BlockingQueue<InternalEvent> queue = this.getQueue(queueName);
        try {
            queue.put(event);
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            throw new IllegalStateException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BlockingQueue<InternalEvent> getQueue(String queueName) {
        BlockingQueue<InternalEvent> queue = this.queues.get(queueName);
        if (queue == null) {
            Map<String, BlockingQueue<InternalEvent>> map = this.queues;
            synchronized (map) {
                queue = this.queues.get(queueName);
                if (queue == null) {
                    queue = new LinkedBlockingDeque<InternalEvent>(100);
                    this.queues.put(queueName, queue);
                }
            }
        }
        return queue;
    }
}

