/*
 * Decompiled with CFR 0.152.
 */
package org.mule.functional.client;

import org.mule.functional.client.TestConnectorConfig;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.InternalEvent;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.util.StringUtils;

public class QueueReaderMessageProcessor
implements Processor {
    private final MuleContext muleContext;
    private final String queueName;
    private final Long timeout;

    public QueueReaderMessageProcessor(MuleContext muleContext, String queueName, Long timeout) {
        Preconditions.checkArgument((muleContext != null ? 1 : 0) != 0, (String)"MuleContext cannot be null");
        Preconditions.checkArgument((!StringUtils.isEmpty((String)queueName) ? 1 : 0) != 0, (String)"Queue name cannot be empty");
        if (timeout != null) {
            Preconditions.checkArgument((timeout >= 0L ? 1 : 0) != 0, (String)"Timeout cannot be negative");
        }
        this.muleContext = muleContext;
        this.queueName = queueName;
        this.timeout = timeout;
    }

    public InternalEvent process(InternalEvent event) throws MuleException {
        TestConnectorConfig connectorConfig = (TestConnectorConfig)this.muleContext.getRegistry().lookupObject("_defaultTestConnectorConfig");
        if (this.timeout == null) {
            return connectorConfig.take(this.queueName);
        }
        return connectorConfig.poll(this.queueName, this.timeout);
    }
}

