/*
 * Decompiled with CFR 0.152.
 */
package org.mule.functional.api.component;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.junit.Assert;
import org.mule.runtime.api.el.ValidationResult;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.meta.AbstractAnnotatedObject;
import org.mule.runtime.core.api.InternalEvent;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.mule.runtime.core.api.expression.InvalidExpressionException;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.tck.processor.FlowAssert;
import org.mule.tck.processor.FlowAssertion;

public class AssertionMessageProcessor
extends AbstractAnnotatedObject
implements FlowAssertion,
Processor,
Startable {
    protected String expression = "#[true]";
    protected String message = "?";
    private int count = 1;
    private int invocationCount = 0;
    protected boolean needToMatchCount = false;
    private CountDownLatch latch;
    @Inject
    protected ExpressionManager expressionManager;
    private boolean result = true;

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public void start() throws InitialisationException {
        ValidationResult result = this.expressionManager.validate(this.expression);
        if (!result.isSuccess()) {
            throw new InvalidExpressionException(this.expression, result.errorMessage().orElse("Invalid exception"));
        }
        this.latch = new CountDownLatch(this.count);
        FlowAssert.addAssertion((String)this.getRootContainerName(), (FlowAssertion)this);
    }

    public InternalEvent process(InternalEvent event) throws MuleException {
        if (event == null) {
            return null;
        }
        this.result = this.result && this.expressionManager.evaluateBoolean(this.expression, event, this.getLocation(), false, true);
        this.increaseCount();
        this.latch.countDown();
        return event;
    }

    public void verify() throws InterruptedException {
        if (this.countFailOrNullEvent().booleanValue()) {
            if (this.needToMatchCount) {
                Assert.fail((String)String.format("%sExpected count of %d but got %d.", this.failureMessagePrefix(), this.count, this.invocationCount));
            } else {
                Assert.fail((String)String.format("%sNo event was received.", this.failureMessagePrefix()));
            }
        } else if (this.expressionFailed().booleanValue()) {
            Assert.fail((String)(this.failureMessagePrefix() + "Expression " + this.expression + " evaluated false."));
        }
    }

    protected String failureMessagePrefix() {
        String processorPath = this.getLocation().getLocation();
        return "Flow assertion '" + this.message + "' failed @ '" + processorPath + "'. ";
    }

    public Boolean countFailOrNullEvent() throws InterruptedException {
        return !this.isProcessesCountCorrect();
    }

    public Boolean expressionFailed() {
        return !this.result;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setCount(int count) {
        this.count = count;
        this.needToMatchCount = true;
    }

    private void increaseCount() {
        ++this.invocationCount;
    }

    private synchronized boolean isProcessesCountCorrect() throws InterruptedException {
        boolean countReached = this.latch.await(5000L, TimeUnit.MILLISECONDS);
        if (this.needToMatchCount) {
            return this.count == this.invocationCount;
        }
        return countReached;
    }

    public void setExpressionManager(ExpressionManager expressionManager) {
        this.expressionManager = expressionManager;
    }
}

