/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.transactionalxa;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.util.Preconditions;
import org.mule.sdk.api.annotation.metadata.OutputResolver;
import org.mule.sdk.api.annotation.param.Connection;
import org.mule.sdk.api.annotation.param.Content;
import org.mule.sdk.api.error.ErrorTypeDefinition;
import org.mule.sdk.api.error.MuleErrors;
import org.mule.sdk.api.exception.ModuleException;
import org.mule.sdk.api.runtime.streaming.PagingProvider;
import org.mule.sdk.api.tx.OperationTransactionalAction;
import org.mule.test.transactionalxa.TransactionalMetadataResolver;
import org.mule.test.transactionalxa.connection.TestTransactionalConnection;

public class TransactionalOperations {
    private AtomicInteger connectionExceptions = new AtomicInteger(0);
    public static Integer getPageCalls = 0;

    @OutputResolver(output=TransactionalMetadataResolver.class)
    public TestTransactionalConnection getConnection(@Connection TestTransactionalConnection sdkConnection) {
        return sdkConnection;
    }

    public void verifyNoTransaction(@Connection TestTransactionalConnection sdkConnection) {
        Preconditions.checkState((!sdkConnection.isTransactionBegun() ? 1 : 0) != 0, (String)"transaction begun with no reason");
    }

    public void verifyTransactionBegun(@Connection TestTransactionalConnection sdkConnection) {
        Preconditions.checkState((boolean)sdkConnection.isTransactionBegun(), (String)"transaction not begun");
    }

    public void verifyTransactionCommited(@Connection TestTransactionalConnection connection) {
        Preconditions.checkState((boolean)connection.isTransactionCommited(), (String)"transaction not committed");
    }

    public void verifyTransactionRolledback(@Connection TestTransactionalConnection connection) {
        Preconditions.checkState((boolean)connection.isTransactionRolledback(), (String)"transaction not rolled back");
    }

    public void verifySameConnection(@Connection TestTransactionalConnection sdkConnection, @Content TestTransactionalConnection sdkTransactionalConnection) {
        Objects.requireNonNull(sdkTransactionalConnection, "The transactionalConnection can't be null");
        Preconditions.checkState((sdkConnection.getConnectionId() == sdkTransactionalConnection.getConnectionId() ? 1 : 0) != 0, (String)"The connection is not the same");
    }

    public void verifyNotSameConnection(@Connection TestTransactionalConnection sdkConnection, @Content TestTransactionalConnection sdkTransactionalConnection) {
        Objects.requireNonNull(sdkTransactionalConnection, "The transactionalConnection can't be null");
        Preconditions.checkState((sdkConnection.getConnectionId() != sdkTransactionalConnection.getConnectionId() ? 1 : 0) != 0, (String)"The connection is the same");
    }

    public OperationTransactionalAction injectTransactionalAction(@Connection TestTransactionalConnection connection, OperationTransactionalAction action) {
        return action;
    }

    @OutputResolver(output=TransactionalMetadataResolver.class)
    public PagingProvider<TestTransactionalConnection, Integer> pagedTransactionalOperation() throws Exception {
        return new PagingProvider<TestTransactionalConnection, Integer>(){
            private static final int SIZE = 2;
            private int count = 0;
            private int timesClosed = 0;

            public List<Integer> getPage(TestTransactionalConnection connection) {
                return this.count++ < 2 ? Arrays.asList(System.identityHashCode(connection)) : Collections.emptyList();
            }

            public Optional<Integer> getTotalResults(TestTransactionalConnection connection) {
                return Optional.of(2);
            }

            public void close(TestTransactionalConnection connection) throws MuleException {
                ++this.timesClosed;
                if (this.timesClosed > 1) {
                    throw new RuntimeException("Expected to be closed only once but was called twice");
                }
            }

            public boolean useStickyConnections() {
                return false;
            }
        };
    }

    @OutputResolver(output=TransactionalMetadataResolver.class)
    public PagingProvider<TestTransactionalConnection, Integer> failingPagedTransactionalOperation(final Integer failOn) throws Exception {
        return new PagingProvider<TestTransactionalConnection, Integer>(){
            private static final int SIZE = 2;
            private int count = 0;

            public List<Integer> getPage(TestTransactionalConnection connection) {
                Integer n = getPageCalls;
                getPageCalls = getPageCalls + 1;
                if (getPageCalls == failOn) {
                    throw new ModuleException((ErrorTypeDefinition)MuleErrors.CONNECTIVITY, (Throwable)new ConnectionException("Failed to retrieve Page"));
                }
                return this.count++ < 2 ? Arrays.asList(System.identityHashCode(connection)) : Collections.emptyList();
            }

            public Optional<Integer> getTotalResults(TestTransactionalConnection connection) {
                return Optional.empty();
            }

            public void close(TestTransactionalConnection connection) throws MuleException {
            }

            public boolean useStickyConnections() {
                return false;
            }
        };
    }

    @OutputResolver(output=TransactionalMetadataResolver.class)
    public PagingProvider<TestTransactionalConnection, Integer> stickyFailingPagedTransactionalOperation(final Integer failOn) throws Exception {
        return new PagingProvider<TestTransactionalConnection, Integer>(){
            private static final int SIZE = 2;
            private int count = 0;

            public List<Integer> getPage(TestTransactionalConnection connection) {
                Integer n = getPageCalls;
                getPageCalls = getPageCalls + 1;
                if (getPageCalls == failOn) {
                    throw new ModuleException((ErrorTypeDefinition)MuleErrors.CONNECTIVITY, (Throwable)new ConnectionException("Failed to retrieve Page"));
                }
                return this.count++ < 2 ? Arrays.asList(System.identityHashCode(connection)) : Collections.emptyList();
            }

            public Optional<Integer> getTotalResults(TestTransactionalConnection connection) {
                return Optional.empty();
            }

            public void close(TestTransactionalConnection connection) throws MuleException {
            }

            public boolean useStickyConnections() {
                return true;
            }
        };
    }

    public void fail() {
        throw new RuntimeException("you better rollback!");
    }

    public void connectionException(@Connection TestTransactionalConnection sdkConnection) throws ConnectionException {
        throw new ConnectionException(String.valueOf(this.connectionExceptions.incrementAndGet()));
    }
}

