/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck.junit4.matcher;

import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import org.mule.runtime.api.metadata.DataType;

public class DataTypeCompatibilityMatcher
extends TypeSafeMatcher<DataType> {
    private final DataType dataType;

    public DataTypeCompatibilityMatcher(DataType dataType) {
        this.dataType = dataType;
    }

    protected boolean matchesSafely(DataType otherDataType) {
        return this.dataType.isCompatibleWith(otherDataType);
    }

    public void describeTo(Description description) {
        description.appendText("a dataType assignable to ").appendValue((Object)this.dataType);
    }

    protected void describeMismatchSafely(DataType dataType, Description mismatchDescription) {
        mismatchDescription.appendText("got ").appendValue((Object)dataType);
    }

    public static Matcher<DataType> assignableTo(DataType dataType) {
        return new DataTypeCompatibilityMatcher(dataType);
    }
}

