/*
 * Decompiled with CFR 0.152.
 */
package org.mule.functional.transformer.simple;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Set;
import org.junit.Before;
import org.junit.Test;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.privileged.processor.simple.AbstractRemoveVariablePropertyProcessor;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.tck.util.MuleContextUtils;

@SmallTest
public abstract class AbstractRemoveVariablePropertyProcessorTestCase
extends AbstractMuleContextTestCase {
    public static final Charset ENCODING = StandardCharsets.US_ASCII;
    public static final String PLAIN_STRING_KEY = "someText";
    public static final String EXPRESSION = "#['someText']";
    public static final String EXPRESSION_VALUE = "expressionValueResult";
    public static final String NULL_EXPRESSION = "#[null]";
    private Message message;
    private CoreEvent event;
    private final AbstractRemoveVariablePropertyProcessor removeVariableProcessor;

    public AbstractRemoveVariablePropertyProcessorTestCase(AbstractRemoveVariablePropertyProcessor abstractAddVariableProcessor) {
        this.removeVariableProcessor = abstractAddVariableProcessor;
    }

    @Before
    public void setUpTest() throws Exception {
        this.message = Message.of((Object)"");
        this.event = this.createTestEvent(this.message);
        this.removeVariableProcessor.setExpressionManager(muleContext.getExpressionManager());
    }

    protected CoreEvent createTestEvent(Message message) throws MuleException {
        return MuleContextUtils.eventBuilder(muleContext).addVariable(PLAIN_STRING_KEY, (Object)EXPRESSION_VALUE).message(message).build();
    }

    @Test
    public void testRemoveVariable() throws MuleException {
        this.removeVariableProcessor.setIdentifier(PLAIN_STRING_KEY);
        this.removeVariableProcessor.initialise();
        this.event = this.removeVariableProcessor.process(this.event);
        this.verifyRemoved(this.event, PLAIN_STRING_KEY);
    }

    @Test
    public void testRemoveVariableUsingExpression() throws MuleException {
        this.removeVariableProcessor.setIdentifier(EXPRESSION);
        this.removeVariableProcessor.initialise();
        this.event = this.removeVariableProcessor.process(this.event);
        this.verifyRemoved(this.event, EXPRESSION_VALUE);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testRemoveVariableNullKey() {
        this.removeVariableProcessor.setIdentifier(null);
    }

    @Test
    public void testRemoveVariableExpressionKeyNullValue() throws MuleException {
        this.removeVariableProcessor.setIdentifier(NULL_EXPRESSION);
        this.removeVariableProcessor.initialise();
        this.event = this.removeVariableProcessor.process(this.event);
    }

    protected abstract void addMockedPropeerties(CoreEvent var1, Set<String> var2);

    protected abstract void verifyRemoved(CoreEvent var1, String var2);

    protected abstract void verifyNotRemoved(CoreEvent var1, String var2);
}

