/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck.junit4.rule;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import org.junit.rules.ExternalResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ExternalProcess
extends ExternalResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExternalProcess.class);
    private final String threadName;
    private final Predicate<String> daemonStartedPredicate;
    private final String[] processCommand;
    private Process p;
    private ExecutorService daemonExecutor;
    private Future<?> daemonFuture;

    public ExternalProcess(Predicate<String> daemonStartedPredicate, String ... processCommand) {
        this(null, daemonStartedPredicate, processCommand);
    }

    public ExternalProcess(String threadName, Predicate<String> daemonStartedPredicate, String ... processCommand) {
        this.threadName = threadName;
        this.daemonStartedPredicate = daemonStartedPredicate;
        this.processCommand = processCommand;
    }

    protected void before() throws Throwable {
        super.before();
        LOGGER.trace("Starting external process: " + String.valueOf(Arrays.asList(this.processCommand)));
        ProcessBuilder pb = new ProcessBuilder(this.processCommand);
        pb.redirectErrorStream(true);
        AtomicBoolean started = new AtomicBoolean();
        this.daemonExecutor = Executors.newSingleThreadExecutor(r -> {
            Thread thread = Executors.defaultThreadFactory().newThread(r);
            if (this.threadName != null) {
                thread.setName(this.threadName);
            }
            return thread;
        });
        this.daemonFuture = this.daemonExecutor.submit(() -> {
            try {
                this.p = pb.start();
                BufferedReader reader = new BufferedReader(new InputStreamReader(this.p.getInputStream()));
                String line = reader.readLine();
                while (line != null) {
                    LOGGER.warn(line);
                    if (this.daemonStartedPredicate.test(line)) {
                        Thread.sleep(500L);
                        started.set(true);
                    }
                    line = reader.readLine();
                }
            }
            catch (IOException | InterruptedException e) {
                if (this.p.isAlive()) {
                    LOGGER.error("Exception reading process output", (Throwable)e);
                }
                return;
            }
        });
        while (!started.get()) {
            Thread.sleep(10L);
        }
    }

    protected void after() {
        try {
            this.p.destroy();
            this.daemonFuture.get(30L, TimeUnit.SECONDS);
            this.daemonExecutor.shutdown();
            while (this.p.isAlive()) {
                Thread.sleep(10L);
            }
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            throw new RuntimeException(e);
        }
        super.after();
    }
}

