/*
 * Decompiled with CFR 0.152.
 */
package org.mule.functional.transformer.simple;

import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.activation.MimeTypeParseException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.mule.runtime.api.config.Feature;
import org.mule.runtime.api.config.FeatureFlaggingService;
import org.mule.runtime.api.config.MuleRuntimeFeature;
import org.mule.runtime.api.event.EventContext;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.streaming.CursorProvider;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.streaming.StreamingManager;
import org.mule.runtime.core.api.util.SystemUtils;
import org.mule.runtime.core.api.util.func.CheckedRunnable;
import org.mule.runtime.core.privileged.processor.simple.AbstractAddVariablePropertyProcessor;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.junit4.matcher.DataTypeMatcher;
import org.mule.tck.size.SmallTest;
import org.mule.tck.util.MuleContextUtils;

@SmallTest
@RunWith(value=MockitoJUnitRunner.class)
public abstract class AbstractAddVariablePropertyProcessorTestCase
extends AbstractMuleContextTestCase {
    public static final Charset ENCODING = StandardCharsets.US_ASCII;
    public static final String PLAIN_STRING_KEY = "someText";
    public static final String PLAIN_STRING_VALUE = "someValue";
    public static final String EXPRESSION = "#['someValue']";
    public static final String NULL_EXPRESSION = "#[null]";
    public static final Charset CUSTOM_ENCODING = StandardCharsets.UTF_8;
    @Mock(lenient=true)
    private StreamingManager streamingManager;
    private CoreEvent event;
    private Message message;
    private final AbstractAddVariablePropertyProcessor addVariableProcessor;
    private CheckedRunnable afterAssertions;

    public AbstractAddVariablePropertyProcessorTestCase(AbstractAddVariablePropertyProcessor abstractAddVariableProcessor) {
        this.addVariableProcessor = abstractAddVariableProcessor;
    }

    @Before
    public void setUpTest() throws Exception {
        Mockito.when((Object)this.streamingManager.manage((CursorProvider)ArgumentMatchers.any(CursorProvider.class), (EventContext)ArgumentMatchers.any(EventContext.class))).thenAnswer(inv -> inv.getArgument(0));
        this.addVariableProcessor.setExpressionManager(muleContext.getExpressionManager());
        this.addVariableProcessor.setStreamingManager(this.streamingManager);
        this.message = Message.of((Object)"");
        this.event = this.createTestEvent(this.message);
        this.afterAssertions = () -> ((StreamingManager)Mockito.verify((Object)this.streamingManager, (VerificationMode)Mockito.never())).manage((CursorProvider)ArgumentMatchers.any(CursorProvider.class), (EventContext)ArgumentMatchers.any(EventContext.class));
        FeatureFlaggingService featureFlaggingService = (FeatureFlaggingService)Mockito.mock(FeatureFlaggingService.class);
        Field f1 = this.addVariableProcessor.getClass().getSuperclass().getDeclaredField("featureFlaggingService");
        f1.setAccessible(true);
        f1.set(this.addVariableProcessor, featureFlaggingService);
        Mockito.when((Object)featureFlaggingService.isEnabled((Feature)MuleRuntimeFeature.SET_VARIABLE_WITH_NULL_VALUE)).thenReturn((Object)true);
    }

    @After
    public void after() {
        if (this.afterAssertions != null) {
            this.afterAssertions.run();
        }
    }

    protected CoreEvent createTestEvent(Message message) throws MuleException {
        return MuleContextUtils.eventBuilder(muleContext).message(message).build();
    }

    @Test
    public void testAddVariable() throws MuleException {
        this.addVariableProcessor.setIdentifier(PLAIN_STRING_KEY);
        this.addVariableProcessor.setValue(PLAIN_STRING_VALUE);
        this.addVariableProcessor.initialise();
        this.event = this.addVariableProcessor.process(this.event);
        this.verifyAdded(this.event, PLAIN_STRING_KEY, PLAIN_STRING_VALUE);
        Assert.assertThat((Object)this.getVariableDataType(this.event, PLAIN_STRING_KEY), DataTypeMatcher.like(String.class, MediaType.ANY, SystemUtils.getDefaultEncoding((MuleContext)muleContext)));
    }

    @Test
    public void testAddVariableWithExpressionValue() throws MuleException {
        this.addVariableProcessor.setIdentifier(PLAIN_STRING_KEY);
        this.addVariableProcessor.setValue(EXPRESSION);
        this.addVariableProcessor.initialise();
        this.event = this.addVariableProcessor.process(this.event);
        this.verifyAdded(this.event, PLAIN_STRING_KEY, PLAIN_STRING_VALUE);
        Assert.assertThat((Object)this.getVariableDataType(this.event, PLAIN_STRING_KEY), DataTypeMatcher.like(String.class, MediaType.APPLICATION_JAVA, SystemUtils.getDefaultEncoding((MuleContext)muleContext)));
    }

    @Test
    public void testAddVariableWithExpressionKey() throws MuleException {
        this.addVariableProcessor.setIdentifier(EXPRESSION);
        this.addVariableProcessor.setValue(PLAIN_STRING_VALUE);
        this.addVariableProcessor.initialise();
        this.event = this.addVariableProcessor.process(this.event);
        this.verifyAdded(this.event, PLAIN_STRING_VALUE, PLAIN_STRING_VALUE);
        Assert.assertThat((Object)this.getVariableDataType(this.event, PLAIN_STRING_VALUE), DataTypeMatcher.like(String.class, MediaType.ANY, SystemUtils.getDefaultEncoding((MuleContext)muleContext)));
    }

    @Test
    public void testAddVariableWithEncoding() throws MuleException {
        this.addVariableProcessor.setIdentifier(PLAIN_STRING_KEY);
        this.addVariableProcessor.setValue(PLAIN_STRING_VALUE);
        this.addVariableProcessor.initialise();
        this.addVariableProcessor.setReturnDataType(DataType.builder().charset(CUSTOM_ENCODING).build());
        this.event = this.addVariableProcessor.process(this.event);
        this.verifyAdded(this.event, PLAIN_STRING_KEY, PLAIN_STRING_VALUE);
        Assert.assertThat((Object)this.getVariableDataType(this.event, PLAIN_STRING_KEY), DataTypeMatcher.like(String.class, MediaType.ANY, CUSTOM_ENCODING));
    }

    @Test
    public void testAddVariableWithMimeType() throws MimeTypeParseException, MuleException {
        this.addVariableProcessor.setIdentifier(PLAIN_STRING_KEY);
        this.addVariableProcessor.setValue(PLAIN_STRING_VALUE);
        this.addVariableProcessor.initialise();
        this.addVariableProcessor.setReturnDataType(DataType.builder().mediaType(MediaType.APPLICATION_XML).build());
        this.event = this.addVariableProcessor.process(this.event);
        this.verifyAdded(this.event, PLAIN_STRING_KEY, PLAIN_STRING_VALUE);
        Assert.assertThat((Object)this.getVariableDataType(this.event, PLAIN_STRING_KEY), DataTypeMatcher.like(String.class, MediaType.APPLICATION_XML, SystemUtils.getDefaultEncoding((MuleContext)muleContext)));
    }

    protected abstract DataType getVariableDataType(CoreEvent var1, String var2);

    @Test(expected=IllegalArgumentException.class)
    public void testAddVariableWithNullKey() {
        this.addVariableProcessor.setIdentifier(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAddVariableWithEmptyKey() {
        this.addVariableProcessor.setIdentifier("");
    }

    @Test(expected=NullPointerException.class)
    public void testAddVariableWithNullValue() {
        this.addVariableProcessor.setValue(null);
    }

    @Test
    public void testAddVariableWithNullExpressionKeyResult() throws MuleException {
        this.addVariableProcessor.setIdentifier(NULL_EXPRESSION);
        this.addVariableProcessor.setValue(PLAIN_STRING_VALUE);
        this.addVariableProcessor.initialise();
        this.event = this.addVariableProcessor.process(this.event);
        this.verifyNotAdded(this.event);
    }

    @Test
    public void testAddVariableWithNullExpressionValueResult() throws MuleException {
        this.addVariableProcessor.setIdentifier(PLAIN_STRING_KEY);
        this.addVariableProcessor.setValue(NULL_EXPRESSION);
        this.addVariableProcessor.initialise();
        this.verifyRemoved(this.event, PLAIN_STRING_KEY);
    }

    @Test
    public void testAddVariableWithNullPayloadExpressionValueResult() throws MuleException {
        this.addVariableProcessor.setIdentifier(PLAIN_STRING_KEY);
        this.addVariableProcessor.setValue(NULL_EXPRESSION);
        this.addVariableProcessor.initialise();
        this.event = this.addVariableProcessor.process(this.event);
        this.verifyAdded(this.event, PLAIN_STRING_KEY, null);
    }

    @Test
    public void testCursorProvidersAreManaged() throws MuleException {
        CursorProvider cursorProvider = (CursorProvider)Mockito.mock(CursorProvider.class);
        this.addVariableProcessor.setIdentifier(PLAIN_STRING_KEY);
        this.addVariableProcessor.setValue("#[payload]");
        this.addVariableProcessor.initialise();
        this.event = this.addVariableProcessor.process(CoreEvent.builder((CoreEvent)this.event).message(Message.of((Object)cursorProvider)).build());
        Assert.assertThat((Object)((TypedValue)this.event.getVariables().get(PLAIN_STRING_KEY)).getValue(), (Matcher)CoreMatchers.is((Object)cursorProvider));
        ((StreamingManager)Mockito.verify((Object)this.streamingManager)).manage((CursorProvider)ArgumentMatchers.same((Object)cursorProvider), (EventContext)ArgumentMatchers.any(EventContext.class));
        this.afterAssertions = null;
    }

    protected abstract void verifyAdded(CoreEvent var1, String var2, String var3);

    protected abstract void verifyNotAdded(CoreEvent var1);

    protected abstract void verifyRemoved(CoreEvent var1, String var2);
}

