/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck.junit4.rule;

import java.io.File;
import java.io.IOException;
import java.net.ServerSocket;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FreePortFinder {
    private static final Logger logger = LoggerFactory.getLogger(FreePortFinder.class);
    private final int minPortNumber;
    private final int portRange;
    private final Random random = new Random();
    private final String LOCK_FILE_EXTENSION = ".lock";
    private final Map<Integer, FileLock> locks = new HashMap<Integer, FileLock>();
    private final Map<Integer, FileChannel> files = new HashMap<Integer, FileChannel>();
    private final String basePath = System.getProperty("mule.freePortFinder.lockPath", ".");

    public FreePortFinder(int minPortNumber, int maxPortNumber) {
        this.minPortNumber = minPortNumber;
        this.portRange = maxPortNumber - minPortNumber;
        logger.debug("Building FreePortFinder {basePath='" + this.basePath + "', minPortNumber=" + minPortNumber + ", maxPortNumber=" + maxPortNumber + "}");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized Integer find() {
        try {
            FileUtils.forceMkdir((File)Paths.get(this.basePath, new String[0]).toFile());
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to find an available port", e);
        }
        int i = 0;
        while (i < this.portRange) {
            block17: {
                int port = this.minPortNumber + this.random.nextInt(this.portRange);
                logger.debug("Trying port " + port + "...");
                String portFile = port + ".lock";
                try (FileChannel channel = FileChannel.open(Paths.get(this.basePath + File.separator + portFile, new String[0]), StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.DELETE_ON_CLOSE);){
                    FileLock lock = channel.tryLock();
                    if (lock == null) {
                        throw new OverlappingFileLockException();
                    }
                    if (FreePortFinder.isPortFree(port)) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("Found free port: " + port);
                        }
                        this.locks.put(port, lock);
                        this.files.put(port, channel);
                        Integer n = port;
                        return n;
                    }
                    lock.release();
                    channel.close();
                }
                catch (OverlappingFileLockException e) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Port selected already locked");
                    }
                }
                catch (IOException e) {
                    if (!logger.isDebugEnabled()) break block17;
                    logger.debug("Error when trying to open port lock file, trying another port");
                }
            }
            ++i;
        }
        throw new IllegalStateException("Unable to find an available port");
    }

    public synchronized void releasePort(int port) {
        if (FreePortFinder.isPortFree(port) && this.locks.containsKey(port) && this.files.containsKey(port)) {
            FileLock lock = this.locks.remove(port);
            FileChannel file = this.files.remove(port);
            try {
                lock.release();
                file.close();
            }
            catch (IOException iOException) {}
        } else if (logger.isInfoEnabled()) {
            logger.info(String.format("Port %d was not correctly released", port));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isPortFree(int port) {
        boolean portIsFree = true;
        ServerSocket server = null;
        try {
            server = new ServerSocket(port);
            server.setReuseAddress(true);
        }
        catch (IOException e) {
            portIsFree = false;
        }
        finally {
            if (server != null) {
                try {
                    server.close();
                }
                catch (IOException iOException) {}
            }
        }
        return portIsFree;
    }
}

