/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck.junit4;

import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import org.hamcrest.Matcher;
import org.hamcrest.collection.IsEmptyCollection;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.rules.TemporaryFolder;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.location.ConfigurationComponentLocator;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.LifecycleException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.meta.MuleVersion;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.notification.NotificationListener;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.api.scheduler.SchedulerView;
import org.mule.runtime.api.serialization.ObjectSerializer;
import org.mule.runtime.api.util.concurrent.Latch;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.ConfigurationBuilder;
import org.mule.runtime.core.api.config.DefaultMuleConfiguration;
import org.mule.runtime.core.api.config.MuleConfiguration;
import org.mule.runtime.core.api.config.bootstrap.ArtifactType;
import org.mule.runtime.core.api.context.DefaultMuleContextFactory;
import org.mule.runtime.core.api.context.MuleContextBuilder;
import org.mule.runtime.core.api.context.notification.MuleContextNotification;
import org.mule.runtime.core.api.context.notification.MuleContextNotificationListener;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.util.FileUtils;
import org.mule.runtime.core.internal.config.builders.MinimalConfigurationBuilder;
import org.mule.runtime.core.internal.serialization.JavaObjectSerializer;
import org.mule.runtime.core.internal.test.builders.ServiceCustomizationsConfigurationBuilder;
import org.mule.runtime.dsl.api.component.config.DefaultComponentLocation;
import org.mule.tck.SensingNullMessageProcessor;
import org.mule.tck.SimpleUnitTestSupportSchedulerService;
import org.mule.tck.TriggerableMessageSource;
import org.mule.tck.config.TestServicesConfigurationBuilder;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.junit4.MockExtensionManagerConfigurationBuilder;
import org.mule.tck.junit4.TestsLogConfigurationHelper;
import org.mule.tck.util.MuleContextUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMuleContextTestCase
extends AbstractMuleTestCase {
    private static final Logger LOGGER;
    private static final Field LIFECYCLE_EXCEPTION_COMPONENT_FIELD;
    public static final String WORKING_DIRECTORY_SYSTEM_PROPERTY_KEY = "workingDirectory";
    public TestServicesConfigurationBuilder testServicesConfigurationBuilder;
    public Supplier<TestServicesConfigurationBuilder> testServicesConfigurationBuilderSupplier = () -> new TestServicesConfigurationBuilder(this.mockHttpService(), this.mockExprExecutorService(), this.mockExpressionLanguageMetadataService());
    public TemporaryFolder workingDirectory = new TemporaryFolder();
    public static final String[] IGNORED_DOT_MULE_DIRS;
    protected static MuleContext muleContext;
    private boolean startContext = false;
    public static final String TEST_MESSAGE = "Test Message";
    public static final long LOCK_TIMEOUT = 30000L;
    public static final int RECEIVE_TIMEOUT = 5000;
    public static final int BLOCK_TIMEOUT = 500;
    protected static final long NON_GRACEFUL_SHUTDOWN_TIMEOUT = 10L;
    private boolean disposeContextPerClass;
    private static boolean logConfigured;
    protected ConfigurationComponentLocator componentLocator = (ConfigurationComponentLocator)Mockito.mock(ConfigurationComponentLocator.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
    private static List<SchedulerView> schedulersOnInit;

    protected boolean isDisposeContextPerClass() {
        return this.disposeContextPerClass;
    }

    protected void setDisposeContextPerClass(boolean val) {
        this.disposeContextPerClass = val;
    }

    @Before
    public final void setUpMuleContext() throws Exception {
        if (!logConfigured) {
            TestsLogConfigurationHelper.configureLoggingForTest(this.getClass());
            logConfigured = true;
        }
        this.workingDirectory.create();
        String workingDirectoryOldValue = System.setProperty(WORKING_DIRECTORY_SYSTEM_PROPERTY_KEY, this.workingDirectory.getRoot().getAbsolutePath());
        try {
            this.doSetUpBeforeMuleContextCreation();
            muleContext = this.createMuleContext();
            if (this.doTestClassInjection()) {
                muleContext.getInjector().inject((Object)this);
            }
            if (this.isStartContext() && muleContext != null && !muleContext.isStarted()) {
                this.startMuleContext();
            }
            this.doSetUp();
        }
        catch (LifecycleException e) {
            if (LIFECYCLE_EXCEPTION_COMPONENT_FIELD != null) {
                LIFECYCLE_EXCEPTION_COMPONENT_FIELD.set((Object)e, null);
            }
            throw e;
        }
        finally {
            if (workingDirectoryOldValue != null) {
                System.setProperty(WORKING_DIRECTORY_SYSTEM_PROPERTY_KEY, workingDirectoryOldValue);
            } else {
                System.clearProperty(WORKING_DIRECTORY_SYSTEM_PROPERTY_KEY);
            }
        }
    }

    protected void doSetUpBeforeMuleContextCreation() throws Exception {
    }

    private void startMuleContext() throws MuleException, InterruptedException {
        final AtomicReference<Latch> contextStartedLatch = new AtomicReference<Latch>();
        contextStartedLatch.set(new Latch());
        MuleContextNotificationListener<MuleContextNotification> listener = new MuleContextNotificationListener<MuleContextNotification>(){

            public boolean isBlocking() {
                return false;
            }

            public void onNotification(MuleContextNotification notification) {
                ((Latch)contextStartedLatch.get()).countDown();
            }
        };
        muleContext.getNotificationManager().addListener((NotificationListener)listener);
        muleContext.start();
        ((Latch)contextStartedLatch.get()).await(20L, TimeUnit.SECONDS);
    }

    protected boolean doTestClassInjection() {
        return false;
    }

    protected void doSetUp() throws Exception {
    }

    protected MuleContext createMuleContext() throws Exception {
        return this.createMuleContext(this.getClass().getSimpleName() + "#" + this.name.getMethodName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MuleContext createMuleContext(String contextConfigurationId) throws Exception {
        MuleContext context;
        if (this.isDisposeContextPerClass() && muleContext != null) {
            context = muleContext;
        } else {
            ClassLoader executionClassLoader = this.getExecutionClassLoader();
            ClassLoader originalContextClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(executionClassLoader);
                DefaultMuleContextFactory muleContextFactory = new DefaultMuleContextFactory();
                ArrayList<ConfigurationBuilder> builders = new ArrayList<ConfigurationBuilder>();
                builders.add((ConfigurationBuilder)new ServiceCustomizationsConfigurationBuilder(this.getStartUpRegistryObjects()));
                this.addBuilders(builders);
                builders.add(new MockExtensionManagerConfigurationBuilder(this.getExtensionModels()));
                builders.add(this.getBuilder());
                MuleContextBuilder contextBuilder = MuleContextBuilder.builder((ArtifactType)ArtifactType.APP);
                DefaultMuleConfiguration muleConfiguration = this.createMuleConfiguration();
                String workingDirectory = this.workingDirectory.getRoot().getAbsolutePath();
                LOGGER.info("Using working directory for test: " + workingDirectory);
                muleConfiguration.setWorkingDirectory(workingDirectory);
                muleConfiguration.setId(contextConfigurationId);
                contextBuilder.setMuleConfiguration((MuleConfiguration)muleConfiguration);
                contextBuilder.setExecutionClassLoader(executionClassLoader);
                contextBuilder.setObjectSerializer(this.getObjectSerializer());
                contextBuilder.setDeploymentProperties(this.getDeploymentProperties());
                contextBuilder.setArtifactCoordinates(this.getTestArtifactCoordinates());
                this.configureMuleContext(contextBuilder);
                context = muleContextFactory.createMuleContext(builders, contextBuilder);
                AbstractMuleContextTestCase.recordSchedulersOnInit(context);
                if (!this.isGracefulShutdown()) {
                    ((DefaultMuleConfiguration)context.getConfiguration()).setShutdownTimeout(10L);
                }
            }
            finally {
                Thread.currentThread().setContextClassLoader(originalContextClassLoader);
            }
        }
        return context;
    }

    protected Set<ExtensionModel> getExtensionModels() {
        return Collections.emptySet();
    }

    protected DefaultMuleConfiguration createMuleConfiguration() {
        DefaultMuleConfiguration muleConfiguration = new DefaultMuleConfiguration();
        this.configureMuleConfiguration(muleConfiguration);
        return muleConfiguration;
    }

    protected void configureMuleConfiguration(DefaultMuleConfiguration muleConfiguration) {
        String mvnVersionProperty = AbstractMuleContextTestCase.getMavenProjectVersionProperty();
        if (mvnVersionProperty != null) {
            muleConfiguration.setMinMuleVersion(new MuleVersion(mvnVersionProperty));
        }
    }

    protected Optional<Properties> getDeploymentProperties() {
        return Optional.empty();
    }

    protected ObjectSerializer getObjectSerializer() {
        return new JavaObjectSerializer();
    }

    protected ClassLoader getExecutionClassLoader() {
        return this.getClass().getClassLoader();
    }

    protected void addBuilders(List<ConfigurationBuilder> builders) {
        this.testServicesConfigurationBuilder = this.testServicesConfigurationBuilderSupplier.get();
        builders.add((ConfigurationBuilder)this.testServicesConfigurationBuilder);
    }

    protected boolean mockHttpService() {
        return true;
    }

    protected boolean mockExprExecutorService() {
        return false;
    }

    protected boolean mockExpressionLanguageMetadataService() {
        return true;
    }

    protected void configureMuleContext(MuleContextBuilder contextBuilder) {
    }

    protected ConfigurationBuilder getBuilder() throws Exception {
        return new MinimalConfigurationBuilder();
    }

    protected String getConfigurationResources() {
        return "";
    }

    protected Map<String, Object> getStartUpRegistryObjects() {
        return Collections.emptyMap();
    }

    @After
    public final void disposeContextPerTest() throws Exception {
        try {
            this.doTearDown();
        }
        finally {
            if (!this.isDisposeContextPerClass()) {
                if (this.isStartContext() && muleContext != null && muleContext.isStarted()) {
                    muleContext.stop();
                }
                AbstractMuleContextTestCase.disposeContext();
                if (this.testServicesConfigurationBuilder != null) {
                    this.testServicesConfigurationBuilder.stopServices();
                }
                this.doTearDownAfterMuleContextDispose();
            }
            this.workingDirectory.delete();
        }
    }

    protected void doTearDownAfterMuleContextDispose() throws Exception {
    }

    @AfterClass
    public static void disposeContext() throws MuleException {
        try {
            AbstractMuleContextTestCase.clearTestFlows();
            if (muleContext != null && !muleContext.isDisposed() && !muleContext.isDisposing()) {
                AbstractMuleContextTestCase.disposeOnlyMuleContext();
                AbstractMuleContextTestCase.verifyAndStopSchedulers();
                MuleConfiguration configuration = muleContext.getConfiguration();
                if (configuration != null) {
                    String workingDir = configuration.getWorkingDirectory();
                    FileUtils.deleteTree((File)FileUtils.newFile((String)workingDir), (String[])IGNORED_DOT_MULE_DIRS);
                }
            }
            FileUtils.deleteTree((File)FileUtils.newFile((String)"./ActiveMQ"));
        }
        finally {
            muleContext = null;
            TestsLogConfigurationHelper.clearLoggingConfig();
        }
    }

    public static void disposeOnlyMuleContext() {
        try {
            muleContext.dispose();
        }
        catch (IllegalStateException e) {
            LOGGER.warn(e + " : " + e.getMessage());
        }
    }

    protected static void recordSchedulersOnInit(MuleContext context) {
        if (context != null) {
            SchedulerService serviceImpl = context.getSchedulerService();
            schedulersOnInit = serviceImpl.getSchedulers();
        } else {
            schedulersOnInit = Collections.emptyList();
        }
    }

    protected static void verifyAndStopSchedulers() throws MuleException {
        SchedulerService serviceImpl = muleContext.getSchedulerService();
        if (Proxy.isProxyClass(serviceImpl.getClass()) && Proxy.getInvocationHandler(serviceImpl).getClass().getSimpleName().contains("LazyServiceProxy")) {
            return;
        }
        Set schedulersOnInitNames = schedulersOnInit.stream().map(s -> s.getName()).collect(Collectors.toSet());
        schedulersOnInit = Collections.emptyList();
        try {
            Assert.assertThat(muleContext.getSchedulerService().getSchedulers().stream().filter(s -> !schedulersOnInitNames.contains(s.getName())).collect(Collectors.toList()), (Matcher)IsEmptyCollection.empty());
        }
        finally {
            if (serviceImpl instanceof SimpleUnitTestSupportSchedulerService) {
                LifecycleUtils.stopIfNeeded((Object)serviceImpl);
            }
        }
    }

    protected void doTearDown() throws Exception {
    }

    @Override
    protected <B extends CoreEvent.Builder> B getEventBuilder() throws MuleException {
        return MuleContextUtils.eventBuilder(muleContext);
    }

    protected boolean isStartContext() {
        return this.startContext;
    }

    protected void setStartContext(boolean startContext) {
        this.startContext = startContext;
    }

    protected boolean isGracefulShutdown() {
        return false;
    }

    public SensingNullMessageProcessor getSensingNullMessageProcessor() {
        return new SensingNullMessageProcessor();
    }

    public TriggerableMessageSource getTriggerableMessageSource() {
        return new TriggerableMessageSource();
    }

    protected File getWorkingDirectory() {
        return this.workingDirectory.getRoot();
    }

    protected File getFileInsideWorkingDirectory(String fileName) {
        return new File(this.getWorkingDirectory(), fileName);
    }

    protected String getPayloadAsString(Message message) throws Exception {
        return (String)this.getPayload(message, DataType.STRING);
    }

    protected byte[] getPayloadAsBytes(Message message) throws Exception {
        return (byte[])this.getPayload(message, DataType.BYTE_ARRAY);
    }

    protected Object getPayload(Message message, DataType dataType) throws Exception {
        return muleContext.getTransformationService().transform(message, dataType).getPayload().getValue();
    }

    protected <T> T getPayload(Message message, Class<T> clazz) throws Exception {
        return (T)this.getPayload(message, DataType.fromType(clazz));
    }

    protected CoreEvent process(Processor processor, CoreEvent event) throws Exception {
        LifecycleUtils.setMuleContextIfNeeded((Object)processor, (MuleContext)muleContext);
        return processor.process(event);
    }

    public static Map<QName, Object> getAppleFlowComponentLocationAnnotations() {
        return AbstractMuleContextTestCase.getFlowComponentLocationAnnotations("appleFlow");
    }

    protected static Map<QName, Object> getFlowComponentLocationAnnotations(String rootComponentName) {
        return ImmutableMap.builder().put((Object)AbstractComponent.LOCATION_KEY, (Object)DefaultComponentLocation.from((String)rootComponentName)).put((Object)AbstractComponent.ANNOTATION_NAME, (Object)ComponentIdentifier.buildFromStringRepresentation((String)("ns:" + rootComponentName))).build();
    }

    public static <T> T sleepFor(T payload, long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return payload;
    }

    public static Object awaitLatch(Object payload, CountDownLatch latch) {
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return payload;
    }

    static {
        Field lifecycleExceptionComponentField;
        LOGGER = LoggerFactory.getLogger(AbstractMuleContextTestCase.class);
        try {
            lifecycleExceptionComponentField = LifecycleException.class.getDeclaredField("component");
            lifecycleExceptionComponentField.setAccessible(true);
        }
        catch (Exception e) {
            lifecycleExceptionComponentField = null;
            LOGGER.warn("Could not find LifecycleException's 'component' field: " + e.getMessage());
        }
        LIFECYCLE_EXCEPTION_COMPONENT_FIELD = lifecycleExceptionComponentField;
        IGNORED_DOT_MULE_DIRS = new String[]{"transaction-log"};
        System.setProperty("mule.enable.propagation.of.exceptions.in.tracing", "true");
    }
}

