/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck.junit4;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.LoggerContext;
import org.mule.runtime.core.api.util.FileUtils;

public class TestsLogConfigurationHelper {
    private static final ThreadLocal<String> LOGGING_CONFIG_CACHE = new ThreadLocal();
    private static final String LOG4J_CONFIGURATION_FILE = "log4j.configurationFile";
    private static final String NULL_CONFIG_FILE = "NULL_CONFIG_FILE";

    public static void configureLoggingForTest(Class<?> testClass) {
        String logConfigPath = LOGGING_CONFIG_CACHE.get();
        if (logConfigPath == null) {
            logConfigPath = TestsLogConfigurationHelper.findLogConfigurationPath(testClass);
        }
        TestsLogConfigurationHelper.forceConfigFile(logConfigPath);
    }

    public static void clearLoggingConfig() {
        LOGGING_CONFIG_CACHE.remove();
        System.clearProperty(LOG4J_CONFIGURATION_FILE);
        LogManager.shutdown();
    }

    private static String findLogConfigurationPath(Class<?> testClass) {
        File logConfigFile;
        String folderPath;
        String encodedFolder = testClass.getClassLoader().getResource("").getPath().toString();
        try {
            folderPath = URLDecoder.decode(encodedFolder, Charset.defaultCharset().name());
        }
        catch (UnsupportedEncodingException e) {
            return NULL_CONFIG_FILE;
        }
        File folder = new File(folderPath);
        if (folder != null && "target".equals(folder.getParentFile().getName())) {
            folder = folder.getParentFile();
        }
        if ((logConfigFile = FileUtils.findFileByName((File)folder, (String)"log4j2-test.xml")) == null) {
            logConfigFile = FileUtils.findFileByName((File)folder, (String)"log4j2.xml");
        }
        String logConfigPath = logConfigFile != null && logConfigFile.isFile() ? logConfigFile.toURI().toString() : NULL_CONFIG_FILE;
        LOGGING_CONFIG_CACHE.set(logConfigPath);
        return logConfigPath;
    }

    private static void forceConfigFile(String logConfigFile) {
        if (!NULL_CONFIG_FILE.equals(logConfigFile)) {
            System.setProperty(LOG4J_CONFIGURATION_FILE, logConfigFile);
        }
        LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
        ctx.reconfigure();
    }
}

