/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck.junit4.matcher;

import org.hamcrest.Description;
import org.hamcrest.TypeSafeMatcher;
import org.mule.runtime.api.metadata.MetadataKey;

public final class MetadataKeyMatcher
extends TypeSafeMatcher<MetadataKey> {
    private final String id;
    private String displayName;
    private String partName;
    private StringBuilder descriptionBuilder = new StringBuilder();

    private MetadataKeyMatcher(String id) {
        this.id = id;
        this.descriptionBuilder.append(String.format("a MetadataKey with id: '%s'", id));
    }

    public static MetadataKeyMatcher metadataKeyWithId(String id) {
        return new MetadataKeyMatcher(id);
    }

    protected boolean matchesSafely(MetadataKey metadataKey) {
        try {
            this.validateEquals(this.id, metadataKey.getId());
            this.validateEquals(this.displayName, metadataKey.getDisplayName());
            this.validateEquals(this.partName, metadataKey.getPartName());
            return true;
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    public void describeTo(Description description) {
        description.appendText(this.descriptionBuilder.toString());
    }

    public MetadataKeyMatcher withDisplayName(String displayName) {
        this.displayName = displayName;
        this.descriptionBuilder.append(String.format(", displayName: '%s'", displayName));
        return this;
    }

    public MetadataKeyMatcher withPartName(String partName) {
        this.partName = partName;
        this.descriptionBuilder.append(String.format(", partName: '%s'", partName));
        return this;
    }

    private void validateEquals(String actual, String expected) {
        if (actual != null && !expected.equals(actual)) {
            throw new RuntimeException(String.format("Assertion Error - Actual: '%s' Expected: '%s'", actual, expected));
        }
    }
}

