/*
 * Decompiled with CFR 0.152.
 */
package org.mule.functional.junit4.matchers;

import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public class ClassNameMatcher<T>
extends TypeSafeMatcher<T> {
    private final Matcher<String> matcher;

    private ClassNameMatcher(Matcher<String> matcher) {
        this.matcher = matcher;
    }

    public void describeTo(Description description) {
        description.appendText("object with class name ");
        description.appendDescriptionOf(this.matcher);
    }

    protected boolean matchesSafely(T item) {
        return this.matcher.matches((Object)item.getClass().getName());
    }

    protected void describeMismatchSafely(T item, Description description) {
        description.appendText("class name ");
        this.matcher.describeMismatch((Object)item.getClass().getName(), description);
    }

    @Factory
    public static <T> Matcher<T> hasClassName(Matcher<String> matcher) {
        return new ClassNameMatcher<T>(matcher);
    }
}

