/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck.junit4.matcher;

import org.hamcrest.Description;
import org.hamcrest.DiagnosingMatcher;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;

public class HasClassInHierarchy
extends DiagnosingMatcher<Object> {
    private final String expectedClassName;

    private HasClassInHierarchy(String expectedClassName) {
        this.expectedClassName = expectedClassName;
    }

    protected boolean matches(Object item, Description mismatch) {
        if (null == item) {
            mismatch.appendText("null");
            return false;
        }
        Class<?> currentClass = item.getClass();
        StringBuilder builder = new StringBuilder();
        do {
            if (this.expectedClassName.equals(currentClass.getName())) {
                return true;
            }
            builder.append(currentClass.getName()).append("\n");
        } while ((currentClass = currentClass.getSuperclass()) != null);
        mismatch.appendText(builder.toString());
        return false;
    }

    public void describeTo(Description description) {
        description.appendText("a value with a class hierarchy containing ").appendText(this.expectedClassName);
    }

    @Factory
    public static <T> Matcher<T> withClassName(String expectedClassName) {
        return new HasClassInHierarchy(expectedClassName);
    }
}

