/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.mockito.ArgumentMatchers;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.component.location.ConfigurationComponentLocator;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.core.api.Injector;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.construct.Flow;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.exception.FlowExceptionHandler;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.api.processor.Sink;
import org.mule.runtime.core.api.processor.strategy.ProcessingStrategy;
import org.mule.runtime.core.api.processor.strategy.ProcessingStrategyFactory;
import org.mule.runtime.core.api.source.MessageSource;
import org.mule.runtime.core.internal.context.DefaultMuleContext;
import org.mule.runtime.core.internal.context.MuleContextWithRegistry;
import org.mule.runtime.core.internal.processor.strategy.StreamPerEventSink;
import org.mule.runtime.core.internal.registry.MuleRegistry;
import org.mule.runtime.dsl.api.component.config.DefaultComponentLocation;
import org.mule.runtime.extension.api.runtime.operation.CompletableComponentExecutor;
import org.mule.runtime.extension.api.runtime.operation.ExecutionContext;
import org.mule.tck.util.ClassUtils;

public final class MuleTestUtils {
    public static final String APPLE_SERVICE = "appleService";
    public static final String APPLE_FLOW = "appleFlow";

    public static Error createErrorMock(Exception exception) {
        Error errorMock = (Error)Mockito.mock(Error.class);
        Mockito.when((Object)errorMock.getCause()).thenReturn((Object)exception);
        return errorMock;
    }

    public static Injector spyInjector(MuleContext muleContext) {
        Injector spy = (Injector)Mockito.spy((Object)muleContext.getInjector());
        ((DefaultMuleContext)muleContext).setInjector(spy);
        return spy;
    }

    public static Flow getTestFlow(MuleContext context) throws MuleException {
        return MuleTestUtils.createFlow(context, APPLE_FLOW);
    }

    public static Flow createFlowWithSource(MuleContext context, String flowName, Optional<ProcessingStrategyFactory> processingStrategyFactory, MessageSource source) throws MuleException {
        FlowExceptionHandler defaultErrorHandler = context.getDefaultErrorHandler(Optional.empty());
        LifecycleUtils.initialiseIfNeeded((Object)defaultErrorHandler, (MuleContext)context);
        LifecycleUtils.startIfNeeded((Object)defaultErrorHandler);
        Flow.Builder flowBuilder = Flow.builder((String)flowName, (MuleContext)context).processingStrategyFactory(processingStrategyFactory.orElse((profilingService, featureFlaggingService, schedulerService, schedulerBaseConfig, schedulersNamePrefix, artifactId, artifactType, shutdownTimeoutSupplier) -> ClassUtils.withContextClassLoader(MuleTestUtils.class.getClassLoader(), () -> (TestDirectProcessingStrategy)Mockito.spy((Object)new TestDirectProcessingStrategy())))).messagingExceptionHandler(defaultErrorHandler);
        if (source != null) {
            flowBuilder.source(source);
        }
        Flow flow = flowBuilder.build();
        flow.setAnnotations(Collections.singletonMap(AbstractComponent.LOCATION_KEY, DefaultComponentLocation.from((String)flowName)));
        return flow;
    }

    public static Flow createFlowWithSource(MuleContext context, String flowName, MessageSource source) throws MuleException {
        return MuleTestUtils.createFlowWithSource(context, flowName, Optional.empty(), source);
    }

    public static Flow createFlow(MuleContext context, String flowName, Optional<ProcessingStrategyFactory> processingStrategyFactory) throws MuleException {
        return MuleTestUtils.createFlowWithSource(context, flowName, processingStrategyFactory, null);
    }

    public static Flow createFlow(MuleContext context, String flowName) throws MuleException {
        return MuleTestUtils.createFlowWithSource(context, flowName, Optional.empty(), null);
    }

    public static Flow createAndRegisterFlow(MuleContext context, String flowName, ConfigurationComponentLocator mockComponentLocator) throws MuleException {
        return MuleTestUtils.createAndRegisterFlow(context, flowName, mockComponentLocator, null);
    }

    public static Flow createAndRegisterFlow(MuleContext context, String flowName, ConfigurationComponentLocator mockComponentLocator, ProcessingStrategyFactory processingStrategyFactory) throws MuleException {
        Flow flow = MuleTestUtils.createFlow(context, flowName, Optional.ofNullable(processingStrategyFactory));
        MuleRegistry registry = ((MuleContextWithRegistry)context).getRegistry();
        if (registry != null) {
            registry.registerFlowConstruct((FlowConstruct)flow);
        }
        Mockito.when((Object)mockComponentLocator.find(Location.builder().globalName(flowName).build())).thenReturn(Optional.of(flow));
        return flow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void testWithSystemProperty(String propertyName, Object propertyValue, TestCallback callback) throws Exception {
        assert (propertyName != null && callback != null);
        Object originalPropertyValue = null;
        try {
            originalPropertyValue = propertyValue == null ? System.getProperties().remove(propertyName) : System.getProperties().put(propertyName, propertyValue);
            callback.run();
        }
        finally {
            if (originalPropertyValue == null) {
                System.getProperties().remove(propertyName);
            } else {
                System.getProperties().put(propertyName, originalPropertyValue);
            }
        }
    }

    public static void testWithSystemProperties(Map<String, String> properties, TestCallback callback) throws Exception {
        assert (properties != null && callback != null);
        HashMap<String, String> originalPropertyValues = new HashMap<String, String>();
        properties.forEach((propertyName, propertyValue) -> {
            if (propertyValue == null) {
                originalPropertyValues.put((String)propertyName, System.clearProperty(propertyName));
            } else {
                originalPropertyValues.put((String)propertyName, System.setProperty(propertyName, propertyValue));
            }
        });
        try {
            callback.run();
        }
        finally {
            originalPropertyValues.forEach((propertyName, originalPropertyValue) -> {
                if (originalPropertyValue == null) {
                    System.clearProperty(propertyName);
                } else {
                    System.setProperty(propertyName, originalPropertyValue);
                }
            });
        }
    }

    public static Thread getRunningThreadByName(String name) {
        for (Thread thread : Thread.getAllStackTraces().keySet()) {
            if (!thread.getName().equals(name)) continue;
            return thread;
        }
        return null;
    }

    public static List<FlowExceptionHandler> getExceptionListeners(FlowConstruct flow) {
        try {
            Method getExceptionListenerMethod = flow.getClass().getMethod("getExceptionListener", new Class[0]);
            FlowExceptionHandler exceptionListener = (FlowExceptionHandler)getExceptionListenerMethod.invoke((Object)flow, new Object[0]);
            return MuleTestUtils.getExceptionListeners(exceptionListener);
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot obtain exception listener for flow", e);
        }
    }

    public static List<FlowExceptionHandler> getExceptionListeners(FlowExceptionHandler exceptionHandler) {
        try {
            Method getExceptionListenersMethod = exceptionHandler.getClass().getMethod("getExceptionListeners", new Class[0]);
            Object exceptionListeners = getExceptionListenersMethod.invoke((Object)exceptionHandler, new Object[0]);
            return (List)exceptionListeners;
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot obtain exception listener for flow", e);
        }
    }

    public static List<Processor> getMessageProcessors(Object object) {
        try {
            Method getExceptionListenersMethod = object.getClass().getMethod("getMessageProcessors", new Class[0]);
            Object processors = getExceptionListenersMethod.invoke(object, new Object[0]);
            return (List)processors;
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot obtain processors from the object");
        }
    }

    public static <M extends ComponentModel> CompletableComponentExecutor<M> mockComponentExecutor(Object returnValue) {
        return MuleTestUtils.stubComponentExecutor((CompletableComponentExecutor)Mockito.mock(CompletableComponentExecutor.class, (MockSettings)Mockito.withSettings().lenient()), returnValue);
    }

    public static <M extends ComponentModel> CompletableComponentExecutor<M> stubComponentExecutor(CompletableComponentExecutor<M> executor, Object returnValue) {
        ((CompletableComponentExecutor)Mockito.doAnswer(invocation -> {
            CompletableComponentExecutor.ExecutorCallback callback = (CompletableComponentExecutor.ExecutorCallback)invocation.getArgument(1);
            callback.complete(returnValue);
            return null;
        }).when(executor)).execute((ExecutionContext)ArgumentMatchers.any(), (CompletableComponentExecutor.ExecutorCallback)ArgumentMatchers.any());
        return executor;
    }

    public static <M extends ComponentModel> CompletableComponentExecutor<M> stubFailingComponentExecutor(CompletableComponentExecutor<M> executor, Throwable t) {
        ((CompletableComponentExecutor)Mockito.doAnswer(invocation -> {
            CompletableComponentExecutor.ExecutorCallback callback = (CompletableComponentExecutor.ExecutorCallback)invocation.getArgument(1);
            callback.error(t);
            return null;
        }).when(executor)).execute((ExecutionContext)ArgumentMatchers.any(), (CompletableComponentExecutor.ExecutorCallback)ArgumentMatchers.any());
        return executor;
    }

    public static interface TestCallback {
        public void run() throws Exception;
    }

    public static class TestDirectProcessingStrategy
    implements ProcessingStrategy {
        public boolean isSynchronous() {
            return true;
        }

        public Sink createSink(FlowConstruct flowConstruct, ReactiveProcessor pipeline) {
            return new StreamPerEventSink(pipeline, event -> {});
        }
    }
}

