/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tck.report;

import static org.slf4j.LoggerFactory.getLogger;

import java.util.concurrent.TimeoutException;

import org.junit.rules.TestWatcher;
import org.junit.runner.Description;
import org.junit.runners.model.TestTimedOutException;
import org.slf4j.Logger;

/**
 * Rule that generates a thread dump on failure.
 *
 * @since 4.1
 */
public class ThreadDumpOnTimeOut extends TestWatcher {

  private static final Logger LOGGER = getLogger(ThreadDumpOnTimeOut.class);

  private final boolean forcePrint;

  public ThreadDumpOnTimeOut() {
    this(false);
  }

  public ThreadDumpOnTimeOut(boolean forcePrint) {
    this.forcePrint = forcePrint;
  }

  @Override
  protected void failed(Throwable e, Description description) {
    super.failed(e, description);

    if (e instanceof TestTimedOutException || e instanceof TimeoutException) {
      LOGGER.error("test timed out. Maybe due to a deadlock?");
      if (forcePrint) {
        new ThreadDumper(false).logThreadDump();
      } else if (LOGGER.isTraceEnabled()) {
        new ThreadDumper(true).logThreadDump();
      }
    }
  }
}
