/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck.probe;

import org.apache.commons.lang3.exception.ExceptionUtils;
import org.mule.tck.probe.Probe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JUnitProbe
implements Probe {
    private static final Logger logger = LoggerFactory.getLogger(JUnitProbe.class);
    private AssertionError firstFailure;
    protected AssertionError lastFailure;
    private Throwable throwable;

    @Override
    public final boolean isSatisfied() {
        try {
            return this.test();
        }
        catch (AssertionError e) {
            this.storeAssertionError(e);
            return false;
        }
        catch (Throwable e) {
            this.throwable = e;
            if (this.throwable.getCause() instanceof AssertionError) {
                this.storeAssertionError((AssertionError)((Object)this.throwable.getCause()));
            }
            logger.debug("Probing failed with exception", e);
            return false;
        }
    }

    private void storeAssertionError(AssertionError e) {
        if (this.firstFailure == null) {
            this.firstFailure = e;
        }
        this.lastFailure = e;
    }

    protected abstract boolean test() throws Exception;

    @Override
    public String describeFailure() {
        if (this.lastFailure != null) {
            return ((Throwable)((Object)this.lastFailure)).getMessage();
        }
        if (this.throwable != null) {
            return ExceptionUtils.getStackTrace((Throwable)this.throwable);
        }
        return "Condition not met";
    }
}

