/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ZipUtils {
    private ZipUtils() {
    }

    public static void compress(File targetFile, ZipResource[] resources) {
        try (ZipOutputStream out = new ZipOutputStream(new FileOutputStream(targetFile));){
            for (ZipResource zipResource : resources) {
                try (InputStream in = ZipUtils.getResourceOrFileAsStream(zipResource.file);){
                    int count;
                    out.putNextEntry(new ZipEntry(zipResource.alias == null ? zipResource.file : zipResource.alias));
                    byte[] buffer = new byte[1024];
                    while ((count = in.read(buffer)) > 0) {
                        out.write(buffer, 0, count);
                    }
                }
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static InputStream getResourceOrFileAsStream(String resourceOrFileName) throws FileNotFoundException {
        InputStream zipResourceAsStream = ZipUtils.class.getClassLoader().getResourceAsStream(resourceOrFileName);
        if (zipResourceAsStream == null) {
            zipResourceAsStream = new FileInputStream(new File(resourceOrFileName));
        }
        return zipResourceAsStream;
    }

    public static class ZipResource {
        private final String file;
        private final String alias;

        public ZipResource(String file, String alias) {
            this.file = file;
            this.alias = alias;
        }

        public String getFile() {
            return this.file;
        }

        public String getAlias() {
            return this.alias;
        }
    }
}

