/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tck.junit5;

import static org.mule.tck.config.TestServicesConfigurationBuilder.initCachedExprLanguageFactory;

import static java.nio.charset.StandardCharsets.UTF_8;

import static org.mockito.Mockito.mock;

import org.mule.runtime.api.config.ArtifactEncoding;
import org.mule.runtime.api.el.DefaultExpressionLanguageFactoryService;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.core.api.config.MuleConfiguration;
import org.mule.runtime.core.api.el.ExtendedExpressionManager;
import org.mule.runtime.core.internal.el.DefaultExpressionManager;
import org.mule.runtime.core.internal.el.dataweave.DataWeaveExpressionLanguageAdaptor;

public class InjectDataWeaveExtension extends AbstractResourceExtension<InjectDataWeave, ExtendedExpressionManager> {

  private DefaultExpressionManager expressionManager;

  protected InjectDataWeaveExtension() {
    super(InjectDataWeave.class);
  }

  @Override
  protected ExtendedExpressionManager createResource(InjectDataWeave annotation) {
    expressionManager = new DefaultExpressionManager();
    DefaultExpressionLanguageFactoryService service = initCachedExprLanguageFactory();
    ArtifactEncoding artifactEncoding = () -> UTF_8;
    expressionManager.setExpressionLanguage(new DataWeaveExpressionLanguageAdaptor(null, // muleContext
                                                                                   null,
                                                                                   mock(MuleConfiguration.class),
                                                                                   artifactEncoding,
                                                                                   service,
                                                                                   null));
    try {
      expressionManager.initialise();
    } catch (InitialisationException e) {
      throw new RuntimeException(e);
    }

    return expressionManager;
  }

  @Override
  protected void disposeResource(InjectDataWeave annotation, ExtendedExpressionManager value) {
    expressionManager.dispose();
    expressionManager = null;
  }

}
