/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck.junit4.matcher;

import java.util.Arrays;
import java.util.stream.Collectors;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import org.hamcrest.core.IsCollectionContaining;
import org.mule.runtime.api.value.Value;

public final class ValueMatcher
extends TypeSafeMatcher<Value> {
    private final Matcher<String> id;
    private Matcher<String> displayName;
    private Matcher<String> partName;
    private StringBuilder descriptionBuilder = new StringBuilder();
    private ValueMatcher[] childValues = new ValueMatcher[0];

    private ValueMatcher(Matcher<String> id) {
        this.id = id;
        this.descriptionBuilder.append(String.format("a Value whose ID %s", id));
    }

    public static ValueMatcher valueWithId(Matcher<String> id) {
        return new ValueMatcher(id);
    }

    public static ValueMatcher valueWithId(String id) {
        return ValueMatcher.valueWithId((Matcher<String>)CoreMatchers.is((Object)id));
    }

    protected boolean matchesSafely(Value value) {
        try {
            this.assertThat(value.getId(), this.id);
            this.assertThat(value.getDisplayName(), this.displayName);
            this.assertThat(value.getPartName(), this.partName);
            this.assertThat(value.getChilds(), IsCollectionContaining.hasItems((Matcher[])this.childValues));
            return true;
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    public void describeTo(Description description) {
        description.appendText(this.descriptionBuilder.toString());
    }

    public ValueMatcher withDisplayName(String displayName) {
        return this.withDisplayName((Matcher<String>)CoreMatchers.is((Object)displayName));
    }

    public ValueMatcher withDisplayName(Matcher<String> displayName) {
        this.displayName = displayName;
        this.descriptionBuilder.append(String.format(", whose displayName %s", displayName));
        return this;
    }

    public ValueMatcher withPartName(String partName) {
        return this.withPartName((Matcher<String>)CoreMatchers.is((Object)partName));
    }

    public ValueMatcher withPartName(Matcher<String> partName) {
        this.partName = partName;
        this.descriptionBuilder.append(String.format(", whose partName %s", partName));
        return this;
    }

    public ValueMatcher withChilds(ValueMatcher ... valueMatcher) {
        this.childValues = valueMatcher;
        this.descriptionBuilder.append(String.format(", with child values that %s", Arrays.stream(this.childValues).map(Object::toString).collect(Collectors.joining(", "))));
        return this;
    }

    private <T> void assertThat(T actual, Matcher<T> expected) {
        if (expected != null && !expected.matches(actual)) {
            throw new RuntimeException();
        }
    }
}

