/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck.junit4.rule;

import java.io.IOException;
import java.net.ServerSocket;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FreePortFinder {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final int minPortNumber;
    private final int portRange;
    private final Set<Integer> selectedPorts = new HashSet<Integer>();
    private final Random random = new Random();

    public FreePortFinder(int minPortNumber, int maxPortNumber) {
        this.minPortNumber = minPortNumber;
        this.portRange = maxPortNumber - minPortNumber;
    }

    public synchronized Integer find() {
        for (int i = 0; i < this.portRange; ++i) {
            int port = this.minPortNumber + this.random.nextInt(this.portRange);
            if (this.selectedPorts.contains(port) || !this.isPortFree(port)) continue;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Found free port: " + port);
            }
            this.selectedPorts.add(port);
            return port;
        }
        throw new IllegalStateException("Unable to find an available port");
    }

    public synchronized void releasePort(int port) {
        if (this.isPortFree(port)) {
            this.selectedPorts.remove(port);
        } else if (this.logger.isInfoEnabled()) {
            this.logger.info(String.format("Port %d was is not correctly released", port));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPortFree(int port) {
        boolean portIsFree = true;
        ServerSocket server = null;
        try {
            server = new ServerSocket(port);
            server.setReuseAddress(true);
        }
        catch (IOException e) {
            portIsFree = false;
        }
        finally {
            if (server != null) {
                try {
                    server.close();
                }
                catch (IOException iOException) {}
            }
        }
        return portIsFree;
    }
}

