/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck.junit4;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.hamcrest.Matcher;
import org.hamcrest.collection.IsEmptyCollection;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.rules.TemporaryFolder;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.core.DefaultEventContext;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.EventContext;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.ConfigurationBuilder;
import org.mule.runtime.core.api.config.MuleConfiguration;
import org.mule.runtime.core.api.construct.Flow;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.api.context.MuleContextBuilder;
import org.mule.runtime.core.api.context.notification.MuleContextNotificationListener;
import org.mule.runtime.core.api.context.notification.ServerNotificationListener;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.message.InternalMessage;
import org.mule.runtime.core.api.object.ObjectFactory;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.registry.RegistrationException;
import org.mule.runtime.core.api.scheduler.SchedulerService;
import org.mule.runtime.core.api.serialization.JavaObjectSerializer;
import org.mule.runtime.core.api.serialization.ObjectSerializer;
import org.mule.runtime.core.component.DefaultJavaComponent;
import org.mule.runtime.core.config.DefaultMuleConfiguration;
import org.mule.runtime.core.config.builders.DefaultsConfigurationBuilder;
import org.mule.runtime.core.config.builders.SimpleConfigurationBuilder;
import org.mule.runtime.core.context.DefaultMuleContextBuilder;
import org.mule.runtime.core.context.DefaultMuleContextFactory;
import org.mule.runtime.core.context.notification.MuleContextNotification;
import org.mule.runtime.core.object.SingletonObjectFactory;
import org.mule.runtime.core.util.ClassUtils;
import org.mule.runtime.core.util.FileUtils;
import org.mule.runtime.core.util.concurrent.Latch;
import org.mule.tck.MuleTestUtils;
import org.mule.tck.SensingNullMessageProcessor;
import org.mule.tck.SimpleUnitTestSupportSchedulerService;
import org.mule.tck.TriggerableMessageSource;
import org.mule.tck.config.TestServicesConfigurationBuilder;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.junit4.TestsLogConfigurationHelper;

public abstract class AbstractMuleContextTestCase
extends AbstractMuleTestCase {
    public static final String WORKING_DIRECTORY_SYSTEM_PROPERTY_KEY = "workingDirectory";
    public static final String REACTOR_BLOCK_TIMEOUT_EXCEPTION_MESSAGE = "Timeout on blocking read";
    public TemporaryFolder workingDirectory = new TemporaryFolder();
    public static final String[] IGNORED_DOT_MULE_DIRS = new String[]{"transaction-log"};
    protected static MuleContext muleContext;
    private boolean startContext = false;
    public static final String TEST_MESSAGE = "Test Message";
    public static final long LOCK_TIMEOUT = 30000L;
    public static final int RECEIVE_TIMEOUT = 5000;
    public static final int BLOCK_TIMEOUT = 50;
    protected Latch callbackCalled;
    private boolean disposeContextPerClass;
    private static boolean logConfigured;
    private static List<Scheduler> schedulersOnInit;

    protected boolean isDisposeContextPerClass() {
        return this.disposeContextPerClass;
    }

    protected void setDisposeContextPerClass(boolean val) {
        this.disposeContextPerClass = val;
    }

    @Before
    public final void setUpMuleContext() throws Exception {
        if (!logConfigured) {
            TestsLogConfigurationHelper.configureLoggingForTest(this.getClass());
            logConfigured = true;
        }
        this.workingDirectory.create();
        String workingDirectoryOldValue = System.setProperty(WORKING_DIRECTORY_SYSTEM_PROPERTY_KEY, this.workingDirectory.getRoot().getAbsolutePath());
        try {
            this.doSetUpBeforeMuleContextCreation();
            muleContext = this.createMuleContext();
            if (this.isStartContext() && muleContext != null && !muleContext.isStarted()) {
                this.startMuleContext();
            }
            this.doSetUp();
        }
        finally {
            if (workingDirectoryOldValue != null) {
                System.setProperty(WORKING_DIRECTORY_SYSTEM_PROPERTY_KEY, workingDirectoryOldValue);
            } else {
                System.clearProperty(WORKING_DIRECTORY_SYSTEM_PROPERTY_KEY);
            }
        }
    }

    protected void doSetUpBeforeMuleContextCreation() throws Exception {
    }

    private void startMuleContext() throws MuleException, InterruptedException {
        final AtomicReference<Latch> contextStartedLatch = new AtomicReference<Latch>();
        contextStartedLatch.set(new Latch());
        MuleContextNotificationListener<MuleContextNotification> listener = new MuleContextNotificationListener<MuleContextNotification>(){

            public boolean isBlocking() {
                return false;
            }

            public void onNotification(MuleContextNotification notification) {
                ((Latch)contextStartedLatch.get()).countDown();
            }
        };
        muleContext.registerListener((ServerNotificationListener)listener);
        muleContext.start();
        ((Latch)contextStartedLatch.get()).await(20L, TimeUnit.SECONDS);
    }

    protected void doSetUp() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MuleContext createMuleContext() throws Exception {
        MuleContext context;
        if (this.isDisposeContextPerClass() && muleContext != null) {
            context = muleContext;
        } else {
            ClassLoader executionClassLoader = this.getExecutionClassLoader();
            ClassLoader originalContextClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(executionClassLoader);
                DefaultMuleContextFactory muleContextFactory = new DefaultMuleContextFactory();
                ArrayList<ConfigurationBuilder> builders = new ArrayList<ConfigurationBuilder>();
                builders.add((ConfigurationBuilder)new TestServicesConfigurationBuilder());
                builders.add((ConfigurationBuilder)new SimpleConfigurationBuilder((Map)this.getStartUpProperties()));
                builders.add(this.getBuilder());
                this.addBuilders(builders);
                DefaultMuleContextBuilder contextBuilder = new DefaultMuleContextBuilder();
                DefaultMuleConfiguration muleConfiguration = new DefaultMuleConfiguration();
                String workingDirectory = this.workingDirectory.getRoot().getAbsolutePath();
                this.logger.info("Using working directory for test: " + workingDirectory);
                muleConfiguration.setWorkingDirectory(workingDirectory);
                contextBuilder.setMuleConfiguration((MuleConfiguration)muleConfiguration);
                contextBuilder.setExecutionClassLoader(executionClassLoader);
                contextBuilder.setObjectSerializer(this.getObjectSerializer());
                this.configureMuleContext((MuleContextBuilder)contextBuilder);
                context = muleContextFactory.createMuleContext(builders, (MuleContextBuilder)contextBuilder);
                AbstractMuleContextTestCase.recordSchedulersOnInit(context);
                if (!this.isGracefulShutdown()) {
                    ((DefaultMuleConfiguration)context.getConfiguration()).setShutdownTimeout(0);
                }
            }
            finally {
                Thread.currentThread().setContextClassLoader(originalContextClassLoader);
            }
        }
        return context;
    }

    protected ObjectSerializer getObjectSerializer() {
        return new JavaObjectSerializer();
    }

    protected ClassLoader getExecutionClassLoader() {
        return this.getClass().getClassLoader();
    }

    protected void addBuilders(List<ConfigurationBuilder> builders) {
        builders.add((ConfigurationBuilder)new TestServicesConfigurationBuilder(this.mockHttpService()));
    }

    protected boolean mockHttpService() {
        return true;
    }

    protected void configureMuleContext(MuleContextBuilder contextBuilder) {
    }

    protected ConfigurationBuilder getBuilder() throws Exception {
        return new DefaultsConfigurationBuilder();
    }

    protected String getConfigurationResources() {
        return "";
    }

    protected Properties getStartUpProperties() {
        return null;
    }

    @After
    public final void disposeContextPerTest() throws Exception {
        this.doTearDown();
        if (!this.isDisposeContextPerClass()) {
            if (this.isStartContext() && muleContext != null && muleContext.isStarted()) {
                muleContext.stop();
            }
            AbstractMuleContextTestCase.disposeContext();
            this.doTearDownAfterMuleContextDispose();
        }
        this.workingDirectory.delete();
    }

    protected void doTearDownAfterMuleContextDispose() throws Exception {
    }

    @AfterClass
    public static void disposeContext() throws RegistrationException, MuleException {
        try {
            if (muleContext != null && !muleContext.isDisposed() && !muleContext.isDisposing()) {
                muleContext.dispose();
                AbstractMuleContextTestCase.verifyAndStopSchedulers();
                MuleConfiguration configuration = muleContext.getConfiguration();
                if (configuration != null) {
                    String workingDir = configuration.getWorkingDirectory();
                    FileUtils.deleteTree((File)FileUtils.newFile((String)workingDir), (String[])IGNORED_DOT_MULE_DIRS);
                }
            }
            FileUtils.deleteTree((File)FileUtils.newFile((String)"./ActiveMQ"));
        }
        finally {
            muleContext = null;
            TestsLogConfigurationHelper.clearLoggingConfig();
        }
    }

    protected static void recordSchedulersOnInit(MuleContext context) {
        if (context != null) {
            SchedulerService serviceImpl = context.getSchedulerService();
            schedulersOnInit = serviceImpl.getSchedulers();
        } else {
            schedulersOnInit = Collections.emptyList();
        }
    }

    protected static void verifyAndStopSchedulers() throws MuleException {
        SchedulerService serviceImpl = muleContext.getSchedulerService();
        ArrayList schedulers = new ArrayList(serviceImpl.getSchedulers());
        schedulers.removeAll(schedulersOnInit);
        try {
            Assert.assertThat(schedulers, (Matcher)IsEmptyCollection.empty());
        }
        finally {
            schedulers.forEach(sched -> sched.shutdownNow());
            if (serviceImpl instanceof SimpleUnitTestSupportSchedulerService) {
                LifecycleUtils.stopIfNeeded((Object)serviceImpl);
            }
        }
    }

    protected void doTearDown() throws Exception {
    }

    public static Flow getTestFlowWithComponent(String name, Class<?> clazz) throws Exception {
        SingletonObjectFactory of = new SingletonObjectFactory(clazz, null);
        of.initialise();
        DefaultJavaComponent component = new DefaultJavaComponent((ObjectFactory)of);
        ((MuleContextAware)component).setMuleContext(muleContext);
        Flow flow = Flow.builder((String)name, (MuleContext)muleContext).messageProcessors(Collections.singletonList(component)).build();
        muleContext.getRegistry().registerFlowConstruct((FlowConstruct)flow);
        return flow;
    }

    protected static Event.Builder eventBuilder() throws MuleException {
        Flow flowConstruct = MuleTestUtils.getTestFlow(muleContext);
        return Event.builder((EventContext)DefaultEventContext.create((FlowConstruct)flowConstruct, (String)"test")).flow((FlowConstruct)flowConstruct);
    }

    protected boolean isStartContext() {
        return this.startContext;
    }

    protected void setStartContext(boolean startContext) {
        this.startContext = startContext;
    }

    protected boolean isGracefulShutdown() {
        return false;
    }

    protected <T> T createObject(Class<T> clazz) throws Exception {
        return this.createObject(clazz, ClassUtils.NO_ARGS);
    }

    protected <T> T createObject(Class<T> clazz, Object ... args) throws Exception {
        if (args == null) {
            args = ClassUtils.NO_ARGS;
        }
        Object o = ClassUtils.instanciateClass(clazz, (Object[])args);
        muleContext.getRegistry().registerObject(String.valueOf(o.hashCode()), o);
        return (T)o;
    }

    protected void initialiseObject(Object o) throws RegistrationException {
        muleContext.getRegistry().registerObject(String.valueOf(o.hashCode()), o);
    }

    public SensingNullMessageProcessor getSensingNullMessageProcessor() {
        return new SensingNullMessageProcessor();
    }

    public TriggerableMessageSource getTriggerableMessageSource() {
        return new TriggerableMessageSource();
    }

    protected File getWorkingDirectory() {
        return this.workingDirectory.getRoot();
    }

    protected File getFileInsideWorkingDirectory(String fileName) {
        return new File(this.getWorkingDirectory(), fileName);
    }

    @Deprecated
    protected String getPayloadAsString(InternalMessage message) throws Exception {
        return (String)this.getPayload(message, DataType.STRING);
    }

    protected String getPayloadAsString(Message message) throws Exception {
        return this.getPayloadAsString((InternalMessage)message);
    }

    protected byte[] getPayloadAsBytes(InternalMessage message) throws Exception {
        return (byte[])this.getPayload(message, DataType.BYTE_ARRAY);
    }

    protected Object getPayload(InternalMessage message, DataType dataType) throws Exception {
        return muleContext.getTransformationService().transform(message, dataType).getPayload().getValue();
    }

    protected <T> T getPayload(InternalMessage message, Class<T> clazz) throws Exception {
        return (T)this.getPayload(message, DataType.fromType(clazz));
    }

    protected Event process(Processor processor, Event event) throws Exception {
        LifecycleUtils.setMuleContextIfNeeded((Object)processor, (MuleContext)muleContext);
        return processor.process(event);
    }
}

