/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TimeZone;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.core.api.scheduler.SchedulerConfig;
import org.mule.runtime.core.api.scheduler.SchedulerService;
import org.mule.runtime.core.util.concurrent.NamedThreadFactory;
import org.mule.tck.SimpleUnitTestSupportLifecycleSchedulerDecorator;
import org.mule.tck.SimpleUnitTestSupportScheduler;

public class SimpleUnitTestSupportSchedulerService
implements SchedulerService,
Stoppable {
    private SimpleUnitTestSupportScheduler scheduler = new SimpleUnitTestSupportScheduler(8, (ThreadFactory)new NamedThreadFactory(SimpleUnitTestSupportScheduler.class.getSimpleName()), new ThreadPoolExecutor.AbortPolicy());
    private List<Scheduler> decorators = new ArrayList<Scheduler>();

    public String getName() {
        return this.getClass().getSimpleName();
    }

    public Scheduler cpuLightScheduler() {
        SimpleUnitTestSupportLifecycleSchedulerDecorator decorator = this.decorateScheduler(this.scheduler);
        this.decorators.add(decorator);
        return decorator;
    }

    public Scheduler ioScheduler() {
        SimpleUnitTestSupportLifecycleSchedulerDecorator decorator = this.decorateScheduler(this.scheduler);
        this.decorators.add(decorator);
        return decorator;
    }

    public Scheduler cpuIntensiveScheduler() {
        SimpleUnitTestSupportLifecycleSchedulerDecorator decorator = this.decorateScheduler(this.scheduler);
        this.decorators.add(decorator);
        return decorator;
    }

    public Scheduler cpuLightScheduler(SchedulerConfig config) {
        SimpleUnitTestSupportLifecycleSchedulerDecorator decorator = this.decorateScheduler(this.scheduler);
        this.decorators.add(decorator);
        return decorator;
    }

    public Scheduler ioScheduler(SchedulerConfig config) {
        SimpleUnitTestSupportLifecycleSchedulerDecorator decorator = this.decorateScheduler(this.scheduler);
        this.decorators.add(decorator);
        return decorator;
    }

    public Scheduler cpuIntensiveScheduler(SchedulerConfig config) {
        SimpleUnitTestSupportLifecycleSchedulerDecorator decorator = this.decorateScheduler(this.scheduler);
        this.decorators.add(decorator);
        return decorator;
    }

    public Scheduler customScheduler(SchedulerConfig config) {
        SimpleUnitTestSupportLifecycleSchedulerDecorator decorator = this.decorateScheduler(new SimpleUnitTestSupportScheduler(config.getMaxConcurrentTasks(), (ThreadFactory)new NamedThreadFactory(config.getSchedulerName() != null ? config.getSchedulerName() : "SimpleUnitTestSupportSchedulerService_custom"), new ThreadPoolExecutor.AbortPolicy()));
        this.decorators.add(decorator);
        return decorator;
    }

    public Scheduler customScheduler(SchedulerConfig config, int queueSize) {
        SimpleUnitTestSupportLifecycleSchedulerDecorator decorator = this.decorateScheduler(new SimpleUnitTestSupportScheduler(config.getMaxConcurrentTasks(), (ThreadFactory)new NamedThreadFactory(config.getSchedulerName() != null ? config.getSchedulerName() : "SimpleUnitTestSupportSchedulerService_custom"), new ThreadPoolExecutor.AbortPolicy()));
        this.decorators.add(decorator);
        return decorator;
    }

    protected SimpleUnitTestSupportLifecycleSchedulerDecorator decorateScheduler(SimpleUnitTestSupportScheduler scheduler) {
        SimpleUnitTestSupportLifecycleSchedulerDecorator spied = (SimpleUnitTestSupportLifecycleSchedulerDecorator)Mockito.spy((Object)new SimpleUnitTestSupportLifecycleSchedulerDecorator(this.resolveSchedulerCreationLocation(), scheduler, this));
        ((SimpleUnitTestSupportLifecycleSchedulerDecorator)Mockito.doReturn((Object)Mockito.mock(ScheduledFuture.class)).when((Object)spied)).scheduleWithCronExpression((Runnable)Matchers.any(), Matchers.anyString());
        ((SimpleUnitTestSupportLifecycleSchedulerDecorator)Mockito.doReturn((Object)Mockito.mock(ScheduledFuture.class)).when((Object)spied)).scheduleWithCronExpression((Runnable)Matchers.any(), Matchers.anyString(), (TimeZone)Matchers.any());
        return spied;
    }

    private String resolveSchedulerCreationLocation() {
        int i = 0;
        StackTraceElement[] stackTrace = new Throwable().getStackTrace();
        StackTraceElement ste = stackTrace[i++];
        while (this.skip(ste) && i < stackTrace.length) {
            ste = stackTrace[i++];
        }
        if (this.skip(ste)) {
            ste = stackTrace[3];
        }
        return ste.getClassName() + "." + ste.getMethodName() + ":" + ste.getLineNumber();
    }

    private boolean skip(StackTraceElement ste) {
        return ste.getClassName().startsWith(SimpleUnitTestSupportSchedulerService.class.getName()) || ste.getClassName().startsWith("org.mockito");
    }

    public void stop() throws MuleException {
        if (!this.scheduler.isShutdown()) {
            this.scheduler.shutdownNow();
        }
    }

    public List<Scheduler> getSchedulers() {
        return Collections.unmodifiableList(new ArrayList<Scheduler>(this.decorators));
    }

    public void clearCreatedSchedulers() {
        this.decorators.clear();
    }

    void stoppedScheduler(Scheduler scheduler) {
        this.decorators.remove(scheduler);
    }

    public int getScheduledTasks() {
        return this.scheduler.getScheduledTasks();
    }
}

