/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.components.tracing.override;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.nio.file.FileSystems;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.BiFunction;
import javax.inject.Inject;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.runtime.core.privileged.profiling.PrivilegedProfilingService;
import org.mule.runtime.tracer.api.sniffer.CapturedExportedSpan;
import org.mule.runtime.tracer.api.sniffer.ExportedSpanSniffer;
import org.mule.tck.probe.JUnitProbe;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;
import org.mule.test.components.tracing.OpenTelemetryTracingSnifferTestCase;
import org.mule.test.components.tracing.OpenTelemetryTracingTestRunnerConfigAnnotation;
import org.mule.test.infrastructure.profiling.tracing.SpanTestHierarchy;
import org.mule.test.infrastructure.profiling.tracing.TracingTestUtils;
import org.mule.test.runner.RunnerDelegateTo;

@Feature(value="Profiling")
@Story(value="Default Core Event Tracer")
@RunnerDelegateTo(value=Parameterized.class)
public class OverrideChoiceRouteErrorOpenTelemetryTracingTestCase
extends OpenTelemetryTracingSnifferTestCase
implements OpenTelemetryTracingTestRunnerConfigAnnotation {
    private static final int TIMEOUT_MILLIS = 30000;
    private static final int POLL_DELAY_MILLIS = 100;
    private static final String CONFIG_FILE = "tracing/choice-router.xml";
    private static final String OVERRIDE_FOLDER_NAME = "override/choice-route";
    private static final String FLOW_NAME = "choice-flow";
    private static final String EXPECTED_FLOW_SPAN_NAME = "mule:flow";
    private static final String EXPECTED_CHOICE_SPAN_NAME = "mule:choice";
    private static final String EXPECTED_ROUTE_SPAN_NAME = "mule:choice:route";
    private static final String EXPECTED_RAISE_ERROR_SPAN_NAME = "mule:raise-error";
    private static final String EXPECTED_ON_ERROR_PROPAGATE_SPAN_NAME = "mule:on-error-propagate";
    private static final String ANY_EXPECTED_ERROR_TYPE = "ANY:EXPECTED";
    private static final String UNKNOWN_LOCATION = "unknown";
    private static final String CHOICE_FLOW_LOCATION = "choice-flow";
    private static final String CHOICE_ROUTE_LOCATION = "choice-flow/processors/0";
    private static final String RAISE_ERROR_LOCATION = "choice-flow/processors/0/route/1/processors/0";
    private static final String TEST_ARTIFACT_ID = "OverrideChoiceRouteErrorOpenTelemetryTracingTestCase#testFlow";
    private final String tracingLevelConf;
    private final int expectedSpansCount;
    private final BiFunction<Collection<CapturedExportedSpan>, String, SpanTestHierarchy> spanHierarchyRetriever;
    @Inject
    PrivilegedProfilingService profilingService;

    @Parameterized.Parameters(name="TracingLevelConf: {0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({"overview-choice-route-debug", 4, OverrideChoiceRouteErrorOpenTelemetryTracingTestCase.getOverviewChoiceRouteDebugExpectedSpanTestHierarchy()}, {"overview-choice-route-monitoring", 4, OverrideChoiceRouteErrorOpenTelemetryTracingTestCase.getOverviewChoiceRouteMonitoringExpectedSpanTestHierarchy()}, {"monitoring-choice-route-debug", 5, OverrideChoiceRouteErrorOpenTelemetryTracingTestCase.getMonitoringChoiceRouteDebugExpectedSpanTestHierarchy()}, {"monitoring-choice-route-overview", 2, OverrideChoiceRouteErrorOpenTelemetryTracingTestCase.getMonitoringChoiceRouteOverviewExpectedSpanTestHierarchy()}, {"debug-choice-route-monitoring", 5, OverrideChoiceRouteErrorOpenTelemetryTracingTestCase.getDebugChoiceRouteMonitoringExpectedSpanTestHierarchy()}, {"debug-choice-route-overview", 2, OverrideChoiceRouteErrorOpenTelemetryTracingTestCase.getDebugChoiceRouteOverviewExpectedSpanTestHierarchy()});
    }

    public OverrideChoiceRouteErrorOpenTelemetryTracingTestCase(String tracingLevelConf, int expectedSpansCount, BiFunction<Collection<CapturedExportedSpan>, String, SpanTestHierarchy> spanHierarchyRetriever) {
        this.tracingLevelConf = tracingLevelConf;
        this.expectedSpansCount = expectedSpansCount;
        this.spanHierarchyRetriever = spanHierarchyRetriever;
    }

    protected String getConfigFile() {
        return CONFIG_FILE;
    }

    protected void doSetUpBeforeMuleContextCreation() throws Exception {
        String separator = FileSystems.getDefault().getSeparator();
        String tracingLevelConfigurationPath = String.format("%s%s%s%s", OVERRIDE_FOLDER_NAME, separator, this.tracingLevelConf, separator);
        System.setProperty("mule.tracing.level.configuration.path", tracingLevelConfigurationPath);
        super.doSetUpBeforeMuleContextCreation();
    }

    @After
    public void doAfter() {
        System.clearProperty("mule.tracing.level.configuration.path");
    }

    private static BiFunction<Collection<CapturedExportedSpan>, String, SpanTestHierarchy> getOverviewChoiceRouteDebugExpectedSpanTestHierarchy() {
        return (exportedSpans, artifactId) -> {
            List attributesToAssertExistence = TracingTestUtils.getDefaultAttributesToAssertExistence();
            SpanTestHierarchy expectedSpanHierarchy = new SpanTestHierarchy(exportedSpans);
            expectedSpanHierarchy.withRoot(EXPECTED_FLOW_SPAN_NAME).addExceptionData(ANY_EXPECTED_ERROR_TYPE).addAttributesToAssertValue(TracingTestUtils.createAttributeMap((String)"choice-flow", (String)artifactId)).addAttributesToAssertExistence(attributesToAssertExistence).beginChildren().child(EXPECTED_CHOICE_SPAN_NAME).addExceptionData(ANY_EXPECTED_ERROR_TYPE).addAttributesToAssertValue(TracingTestUtils.createAttributeMap((String)CHOICE_ROUTE_LOCATION, (String)artifactId)).addAttributesToAssertExistence(attributesToAssertExistence).beginChildren().child(EXPECTED_ROUTE_SPAN_NAME).addExceptionData(ANY_EXPECTED_ERROR_TYPE).addAttributesToAssertValue(TracingTestUtils.createAttributeMap((String)CHOICE_ROUTE_LOCATION, (String)artifactId)).addAttributesToAssertExistence(attributesToAssertExistence).beginChildren().child(EXPECTED_RAISE_ERROR_SPAN_NAME).addExceptionData(ANY_EXPECTED_ERROR_TYPE).addAttributesToAssertValue(TracingTestUtils.createAttributeMap((String)RAISE_ERROR_LOCATION, (String)artifactId)).addAttributesToAssertExistence(attributesToAssertExistence).endChildren().endChildren().endChildren();
            return expectedSpanHierarchy;
        };
    }

    private static BiFunction<Collection<CapturedExportedSpan>, String, SpanTestHierarchy> getOverviewChoiceRouteMonitoringExpectedSpanTestHierarchy() {
        return OverrideChoiceRouteErrorOpenTelemetryTracingTestCase.getOverviewChoiceRouteDebugExpectedSpanTestHierarchy();
    }

    private static BiFunction<Collection<CapturedExportedSpan>, String, SpanTestHierarchy> getMonitoringChoiceRouteDebugExpectedSpanTestHierarchy() {
        return (exportedSpans, artifactId) -> {
            List attributesToAssertExistence = TracingTestUtils.getDefaultAttributesToAssertExistence();
            SpanTestHierarchy expectedSpanHierarchy = new SpanTestHierarchy(exportedSpans);
            expectedSpanHierarchy.withRoot(EXPECTED_FLOW_SPAN_NAME).addExceptionData(ANY_EXPECTED_ERROR_TYPE).addAttributesToAssertValue(TracingTestUtils.createAttributeMap((String)"choice-flow", (String)artifactId)).addAttributesToAssertExistence(attributesToAssertExistence).beginChildren().child(EXPECTED_CHOICE_SPAN_NAME).addExceptionData(ANY_EXPECTED_ERROR_TYPE).addAttributesToAssertValue(TracingTestUtils.createAttributeMap((String)CHOICE_ROUTE_LOCATION, (String)artifactId)).addAttributesToAssertExistence(attributesToAssertExistence).beginChildren().child(EXPECTED_ROUTE_SPAN_NAME).addExceptionData(ANY_EXPECTED_ERROR_TYPE).addAttributesToAssertValue(TracingTestUtils.createAttributeMap((String)CHOICE_ROUTE_LOCATION, (String)artifactId)).addAttributesToAssertExistence(attributesToAssertExistence).beginChildren().child(EXPECTED_RAISE_ERROR_SPAN_NAME).addExceptionData(ANY_EXPECTED_ERROR_TYPE).addAttributesToAssertValue(TracingTestUtils.createAttributeMap((String)RAISE_ERROR_LOCATION, (String)artifactId)).addAttributesToAssertExistence(attributesToAssertExistence).endChildren().endChildren().child(EXPECTED_ON_ERROR_PROPAGATE_SPAN_NAME).addAttributesToAssertValue(TracingTestUtils.createAttributeMap((String)UNKNOWN_LOCATION, (String)artifactId)).addAttributesToAssertExistence(attributesToAssertExistence).endChildren();
            return expectedSpanHierarchy;
        };
    }

    private static BiFunction<Collection<CapturedExportedSpan>, String, SpanTestHierarchy> getMonitoringChoiceRouteOverviewExpectedSpanTestHierarchy() {
        return (exportedSpans, artifactId) -> {
            List attributesToAssertExistence = TracingTestUtils.getDefaultAttributesToAssertExistence();
            SpanTestHierarchy expectedSpanHierarchy = new SpanTestHierarchy(exportedSpans);
            expectedSpanHierarchy.withRoot(EXPECTED_FLOW_SPAN_NAME).addExceptionData(ANY_EXPECTED_ERROR_TYPE).addAttributesToAssertValue(TracingTestUtils.createAttributeMap((String)"choice-flow", (String)artifactId)).addAttributesToAssertExistence(attributesToAssertExistence).beginChildren().child(EXPECTED_ON_ERROR_PROPAGATE_SPAN_NAME).addAttributesToAssertValue(TracingTestUtils.createAttributeMap((String)UNKNOWN_LOCATION, (String)artifactId)).addAttributesToAssertExistence(attributesToAssertExistence).endChildren();
            return expectedSpanHierarchy;
        };
    }

    private static BiFunction<Collection<CapturedExportedSpan>, String, SpanTestHierarchy> getDebugChoiceRouteMonitoringExpectedSpanTestHierarchy() {
        return OverrideChoiceRouteErrorOpenTelemetryTracingTestCase.getMonitoringChoiceRouteDebugExpectedSpanTestHierarchy();
    }

    private static BiFunction<Collection<CapturedExportedSpan>, String, SpanTestHierarchy> getDebugChoiceRouteOverviewExpectedSpanTestHierarchy() {
        return OverrideChoiceRouteErrorOpenTelemetryTracingTestCase.getMonitoringChoiceRouteOverviewExpectedSpanTestHierarchy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFlow() throws Exception {
        final ExportedSpanSniffer spanCapturer = this.profilingService.getSpanExportManager().getExportedSpanSniffer();
        try {
            ((FlowRunner)this.flowRunner("choice-flow").withPayload((Object)EXPECTED_RAISE_ERROR_SPAN_NAME)).runExpectingException();
            PollingProber prober = new PollingProber(30000L, 100L);
            prober.check((Probe)new JUnitProbe(){

                protected boolean test() {
                    Collection exportedSpans = spanCapturer.getExportedSpans();
                    return exportedSpans.size() == OverrideChoiceRouteErrorOpenTelemetryTracingTestCase.this.expectedSpansCount;
                }

                public String describeFailure() {
                    return "The exact amount of spans was not captured.";
                }
            });
            Collection exportedSpans = spanCapturer.getExportedSpans();
            String artifactId = "OverrideChoiceRouteErrorOpenTelemetryTracingTestCase#testFlow[TracingLevelConf: " + this.tracingLevelConf + "]";
            this.spanHierarchyRetriever.apply(exportedSpans, artifactId).assertSpanTree();
            exportedSpans.forEach(span -> Assert.assertThat((Object)span.getServiceName(), (Matcher)Matchers.equalTo((Object)((String)span.getAttributes().get("artifact.id")))));
        }
        finally {
            spanCapturer.dispose();
        }
    }
}

