/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.components.tracing;

import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.server.AbstractHttpService;
import com.linecorp.armeria.server.HttpService;
import com.linecorp.armeria.server.ServerBuilder;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.testing.junit4.server.ServerRule;
import io.opentelemetry.proto.collector.trace.v1.ExportTraceServiceRequest;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileSystems;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.junit.After;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.runtime.tracer.api.sniffer.CapturedExportedSpan;
import org.mule.runtime.tracing.level.api.config.TracingLevel;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.tck.junit4.rule.SystemProperty;
import org.mule.tck.probe.JUnitProbe;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;
import org.mule.test.components.tracing.OpenTelemetryProtobufSpanUtils;
import org.mule.test.components.tracing.OpenTelemetryTracingTestCase;
import org.mule.test.components.tracing.OpenTelemetryTracingTestRunnerConfigAnnotation;
import org.mule.test.infrastructure.profiling.tracing.SpanTestHierarchy;
import org.mule.test.runner.RunnerDelegateTo;

@RunnerDelegateTo(value=Parameterized.class)
public class DistributedOpenTelemetryTracingTestCase
extends OpenTelemetryTracingTestCase
implements OpenTelemetryTracingTestRunnerConfigAnnotation {
    private final String traceLevel;
    private final int expectedSpansCount;
    private final Function<Collection<CapturedExportedSpan>, SpanTestHierarchy> spanHierarchyRetriever;
    @Rule
    public DynamicPort httpPort = new DynamicPort("port");
    @Rule
    public DynamicPort entryListenerPort = new DynamicPort("entryListenerPort");
    private static final String STARTING_FLOW = "startingFlow";
    private static final String EXPECTED_HTTP_REQUEST_SPAN_NAME = "GET";
    private static final String EXPECTED_HTTP_FLOW_SPAN_NAME = "GET /test";
    private static final String EXPECTED_LOGGER_SPAN_NAME = "mule:logger";
    public static final String EXPECTED_FLOW_SPAN_NAME = "mule:flow";
    public static final int TIMEOUT_MILLIS = 30000;
    private static final int POLL_DELAY_MILLIS = 100;
    public static final String MAX_BACKOFF_ATTEMPTS = "2";
    private final String type;
    private final String path;
    @Rule
    public SystemProperty openTelemetryExporterType = new SystemProperty("mule.openTelemetry.tracer.exporter.type", "HTTP");
    @Rule
    public SystemProperty openTelemetryExporterEndpoint = new SystemProperty("mule.openTelemetry.tracer.exporter.endpoint", "http://localhost:" + httpServer.httpPort() + "/");
    @Rule
    public SystemProperty openTelemetryMaxBackOffAttempts = new SystemProperty("mule.openTelemetry.tracer.exporter.backoff.maxAttempts", "2");
    @ClassRule
    public static final TestServerRule httpServer = new TestServerRule();

    protected String getConfigFile() {
        return "tracing/distributed-tracing.xml";
    }

    @Parameterized.Parameters(name="Transport: {0} - Tracing Level: {2}")
    public static Collection<Object[]> data() {
        return Arrays.asList({"HTTP", "", TracingLevel.OVERVIEW.name(), 3, DistributedOpenTelemetryTracingTestCase.getOverviewExpectedSpanTestHierarchy()}, {"HTTP", "", TracingLevel.MONITORING.name(), 4, DistributedOpenTelemetryTracingTestCase.getMonitoringExpectedSpanTestHierarchy()}, {"HTTP", "", TracingLevel.DEBUG.name(), 19, DistributedOpenTelemetryTracingTestCase.getDebugExpectedSpanTestHierarchy()});
    }

    private static Function<Collection<CapturedExportedSpan>, SpanTestHierarchy> getOverviewExpectedSpanTestHierarchy() {
        return exportedSpans -> {
            SpanTestHierarchy expectedSpanHierarchy = new SpanTestHierarchy(exportedSpans);
            expectedSpanHierarchy.withRoot(EXPECTED_FLOW_SPAN_NAME).beginChildren().child(EXPECTED_HTTP_REQUEST_SPAN_NAME).beginChildren().child(EXPECTED_HTTP_FLOW_SPAN_NAME).endChildren().endChildren();
            return expectedSpanHierarchy;
        };
    }

    private static Function<Collection<CapturedExportedSpan>, SpanTestHierarchy> getMonitoringExpectedSpanTestHierarchy() {
        return exportedSpans -> {
            SpanTestHierarchy expectedSpanHierarchy = new SpanTestHierarchy(exportedSpans);
            expectedSpanHierarchy.withRoot(EXPECTED_FLOW_SPAN_NAME).beginChildren().child(EXPECTED_HTTP_REQUEST_SPAN_NAME).beginChildren().child(EXPECTED_HTTP_FLOW_SPAN_NAME).beginChildren().child(EXPECTED_LOGGER_SPAN_NAME).endChildren().endChildren().endChildren();
            return expectedSpanHierarchy;
        };
    }

    private static Function<Collection<CapturedExportedSpan>, SpanTestHierarchy> getDebugExpectedSpanTestHierarchy() {
        return exportedSpans -> {
            SpanTestHierarchy expectedSpanHierarchy = new SpanTestHierarchy(exportedSpans);
            expectedSpanHierarchy.withRoot(EXPECTED_FLOW_SPAN_NAME).beginChildren().child(EXPECTED_HTTP_REQUEST_SPAN_NAME).beginChildren().child("mule:get-connection").child("mule:parameters-resolution").beginChildren().child("mule:value-resolution").child("mule:value-resolution").child("mule:value-resolution").child("mule:value-resolution").child("mule:value-resolution").child("mule:value-resolution").child("mule:value-resolution").child("mule:value-resolution").child("mule:value-resolution").child("mule:value-resolution").child("mule:value-resolution").child("mule:value-resolution").endChildren().child("mule:operation-execution").beginChildren().child(EXPECTED_HTTP_FLOW_SPAN_NAME).beginChildren().child(EXPECTED_LOGGER_SPAN_NAME).endChildren().endChildren().endChildren().endChildren();
            return expectedSpanHierarchy;
        };
    }

    protected void doSetUpBeforeMuleContextCreation() throws Exception {
        System.setProperty("mule.tracing.level.configuration.path", this.traceLevel.toLowerCase() + FileSystems.getDefault().getSeparator());
        super.doSetUpBeforeMuleContextCreation();
    }

    public DistributedOpenTelemetryTracingTestCase(String type, String path, String traceLevel, int expectedSpansCount, Function<Collection<CapturedExportedSpan>, SpanTestHierarchy> spanHierarchyRetriever) {
        this.type = type;
        this.path = path;
        this.traceLevel = traceLevel;
        this.expectedSpansCount = expectedSpansCount;
        this.spanHierarchyRetriever = spanHierarchyRetriever;
    }

    @After
    public void after() {
        System.clearProperty("mule.tracing.level.configuration.path");
        httpServer.reset();
    }

    @Test
    public void testDistributedTracing() throws Exception {
        this.flowRunner(STARTING_FLOW).run();
        PollingProber prober = new PollingProber(30000L, 100L);
        prober.check((Probe)new JUnitProbe(){

            protected boolean test() {
                List<CapturedExportedSpan> exportedSpans = httpServer.getCapturedExportedSpans();
                return exportedSpans.size() == DistributedOpenTelemetryTracingTestCase.this.expectedSpansCount;
            }

            public String describeFailure() {
                return "The exact amount of spans was not captured";
            }
        });
        this.spanHierarchyRetriever.apply(httpServer.getCapturedExportedSpans()).assertSpanTree();
    }

    private static final class TestServerRule
    extends ServerRule {
        public static final String PATH_PATTERN = "/";
        private final List<CapturedExportedSpan> capturedExportedSpans = new ArrayList<CapturedExportedSpan>();

        private TestServerRule() {
        }

        protected void configure(ServerBuilder sb) {
            sb.service(PATH_PATTERN, (HttpService)new AbstractHttpService(){

                @NotNull
                protected HttpResponse doPost(@NotNull ServiceRequestContext ctx, @NotNull HttpRequest req) {
                    return HttpResponse.from((CompletableFuture)req.aggregate().handle((aReq, cause) -> {
                        CompletableFuture<HttpResponse> responseFuture = new CompletableFuture<HttpResponse>();
                        HttpResponse res = HttpResponse.from(responseFuture);
                        try {
                            capturedExportedSpans.addAll(OpenTelemetryProtobufSpanUtils.getSpans(ExportTraceServiceRequest.parseFrom((InputStream)new ByteArrayInputStream(aReq.content().array()))));
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        responseFuture.complete(HttpResponse.of((HttpStatus)HttpStatus.OK));
                        return res;
                    }));
                }
            });
            sb.http(0);
        }

        public List<CapturedExportedSpan> getCapturedExportedSpans() {
            return this.capturedExportedSpans;
        }

        public void reset() {
            this.capturedExportedSpans.clear();
        }
    }
}

