/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.components.tracing;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.nio.file.FileSystems;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.BiFunction;
import javax.inject.Inject;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.runtime.core.privileged.profiling.PrivilegedProfilingService;
import org.mule.runtime.tracer.api.sniffer.CapturedExportedSpan;
import org.mule.runtime.tracer.api.sniffer.ExportedSpanSniffer;
import org.mule.runtime.tracing.level.api.config.TracingLevel;
import org.mule.tck.probe.JUnitProbe;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;
import org.mule.test.components.tracing.OpenTelemetryTracingSnifferTestCase;
import org.mule.test.components.tracing.OpenTelemetryTracingTestRunnerConfigAnnotation;
import org.mule.test.infrastructure.profiling.tracing.SpanTestHierarchy;
import org.mule.test.infrastructure.profiling.tracing.TracingTestUtils;
import org.mule.test.runner.RunnerDelegateTo;

@Feature(value="Profiling")
@Story(value="Default Core Event Tracer")
@RunnerDelegateTo(value=Parameterized.class)
public class ChoiceRouterOpenTelemetryTracingTestCase
extends OpenTelemetryTracingSnifferTestCase
implements OpenTelemetryTracingTestRunnerConfigAnnotation {
    private static final int TIMEOUT_MILLIS = 30000;
    private static final int POLL_DELAY_MILLIS = 100;
    public static final String EXPECTED_ROUTE_SPAN_NAME = "mule:choice:route";
    public static final String EXPECTED_CHOICE_SPAN_NAME = "mule:choice";
    public static final String EXPECTED_LOGGER_SPAN_NAME = "mule:logger";
    public static final String EXPECTED_SET_PAYLOAD_SPAN_NAME = "mule:set-payload";
    public static final String EXPECTED_RAISE_ERROR_SPAN_NAME = "mule:raise-error";
    public static final String CHOICE_FLOW = "choice-flow";
    public static final String EXPECTED_FLOW_SPAN_NAME = "mule:flow";
    public static final String NO_PARENT_SPAN = "0000000000000000";
    public static final String EXPECTED_ON_ERROR_PROPAGATE_SPAN_NAME = "mule:on-error-propagate";
    public static final String TEST_ARTIFACT_ID = "ChoiceRouterOpenTelemetryTracingTestCase#testChoiceFlow";
    private final String tracingLevel;
    private final int expectedSuccessSpansCount;
    private final BiFunction<Collection<CapturedExportedSpan>, SpanTestHierarchyParameters, SpanTestHierarchy> spanHierarchyRetriever;
    private final int expectedErrorSpansCount;
    @Inject
    PrivilegedProfilingService profilingService;

    @Parameterized.Parameters(name="tracingLevel: {0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({TracingLevel.OVERVIEW.name(), 1, 1, ChoiceRouterOpenTelemetryTracingTestCase.getOverviewExpectedSpanTestHierarchy()}, {TracingLevel.MONITORING.name(), 4, 5, ChoiceRouterOpenTelemetryTracingTestCase.getMonitoringExpectedSpanTestHierarchy()}, {TracingLevel.DEBUG.name(), 4, 5, ChoiceRouterOpenTelemetryTracingTestCase.getDebugExpectedSpanTestHierarchy()});
    }

    private static BiFunction<Collection<CapturedExportedSpan>, SpanTestHierarchyParameters, SpanTestHierarchy> getOverviewExpectedSpanTestHierarchy() {
        return (exportedSpans, spanTestHierarchyParameters) -> {
            SpanTestHierarchy expectedSpanHierarchy = new SpanTestHierarchy(exportedSpans);
            expectedSpanHierarchy.withRoot(EXPECTED_FLOW_SPAN_NAME);
            if (spanTestHierarchyParameters.isError()) {
                expectedSpanHierarchy = expectedSpanHierarchy.addExceptionData("ANY:EXPECTED");
            }
            return expectedSpanHierarchy;
        };
    }

    private static BiFunction<Collection<CapturedExportedSpan>, SpanTestHierarchyParameters, SpanTestHierarchy> getMonitoringExpectedSpanTestHierarchy() {
        return (exportedSpans, spanTestHierarchyParameters) -> {
            List attributesToAssertExistence = TracingTestUtils.getDefaultAttributesToAssertExistence();
            SpanTestHierarchy expectedSpanHierarchy = new SpanTestHierarchy(exportedSpans);
            expectedSpanHierarchy = expectedSpanHierarchy.withRoot(EXPECTED_FLOW_SPAN_NAME).addAttributesToAssertValue(TracingTestUtils.createAttributeMap((String)CHOICE_FLOW, (String)spanTestHierarchyParameters.getArtifactId())).addAttributesToAssertExistence(attributesToAssertExistence);
            if (spanTestHierarchyParameters.isError()) {
                expectedSpanHierarchy = expectedSpanHierarchy.addExceptionData("ANY:EXPECTED");
            }
            expectedSpanHierarchy = expectedSpanHierarchy.beginChildren().child(EXPECTED_CHOICE_SPAN_NAME);
            if (spanTestHierarchyParameters.isError()) {
                expectedSpanHierarchy = expectedSpanHierarchy.addExceptionData("ANY:EXPECTED");
            }
            expectedSpanHierarchy = expectedSpanHierarchy.addAttributesToAssertValue(TracingTestUtils.createAttributeMap((String)"choice-flow/processors/0", (String)spanTestHierarchyParameters.getArtifactId())).addAttributesToAssertExistence(attributesToAssertExistence).beginChildren().child(EXPECTED_ROUTE_SPAN_NAME);
            if (spanTestHierarchyParameters.isError()) {
                expectedSpanHierarchy = expectedSpanHierarchy.addExceptionData("ANY:EXPECTED");
            }
            expectedSpanHierarchy = expectedSpanHierarchy.addAttributesToAssertValue(TracingTestUtils.createAttributeMap((String)"choice-flow/processors/0", (String)spanTestHierarchyParameters.getArtifactId())).addAttributesToAssertExistence(attributesToAssertExistence).beginChildren().child(spanTestHierarchyParameters.getChildSpanName());
            if (spanTestHierarchyParameters.isError()) {
                expectedSpanHierarchy = expectedSpanHierarchy.addExceptionData("ANY:EXPECTED");
            }
            expectedSpanHierarchy = expectedSpanHierarchy.endChildren().endChildren();
            if (spanTestHierarchyParameters.isError()) {
                expectedSpanHierarchy.child(EXPECTED_ON_ERROR_PROPAGATE_SPAN_NAME).addAttributesToAssertValue(TracingTestUtils.createAttributeMap((String)"unknown", (String)spanTestHierarchyParameters.getArtifactId())).addAttributesToAssertExistence(attributesToAssertExistence);
            }
            expectedSpanHierarchy.endChildren();
            return expectedSpanHierarchy;
        };
    }

    private static BiFunction<Collection<CapturedExportedSpan>, SpanTestHierarchyParameters, SpanTestHierarchy> getDebugExpectedSpanTestHierarchy() {
        return ChoiceRouterOpenTelemetryTracingTestCase.getMonitoringExpectedSpanTestHierarchy();
    }

    public ChoiceRouterOpenTelemetryTracingTestCase(String tracingLevel, int expectedSuccessSpansCount, int expectedErrorSpansCount, BiFunction<Collection<CapturedExportedSpan>, SpanTestHierarchyParameters, SpanTestHierarchy> spanHierarchyRetriever) {
        this.tracingLevel = tracingLevel;
        this.expectedSuccessSpansCount = expectedSuccessSpansCount;
        this.expectedErrorSpansCount = expectedErrorSpansCount;
        this.spanHierarchyRetriever = spanHierarchyRetriever;
    }

    protected void doSetUpBeforeMuleContextCreation() throws Exception {
        System.setProperty("mule.tracing.level.configuration.path", this.tracingLevel.toLowerCase() + FileSystems.getDefault().getSeparator());
        super.doSetUpBeforeMuleContextCreation();
    }

    @After
    public void doAfter() {
        System.clearProperty("mule.tracing.level.configuration.path");
    }

    protected String getConfigFile() {
        return "tracing/choice-router.xml";
    }

    @Test
    public void testChoiceFlow() throws Exception {
        this.testForRoute(EXPECTED_LOGGER_SPAN_NAME, false);
        this.testForRoute(EXPECTED_SET_PAYLOAD_SPAN_NAME, false);
        this.testForRoute(EXPECTED_RAISE_ERROR_SPAN_NAME, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testForRoute(String childExpectedSpan, final boolean isError) throws Exception {
        final ExportedSpanSniffer spanCapturer = this.profilingService.getSpanExportManager().getExportedSpanSniffer();
        try {
            if (isError) {
                ((FlowRunner)this.flowRunner(CHOICE_FLOW).withPayload((Object)childExpectedSpan)).runExpectingException();
            } else {
                ((FlowRunner)this.flowRunner(CHOICE_FLOW).withPayload((Object)childExpectedSpan)).run().getMessage();
            }
            PollingProber prober = new PollingProber(30000L, 100L);
            prober.check((Probe)new JUnitProbe(){

                protected boolean test() {
                    Collection exportedSpans = spanCapturer.getExportedSpans();
                    if (isError) {
                        return exportedSpans.size() == ChoiceRouterOpenTelemetryTracingTestCase.this.expectedErrorSpansCount;
                    }
                    return exportedSpans.size() == ChoiceRouterOpenTelemetryTracingTestCase.this.expectedSuccessSpansCount;
                }

                public String describeFailure() {
                    return "The exact amount of spans was not captured";
                }
            });
            String artifactId = "ChoiceRouterOpenTelemetryTracingTestCase#testChoiceFlow[tracingLevel: " + this.tracingLevel + "]";
            Collection exportedSpans = spanCapturer.getExportedSpans();
            this.spanHierarchyRetriever.apply(exportedSpans, new SpanTestHierarchyParameters(artifactId, childExpectedSpan, isError)).assertSpanTree();
            exportedSpans.forEach(span -> Assert.assertThat((Object)span.getServiceName(), (Matcher)Matchers.equalTo((Object)((String)span.getAttributes().get("artifact.id")))));
        }
        finally {
            spanCapturer.dispose();
        }
    }

    private static final class SpanTestHierarchyParameters {
        private final String artifactId;
        private final String childSpan;
        private final boolean isError;

        private SpanTestHierarchyParameters(String artifactId, String childSpan, boolean isError) {
            this.artifactId = artifactId;
            this.childSpan = childSpan;
            this.isError = isError;
        }

        public String getArtifactId() {
            return this.artifactId;
        }

        public String getChildSpanName() {
            return this.childSpan;
        }

        public boolean isError() {
            return this.isError;
        }
    }
}

