/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.components.tracing;

import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.trace.data.SpanData;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.JavaVersion;
import org.apache.commons.lang3.SystemUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.runtime.api.config.custom.ServiceConfigurator;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.ConfigurationBuilder;
import org.mule.runtime.tracer.exporter.impl.OpenTelemetrySpanExporterFactory;
import org.mule.tck.junit4.rule.SystemProperty;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;
import org.mule.test.components.tracing.OpenTelemetryTracingTestCase;
import org.mule.test.components.tracing.OpenTelemetryTracingTestRunnerConfigAnnotation;

public class OpenTelemetrySpanDropTestCase
extends OpenTelemetryTracingTestCase
implements OpenTelemetryTracingTestRunnerConfigAnnotation {
    private static final BlockingSpanExporter BLOCKING_SPAN_EXPORTER = new BlockingSpanExporter();
    @Rule
    public SystemProperty batchQueueSize = new SystemProperty("mule.openTelemetry.tracer.exporter.batch.queueSize", "2");
    @Rule
    public SystemProperty batchProcessorTimeout = new SystemProperty("mule.openTelemetry.tracer.exporter.timeout", "500");
    @Rule
    public SystemProperty exportMetricsFrequency = new SystemProperty("mule.openTelemetry.tracer.exporter.metricsLogFrequency", "500");
    private static final SystemOutRecorder logRecorder = new SystemOutRecorder();

    @Before
    public void initialize() {
        logRecorder.startRecording();
    }

    @After
    public void dispose() {
        logRecorder.stopRecording();
    }

    protected String getConfigFile() {
        return "tracing/span-drop.xml";
    }

    @Test
    public void testWhenSpanGetsDroppedThenWarningLogInformsIt() throws Exception {
        Assume.assumeThat((Object)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_11), (Matcher)CoreMatchers.is((Object)true));
        ((FlowRunner)this.flowRunner("drops-one-span").withPayload((Object)"test")).run();
        BLOCKING_SPAN_EXPORTER.waitUntilIsBlocked();
        ((FlowRunner)this.flowRunner("drops-one-span").withPayload((Object)"test")).run();
        ((FlowRunner)this.flowRunner("drops-one-span").withPayload((Object)"test")).run();
        new PollingProber(5000L, 100L).check(new Probe(){

            public boolean isSatisfied() {
                try {
                    String recordedLogs = logRecorder.getLogs(StandardCharsets.UTF_8);
                    return recordedLogs.contains("Total spans dropped since the export started: 2") || recordedLogs.contains("Total spans dropped since the export started: 3");
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }

            public String describeFailure() {
                return "Expected span drop did not happen";
            }
        });
    }

    protected void addBuilders(List<ConfigurationBuilder> builders) {
        super.addBuilders(builders);
        builders.add(this.getCustomSpanExporterFactoryBuilder());
    }

    private ConfigurationBuilder getCustomSpanExporterFactoryBuilder() {
        return new ConfigurationBuilder(){

            public void addServiceConfigurator(ServiceConfigurator serviceConfigurator) {
            }

            public void configure(MuleContext muleContext) {
                muleContext.getCustomizationService().overrideDefaultServiceClass("_muleCoreExporterFactory", BlockingSpanExporterFactory.class);
            }
        };
    }

    private static class SystemOutRecorder
    extends PrintStream {
        private final PrintStream systemOut;
        private boolean recording = false;

        private SystemOutRecorder() {
            super(new ByteArrayOutputStream());
            if (System.out instanceof SystemOutRecorder) {
                throw new IllegalStateException("Multiple recorder instances are not supported");
            }
            this.systemOut = System.out;
            System.setOut(this);
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.systemOut.write(b);
            if (this.recording) {
                super.write(b);
            }
        }

        @Override
        public void write(byte[] b, int off, int len) {
            this.systemOut.write(b, off, len);
            if (this.recording) {
                super.write(b, off, len);
            }
        }

        @Override
        public void write(int b) {
            this.systemOut.write(b);
            if (this.recording) {
                super.write(b);
            }
        }

        @Override
        public void flush() {
            this.systemOut.flush();
        }

        @Override
        public void close() {
        }

        public void startRecording() {
            if (this.recording) {
                throw new IllegalStateException("Recording already in progress!");
            }
            System.setOut(this);
            this.recording = true;
        }

        public void stopRecording() {
            if (!this.recording) {
                throw new IllegalStateException("Recording not in progress!");
            }
            System.setOut(this.systemOut);
            this.recording = false;
        }

        public boolean isRecording() {
            return this.recording;
        }

        public void clearRecord() throws IOException {
            this.out = new ByteArrayOutputStream();
        }

        public String getLogs(Charset charset) throws UnsupportedEncodingException {
            return ((ByteArrayOutputStream)this.out).toString(charset.name());
        }
    }

    private static final class BlockingSpanExporter
    implements SpanExporter {
        final Object monitor = new Object();
        State state = State.WAIT_TO_BLOCK;

        private BlockingSpanExporter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CompletableResultCode export(Collection<SpanData> spanDataList) {
            Object object = this.monitor;
            synchronized (object) {
                while (this.state != State.UNBLOCKED) {
                    try {
                        this.state = State.BLOCKED;
                        this.monitor.notifyAll();
                        this.monitor.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            return CompletableResultCode.ofSuccess();
        }

        public CompletableResultCode flush() {
            return CompletableResultCode.ofSuccess();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void waitUntilIsBlocked() {
            Object object = this.monitor;
            synchronized (object) {
                while (this.state != State.BLOCKED) {
                    try {
                        this.monitor.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }

        public CompletableResultCode shutdown() {
            return CompletableResultCode.ofSuccess();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void unblock() {
            Object object = this.monitor;
            synchronized (object) {
                this.state = State.UNBLOCKED;
                this.monitor.notifyAll();
            }
        }

        private static enum State {
            WAIT_TO_BLOCK,
            BLOCKED,
            UNBLOCKED;

        }
    }

    private static class BlockingSpanExporterFactory
    extends OpenTelemetrySpanExporterFactory {
        private BlockingSpanExporterFactory() {
        }

        protected SpanExporter resolveOpenTelemetrySpanExporter() {
            return BLOCKING_SPAN_EXPORTER;
        }
    }
}

