/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.components.tracing;

import com.google.protobuf.InvalidProtocolBufferException;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.server.AbstractHttpService;
import com.linecorp.armeria.server.HttpService;
import com.linecorp.armeria.server.ServerBuilder;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.grpc.protocol.AbstractUnaryGrpcService;
import com.linecorp.armeria.testing.junit4.server.SelfSignedCertificateRule;
import com.linecorp.armeria.testing.junit4.server.ServerRule;
import io.opentelemetry.proto.collector.trace.v1.ExportTraceServiceRequest;
import io.opentelemetry.proto.collector.trace.v1.ExportTraceServiceResponse;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.jetbrains.annotations.NotNull;
import org.junit.After;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.runners.Parameterized;
import org.mule.runtime.tracer.api.sniffer.CapturedExportedSpan;
import org.mule.test.components.tracing.OpenTelemetryProtobufSpanUtils;
import org.mule.test.components.tracing.OpenTelemetryTracingTestCase;
import org.mule.test.components.tracing.OpenTelemetryTracingTestRunnerConfigAnnotation;
import org.mule.test.runner.RunnerDelegateTo;

@RunnerDelegateTo(value=Parameterized.class)
public abstract class AbstractFullOpenTelemetryTracingTestCase
extends OpenTelemetryTracingTestCase
implements OpenTelemetryTracingTestRunnerConfigAnnotation {
    public static final String HTTP_TRACES_PATH = "/v1/traces";
    protected final String exporterType;
    protected final String path;
    protected final boolean secure;
    @ClassRule
    public static SelfSignedCertificateRule serverTls = new SelfSignedCertificateRule();
    @ClassRule
    public static SelfSignedCertificateRule clientTls = new SelfSignedCertificateRule();
    @Rule
    public final TestGrpcServerRule server = new TestGrpcServerRule();

    @Parameterized.Parameters(name="type: {0} - path: {1} - secure: {2}")
    public static Collection<Object[]> data() {
        return Arrays.asList({"GRPC", "", false}, {"HTTP", HTTP_TRACES_PATH, false}, {"GRPC", "", true}, {"HTTP", HTTP_TRACES_PATH, true});
    }

    public AbstractFullOpenTelemetryTracingTestCase(String exporterType, String path, boolean secure) {
        this.exporterType = exporterType;
        this.path = path;
        this.secure = secure;
    }

    protected void doSetUpBeforeMuleContextCreation() {
        System.setProperty("mule.openTelemetry.tracer.exporter.enabled", Boolean.TRUE.toString());
        System.setProperty("mule.openTelemetry.tracer.exporter.type", this.exporterType);
        System.setProperty("mule.openTelemetry.tracer.exporter.endpoint", "http://localhost:" + this.server.httpPort() + this.path);
        System.setProperty("mule.openTelemetry.tracer.exporter.tls.enabled", Boolean.toString(this.secure));
        if (this.secure) {
            System.setProperty("mule.openTelemetry.tracer.exporter.tls.keyFileLocation", clientTls.privateKeyFile().toPath().toString());
            System.setProperty("mule.openTelemetry.tracer.exportertls.certFileLocation", clientTls.certificateFile().toPath().toString());
            System.setProperty("mule.openTelemetry.tracer.exporter.tls.caFileLocation", serverTls.certificateFile().toPath().toString());
        }
    }

    @After
    public void after() {
        this.server.reset();
        System.clearProperty("mule.openTelemetry.tracer.exporter.enabled");
        System.clearProperty("mule.openTelemetry.tracer.exporter.type");
        System.clearProperty("mule.openTelemetry.tracer.exporter.endpoint");
        System.clearProperty("mule.openTelemetry.tracer.exporter.tls.enabled");
        System.clearProperty("mule.openTelemetry.tracer.exporter.tls.keyFileLocation");
        System.clearProperty("mule.openTelemetry.tracer.exportertls.certFileLocation");
        System.clearProperty("mule.openTelemetry.tracer.exporter.tls.caFileLocation");
    }

    protected List<CapturedExportedSpan> getSpans() {
        return this.server.getSpans();
    }

    private static final class TestGrpcServerRule
    extends ServerRule {
        public static final String PATH_PATTERN = "/opentelemetry.proto.collector.trace.v1.TraceService/Export";
        private final List<CapturedExportedSpan> capturedExportedSpans = new ArrayList<CapturedExportedSpan>();

        private TestGrpcServerRule() {
        }

        protected void configure(ServerBuilder sb) {
            sb.service(PATH_PATTERN, (HttpService)new AbstractUnaryGrpcService(){

                @NotNull
                protected CompletionStage<byte[]> handleMessage(@NotNull ServiceRequestContext ctx, byte @NotNull [] message) {
                    try {
                        OpenTelemetryProtobufSpanUtils.verifyResourceAndScopeGrouping(ExportTraceServiceRequest.parseFrom((byte[])message));
                        capturedExportedSpans.addAll(OpenTelemetryProtobufSpanUtils.getSpans(ExportTraceServiceRequest.parseFrom((byte[])message)));
                    }
                    catch (InvalidProtocolBufferException e) {
                        throw new UncheckedIOException((IOException)((Object)e));
                    }
                    return CompletableFuture.completedFuture(ExportTraceServiceResponse.getDefaultInstance().toByteArray());
                }
            });
            sb.service(AbstractFullOpenTelemetryTracingTestCase.HTTP_TRACES_PATH, (HttpService)new AbstractHttpService(){

                protected HttpResponse doPost(ServiceRequestContext ctx, HttpRequest req) {
                    return HttpResponse.from((CompletionStage)req.aggregate().handle((aReq, cause) -> {
                        CompletableFuture<HttpResponse> responseFuture = new CompletableFuture<HttpResponse>();
                        HttpResponse res = HttpResponse.from(responseFuture);
                        try {
                            capturedExportedSpans.addAll(OpenTelemetryProtobufSpanUtils.getSpans(ExportTraceServiceRequest.parseFrom((byte[])aReq.content().array())));
                        }
                        catch (InvalidProtocolBufferException e) {
                            throw new UncheckedIOException((IOException)((Object)e));
                        }
                        responseFuture.complete(HttpResponse.of((HttpStatus)HttpStatus.OK));
                        return res;
                    }));
                }
            });
            sb.http(0);
        }

        public void reset() {
            this.capturedExportedSpans.clear();
        }

        public List<CapturedExportedSpan> getSpans() {
            return this.capturedExportedSpans;
        }
    }
}

