/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.components.tracing.override;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.nio.file.FileSystems;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.BiFunction;
import javax.inject.Inject;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.runtime.core.privileged.profiling.PrivilegedProfilingService;
import org.mule.runtime.tracer.api.sniffer.CapturedExportedSpan;
import org.mule.runtime.tracer.api.sniffer.ExportedSpanSniffer;
import org.mule.tck.probe.JUnitProbe;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;
import org.mule.test.components.tracing.OpenTelemetryTracingSnifferTestCase;
import org.mule.test.components.tracing.OpenTelemetryTracingTestRunnerConfigAnnotation;
import org.mule.test.infrastructure.profiling.tracing.SpanTestHierarchy;
import org.mule.test.infrastructure.profiling.tracing.TracingTestUtils;
import org.mule.test.runner.RunnerDelegateTo;

@Feature(value="Profiling")
@Story(value="Default Core Event Tracer")
@RunnerDelegateTo(value=Parameterized.class)
public class OverrideTryScopeSuccessOpenTelemetryTracingTestCase
extends OpenTelemetryTracingSnifferTestCase
implements OpenTelemetryTracingTestRunnerConfigAnnotation {
    private static final int TIMEOUT_MILLIS = 30000;
    private static final int POLL_DELAY_MILLIS = 100;
    private static final String FLOW_NAME = "try-scope-flow";
    private static final String CONFIG_FILE = "tracing/try-scope-successful.xml";
    private static final String OVERRIDE_FOLDER_NAME = "override/try-scope";
    private static final String EXPECTED_FLOW_SPAN_NAME = "mule:flow";
    private static final String EXPECTED_TRY_SCOPE_SPAN_NAME = "mule:try";
    private static final String EXPECTED_LOGGER_SPAN_NAME = "mule:logger";
    private static final String FLOW_LOCATION = "try-scope-flow";
    private static final String TRY_SCOPE_LOCATION = "try-scope-flow/processors/0";
    private static final String LOGGER_LOCATION = "try-scope-flow/processors/0/processors/0";
    private static final String TEST_ARTIFACT_ID = "OverrideTryScopeSuccessOpenTelemetryTracingTestCase#testFlow";
    private final String tracingLevelConf;
    private final int expectedSpansCount;
    private final BiFunction<Collection<CapturedExportedSpan>, String, SpanTestHierarchy> spanHierarchyRetriever;
    @Inject
    PrivilegedProfilingService profilingService;

    @Parameterized.Parameters(name="TracingLevelConf: {0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({"overview-try-scope-debug", 3, OverrideTryScopeSuccessOpenTelemetryTracingTestCase.getOverviewTryScopeDebugExpectedSpanTestHierarchy()}, {"overview-try-scope-monitoring", 3, OverrideTryScopeSuccessOpenTelemetryTracingTestCase.getOverviewTryScopeMonitoringExpectedSpanTestHierarchy()}, {"monitoring-try-scope-debug", 3, OverrideTryScopeSuccessOpenTelemetryTracingTestCase.getMonitoringTryScopeDebugExpectedSpanTestHierarchy()}, {"monitoring-try-scope-overview", 1, OverrideTryScopeSuccessOpenTelemetryTracingTestCase.getMonitoringTryScopeOverviewExpectedSpanTestHierarchy()}, {"debug-try-scope-monitoring", 3, OverrideTryScopeSuccessOpenTelemetryTracingTestCase.getDebugTryScopeMonitoringExpectedSpanTestHierarchy()}, {"debug-try-scope-overview", 1, OverrideTryScopeSuccessOpenTelemetryTracingTestCase.getDebugTryScopeOverviewExpectedSpanTestHierarchy()});
    }

    public OverrideTryScopeSuccessOpenTelemetryTracingTestCase(String tracingLevelConf, int expectedSpansCount, BiFunction<Collection<CapturedExportedSpan>, String, SpanTestHierarchy> spanHierarchyRetriever) {
        this.tracingLevelConf = tracingLevelConf;
        this.expectedSpansCount = expectedSpansCount;
        this.spanHierarchyRetriever = spanHierarchyRetriever;
    }

    protected String getConfigFile() {
        return CONFIG_FILE;
    }

    protected void doSetUpBeforeMuleContextCreation() throws Exception {
        String separator = FileSystems.getDefault().getSeparator();
        String tracingLevelConfigurationPath = String.format("%s%s%s%s", OVERRIDE_FOLDER_NAME, separator, this.tracingLevelConf, separator);
        System.setProperty("mule.tracing.level.configuration.path", tracingLevelConfigurationPath);
        super.doSetUpBeforeMuleContextCreation();
    }

    @After
    public void doAfter() {
        System.clearProperty("mule.tracing.level.configuration.path");
    }

    private static BiFunction<Collection<CapturedExportedSpan>, String, SpanTestHierarchy> getOverviewTryScopeDebugExpectedSpanTestHierarchy() {
        return (exportedSpans, artifactId) -> {
            List attributesToAssertExistence = TracingTestUtils.getDefaultAttributesToAssertExistence();
            SpanTestHierarchy expectedSpanHierarchy = new SpanTestHierarchy(exportedSpans);
            expectedSpanHierarchy.withRoot(EXPECTED_FLOW_SPAN_NAME).addAttributesToAssertValue(TracingTestUtils.createAttributeMap((String)"try-scope-flow", (String)TEST_ARTIFACT_ID)).addAttributesToAssertExistence(attributesToAssertExistence).beginChildren().child(EXPECTED_TRY_SCOPE_SPAN_NAME).addAttributesToAssertValue(TracingTestUtils.createAttributeMap((String)TRY_SCOPE_LOCATION, (String)TEST_ARTIFACT_ID)).addAttributesToAssertExistence(attributesToAssertExistence).beginChildren().child(EXPECTED_LOGGER_SPAN_NAME).addAttributesToAssertValue(TracingTestUtils.createAttributeMap((String)LOGGER_LOCATION, (String)TEST_ARTIFACT_ID)).addAttributesToAssertExistence(attributesToAssertExistence).endChildren().endChildren();
            return expectedSpanHierarchy;
        };
    }

    private static BiFunction<Collection<CapturedExportedSpan>, String, SpanTestHierarchy> getOverviewTryScopeMonitoringExpectedSpanTestHierarchy() {
        return OverrideTryScopeSuccessOpenTelemetryTracingTestCase.getOverviewTryScopeDebugExpectedSpanTestHierarchy();
    }

    private static BiFunction<Collection<CapturedExportedSpan>, String, SpanTestHierarchy> getMonitoringTryScopeDebugExpectedSpanTestHierarchy() {
        return OverrideTryScopeSuccessOpenTelemetryTracingTestCase.getOverviewTryScopeDebugExpectedSpanTestHierarchy();
    }

    private static BiFunction<Collection<CapturedExportedSpan>, String, SpanTestHierarchy> getMonitoringTryScopeOverviewExpectedSpanTestHierarchy() {
        return (exportedSpans, artifactId) -> {
            List attributesToAssertExistence = TracingTestUtils.getDefaultAttributesToAssertExistence();
            SpanTestHierarchy expectedSpanHierarchy = new SpanTestHierarchy(exportedSpans);
            expectedSpanHierarchy.withRoot(EXPECTED_FLOW_SPAN_NAME).addAttributesToAssertValue(TracingTestUtils.createAttributeMap((String)"try-scope-flow", (String)TEST_ARTIFACT_ID)).addAttributesToAssertExistence(attributesToAssertExistence);
            return expectedSpanHierarchy;
        };
    }

    private static BiFunction<Collection<CapturedExportedSpan>, String, SpanTestHierarchy> getDebugTryScopeMonitoringExpectedSpanTestHierarchy() {
        return OverrideTryScopeSuccessOpenTelemetryTracingTestCase.getOverviewTryScopeDebugExpectedSpanTestHierarchy();
    }

    private static BiFunction<Collection<CapturedExportedSpan>, String, SpanTestHierarchy> getDebugTryScopeOverviewExpectedSpanTestHierarchy() {
        return OverrideTryScopeSuccessOpenTelemetryTracingTestCase.getMonitoringTryScopeOverviewExpectedSpanTestHierarchy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFlow() throws Exception {
        final ExportedSpanSniffer spanCapturer = this.profilingService.getSpanExportManager().getExportedSpanSniffer();
        try {
            ((FlowRunner)this.flowRunner("try-scope-flow").withPayload((Object)"test")).run().getMessage();
            PollingProber prober = new PollingProber(30000L, 100L);
            prober.check((Probe)new JUnitProbe(){

                protected boolean test() {
                    Collection exportedSpans = spanCapturer.getExportedSpans();
                    return exportedSpans.size() == OverrideTryScopeSuccessOpenTelemetryTracingTestCase.this.expectedSpansCount;
                }

                public String describeFailure() {
                    return "The exact amount of spans was not captured.";
                }
            });
            Collection exportedSpans = spanCapturer.getExportedSpans();
            this.spanHierarchyRetriever.apply(exportedSpans, "[TracingLevelConf: " + this.tracingLevelConf + "]");
            exportedSpans.forEach(span -> Assert.assertThat((Object)span.getServiceName(), (Matcher)Matchers.equalTo((Object)((String)span.getAttributes().get("artifact.id")))));
        }
        finally {
            spanCapturer.dispose();
        }
    }
}

