/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.components.tracing;

import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.trace.data.SpanData;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import javax.inject.Inject;
import org.apache.commons.lang3.JavaVersion;
import org.apache.commons.lang3.SystemUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assume;
import org.junit.Rule;
import org.junit.Test;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.functional.junit4.MuleArtifactFunctionalTestCase;
import org.mule.runtime.api.config.custom.ServiceConfigurator;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.ConfigurationBuilder;
import org.mule.runtime.tracer.exporter.config.api.SpanExporterConfiguration;
import org.mule.runtime.tracer.exporter.impl.OpenTelemetrySpanExporterFactory;
import org.mule.tck.junit4.rule.SystemProperty;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;
import org.mule.test.components.tracing.OpenTelemetryTracingTestRunnerConfigAnnotation;

@Feature(value="Profiling")
@Story(value="Open Telemetry Exporter")
public class OpenTelemetryGracefulShutdownTestCase
extends MuleArtifactFunctionalTestCase
implements OpenTelemetryTracingTestRunnerConfigAnnotation {
    @Inject
    MuleContext muleContext;
    private static final CountingSpanExporter COUNTING_SPAN_EXPORTER = new CountingSpanExporter();
    public static final String EXPORTER_SCHEDULED_DELAY = "60000";
    @Rule
    public SystemProperty enableTracingExport = new SystemProperty("mule.openTelemetry.tracer.exporter.enabled", "true");
    @Rule
    public SystemProperty disableSampling = new SystemProperty("mule.openTelemetry.tracer.exporter.sampler", "always_on");
    @Rule
    public SystemProperty maxBatchSize = new SystemProperty("mule.openTelemetry.tracer.exporter.batch.maxSize", "512");
    @Rule
    public SystemProperty batchQueueSize = new SystemProperty("mule.openTelemetry.tracer.exporter.batch.queueSize", "3");
    private static final SpanExporterConfiguration privilegedConfiguration = key -> {
        if (key.equals("mule.openTelemetry.tracer.exporter.batch.scheduledDelay")) {
            return EXPORTER_SCHEDULED_DELAY;
        }
        return null;
    };

    protected boolean doTestClassInjection() {
        return true;
    }

    protected boolean isGracefulShutdown() {
        return true;
    }

    protected String getConfigFile() {
        return "tracing/span-drop.xml";
    }

    @Test
    public void testShutdownFlushesExportQueue() throws Exception {
        Assume.assumeThat((Object)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_11), (Matcher)CoreMatchers.is((Object)true));
        ((FlowRunner)this.flowRunner("drops-one-span").withPayload((Object)"test")).run();
        this.muleContext.dispose();
        new PollingProber(10000L, 100L).check(new Probe(){

            public boolean isSatisfied() {
                return COUNTING_SPAN_EXPORTER.getExportedSpansCount() == 2L;
            }

            public String describeFailure() {
                return "Expected span export did not happen";
            }
        });
    }

    protected void addBuilders(List<ConfigurationBuilder> builders) {
        super.addBuilders(builders);
        builders.add(this.getCustomSpanExporterFactoryBuilder());
    }

    private ConfigurationBuilder getCustomSpanExporterFactoryBuilder() {
        return new ConfigurationBuilder(){

            public void addServiceConfigurator(ServiceConfigurator serviceConfigurator) {
            }

            public void configure(MuleContext muleContext) {
                muleContext.getCustomizationService().overrideDefaultServiceClass("_muleCoreExporterFactory", CountingSpanExporterFactory.class);
            }
        };
    }

    private static final class CountingSpanExporter
    implements SpanExporter {
        final AtomicLong exportedSpansCount = new AtomicLong(0L);

        private CountingSpanExporter() {
        }

        public CompletableResultCode export(Collection<SpanData> spanDataList) {
            this.exportedSpansCount.addAndGet(spanDataList.size());
            return CompletableResultCode.ofSuccess();
        }

        public CompletableResultCode flush() {
            return CompletableResultCode.ofSuccess();
        }

        public CompletableResultCode shutdown() {
            return CompletableResultCode.ofSuccess();
        }

        public long getExportedSpansCount() {
            return this.exportedSpansCount.get();
        }
    }

    private static class CountingSpanExporterFactory
    extends OpenTelemetrySpanExporterFactory {
        public CountingSpanExporterFactory() {
            super(privilegedConfiguration);
        }

        protected SpanExporter resolveOpenTelemetrySpanExporter() {
            return COUNTING_SPAN_EXPORTER;
        }
    }
}

