/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.components.tracing;

import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.server.AbstractHttpService;
import com.linecorp.armeria.server.HttpService;
import com.linecorp.armeria.server.ServerBuilder;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.testing.junit4.server.ServerRule;
import io.opentelemetry.proto.collector.trace.v1.ExportTraceServiceRequest;
import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicInteger;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jetbrains.annotations.NotNull;
import org.junit.After;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.functional.junit4.MuleArtifactFunctionalTestCase;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.tracer.api.sniffer.CapturedExportedSpan;
import org.mule.runtime.tracing.level.api.config.TracingLevel;
import org.mule.tck.probe.JUnitProbe;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;
import org.mule.test.components.tracing.OpenTelemetryProtobufSpanUtils;
import org.mule.test.components.tracing.OpenTelemetryTracingTestRunnerConfigAnnotation;
import org.mule.test.infrastructure.profiling.tracing.SpanTestHierarchy;
import org.mule.test.infrastructure.profiling.tracing.TracingTestUtils;

@Feature(value="Profiling")
@Story(value="Default Core Event Tracer")
public class ExportConfigurationChangeTestCase
extends MuleArtifactFunctionalTestCase
implements OpenTelemetryTracingTestRunnerConfigAnnotation {
    private static final String EXPECTED_FLOW_SPAN_NAME = "mule:flow";
    private static final String EXPECTED_SET_PAYLOAD_SPAN_NAME = "mule:set-payload";
    private static final String FLOW_LOCATION = "flow";
    private static final String TEST_ARTIFACT_ID = "ExportConfigurationChangeTestCase#test";
    public static final int TIMEOUT_MILLIS = 30000;
    private static final int POLL_DELAY_MILLIS = 100;
    public static final int MAX_BACKOFF_ATTEMPTS = 2;
    private static final String SET_PAYLOAD_LOCATION = "flow/processors/0";
    public static final String EXPORTER_CONF_NAME = "exporter.conf";
    public static final String EXPORTER_CONF_WITH_OVERRIDES_NAME = "exporter_with_overrides.conf";
    public static final String TEST_FILE_PREFIX = "tracing";
    public static final String TEST_FILE_SUFFIX = "test";
    public static final String TEST_LEVEL = "test.level";
    private File file;
    private URI configFileUri;
    private URI configFileUriWithOverrides;
    @ClassRule
    public static final TestServerRule originalServer = new TestServerRule();
    @ClassRule
    public static final TestServerRule afterConfigurationChangeServer = new TestServerRule();

    protected String getConfigFile() {
        return "tracing/export-configuration-change.xml";
    }

    protected void doSetUpBeforeMuleContextCreation() throws Exception {
        this.file = File.createTempFile(TEST_FILE_PREFIX, TEST_FILE_SUFFIX);
        this.configFileUri = IOUtils.getResourceAsUrl((String)EXPORTER_CONF_NAME, this.getClass()).toURI();
        this.configFileUriWithOverrides = IOUtils.getResourceAsUrl((String)EXPORTER_CONF_WITH_OVERRIDES_NAME, this.getClass()).toURI();
        Files.copy(Paths.get(this.configFileUri), Paths.get(this.file.getPath(), new String[0]), StandardCopyOption.REPLACE_EXISTING);
        System.setProperty("mule.openTelemetry.tracer.exporter.configurationFilePath", this.file.getAbsolutePath());
        System.setProperty("mule.openTelemetry.tracer.exporter.enabled", Boolean.FALSE.toString());
        System.setProperty("mule.openTelemetry.tracer.exporter.endpoint", "http://localhost:" + originalServer.httpPort());
        System.setProperty(TEST_LEVEL, TracingLevel.MONITORING.name());
        System.setProperty("mule.openTelemetry.tracer.exporter.sampler", "always_on");
        System.setProperty("mule.openTelemetry.tracer.exporter.configurationFileWatcherDelay", "100");
    }

    @After
    public void after() {
        System.clearProperty("mule.openTelemetry.tracer.exporter.configurationFilePath");
        System.clearProperty("mule.openTelemetry.tracer.exporter.endpoint");
        System.clearProperty("mule.openTelemetry.tracer.exporter.configurationFileWatcherDelay");
        System.clearProperty("mule.openTelemetry.tracer.exporter.enabled");
        System.clearProperty(TEST_LEVEL);
        System.clearProperty("mule.openTelemetry.tracer.exporter.sampler");
    }

    @Test(timeout=90000L)
    public void test() throws Exception {
        ((FlowRunner)this.flowRunner(FLOW_LOCATION).withPayload((Object)TEST_FILE_SUFFIX)).run().getMessage();
        Thread.sleep(5000L);
        Assert.assertThat((Object)originalServer.getCapturedExportedSpans().size(), (Matcher)Matchers.equalTo((Object)0));
        System.setProperty("mule.openTelemetry.tracer.exporter.enabled", Boolean.TRUE.toString());
        this.file.setLastModified(System.currentTimeMillis());
        Thread.sleep(2000L);
        ((FlowRunner)this.flowRunner(FLOW_LOCATION).withPayload((Object)TEST_FILE_SUFFIX)).run().getMessage();
        ExportConfigurationChangeTestCase.pollTillExportedSpansCaptured(originalServer, 2);
        List attributesToAssertExistence = TracingTestUtils.getDefaultAttributesToAssertExistence();
        List<CapturedExportedSpan> exportedSpans = originalServer.getCapturedExportedSpans();
        Map setPayloadAttributeMap = TracingTestUtils.createAttributeMap((String)SET_PAYLOAD_LOCATION, (String)TEST_ARTIFACT_ID);
        ExportConfigurationChangeTestCase.assertExpectedSpanTreeMonitoring(attributesToAssertExistence, exportedSpans, setPayloadAttributeMap);
        System.setProperty("mule.openTelemetry.tracer.exporter.endpoint", "http://localhost:" + afterConfigurationChangeServer.httpPort());
        this.file.setLastModified(System.currentTimeMillis());
        Thread.sleep(2000L);
        ((FlowRunner)this.flowRunner(FLOW_LOCATION).withPayload((Object)TEST_FILE_SUFFIX)).run().getMessage();
        ExportConfigurationChangeTestCase.pollTillExportedSpansCaptured(afterConfigurationChangeServer, 2);
        exportedSpans = afterConfigurationChangeServer.getCapturedExportedSpans();
        ExportConfigurationChangeTestCase.assertExpectedSpanTreeMonitoring(attributesToAssertExistence, exportedSpans, setPayloadAttributeMap);
        System.setProperty(TEST_LEVEL, TracingLevel.OVERVIEW.name());
        this.file.setLastModified(System.currentTimeMillis());
        afterConfigurationChangeServer.reset();
        Thread.sleep(2000L);
        ((FlowRunner)this.flowRunner(FLOW_LOCATION).withPayload((Object)TEST_FILE_SUFFIX)).run().getMessage();
        ExportConfigurationChangeTestCase.pollTillExportedSpansCaptured(afterConfigurationChangeServer, 1);
        exportedSpans = afterConfigurationChangeServer.getCapturedExportedSpans();
        ExportConfigurationChangeTestCase.assertExpectedSpanTreeOverview(attributesToAssertExistence, exportedSpans, setPayloadAttributeMap);
        Files.copy(Paths.get(this.configFileUriWithOverrides), Paths.get(this.file.getPath(), new String[0]), StandardCopyOption.REPLACE_EXISTING);
        this.file.setLastModified(System.currentTimeMillis());
        afterConfigurationChangeServer.reset();
        Thread.sleep(2000L);
        ((FlowRunner)this.flowRunner(FLOW_LOCATION).withPayload((Object)TEST_FILE_SUFFIX)).run().getMessage();
        ExportConfigurationChangeTestCase.pollTillExportedSpansCaptured(afterConfigurationChangeServer, 2);
        exportedSpans = afterConfigurationChangeServer.getCapturedExportedSpans();
        ExportConfigurationChangeTestCase.assertExpectedSpanTreeMonitoring(attributesToAssertExistence, exportedSpans, setPayloadAttributeMap);
    }

    private static void pollTillExportedSpansCaptured(final TestServerRule server, final int expectedSpansCount) {
        new PollingProber(30000L, 100L).check((Probe)new JUnitProbe(){

            protected boolean test() {
                List<CapturedExportedSpan> exportedSpans = server.getCapturedExportedSpans();
                return exportedSpans.size() == expectedSpansCount;
            }

            public String describeFailure() {
                return "The exact amount of spans was not captured";
            }
        });
    }

    private static void assertExpectedSpanTreeMonitoring(List<String> attributesToAssertExistence, Collection<CapturedExportedSpan> exportedSpans, Map<String, String> setPayloadAttributeMap) {
        SpanTestHierarchy expectedSpanHierarchy = new SpanTestHierarchy(exportedSpans);
        expectedSpanHierarchy.withRoot(EXPECTED_FLOW_SPAN_NAME).addAttributesToAssertValue(TracingTestUtils.createAttributeMap((String)FLOW_LOCATION, (String)TEST_ARTIFACT_ID)).addAttributesToAssertExistence(attributesToAssertExistence).beginChildren().child(EXPECTED_SET_PAYLOAD_SPAN_NAME).addAttributesToAssertValue(setPayloadAttributeMap).addAttributesToAssertExistence(attributesToAssertExistence).endChildren();
        expectedSpanHierarchy.assertSpanTree();
    }

    private static void assertExpectedSpanTreeOverview(List<String> attributesToAssertExistence, Collection<CapturedExportedSpan> exportedSpans, Map<String, String> setPayloadAttributeMap) {
        SpanTestHierarchy expectedSpanHierarchy = new SpanTestHierarchy(exportedSpans);
        expectedSpanHierarchy.withRoot(EXPECTED_FLOW_SPAN_NAME).addAttributesToAssertValue(TracingTestUtils.createAttributeMap((String)FLOW_LOCATION, (String)TEST_ARTIFACT_ID)).addAttributesToAssertExistence(attributesToAssertExistence);
        expectedSpanHierarchy.assertSpanTree();
    }

    private static final class TestServerRule
    extends ServerRule {
        public static final String PATH_PATTERN = "/";
        private final List<CapturedExportedSpan> capturedExportedSpans = new ArrayList<CapturedExportedSpan>();
        private final AtomicInteger exportAttempts = new AtomicInteger(0);

        private TestServerRule() {
        }

        protected void configure(ServerBuilder sb) {
            sb.service(PATH_PATTERN, (HttpService)new AbstractHttpService(){

                @NotNull
                protected HttpResponse doPost(@NotNull ServiceRequestContext ctx, @NotNull HttpRequest req) {
                    return HttpResponse.from((CompletionStage)req.aggregate().handle((aReq, cause) -> {
                        CompletableFuture<HttpResponse> responseFuture = new CompletableFuture<HttpResponse>();
                        HttpResponse res = HttpResponse.from(responseFuture);
                        if (exportAttempts.incrementAndGet() < 2) {
                            responseFuture.complete(HttpResponse.of((HttpStatus)HttpStatus.REQUEST_TIMEOUT));
                            return res;
                        }
                        try {
                            capturedExportedSpans.addAll(OpenTelemetryProtobufSpanUtils.getSpans(ExportTraceServiceRequest.parseFrom((InputStream)new ByteArrayInputStream(aReq.content().array()))));
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        responseFuture.complete(HttpResponse.of((HttpStatus)HttpStatus.OK));
                        return res;
                    }));
                }
            });
            sb.http(0);
        }

        public List<CapturedExportedSpan> getCapturedExportedSpans() {
            return this.capturedExportedSpans;
        }

        public void reset() {
            this.capturedExportedSpans.clear();
        }
    }
}

