/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.components.tracing.override;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import jakarta.inject.Inject;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.runtime.core.privileged.profiling.PrivilegedProfilingService;
import org.mule.runtime.tracer.api.sniffer.CapturedExportedSpan;
import org.mule.runtime.tracer.api.sniffer.ExportedSpanSniffer;
import org.mule.tck.probe.JUnitProbe;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;
import org.mule.test.components.tracing.OpenTelemetryTracingSnifferTestCase;
import org.mule.test.components.tracing.OpenTelemetryTracingTestRunnerConfigAnnotation;
import org.mule.test.infrastructure.profiling.tracing.SpanTestHierarchy;
import org.mule.test.infrastructure.profiling.tracing.TracingTestUtils;
import org.mule.test.runner.RunnerDelegateTo;

@Feature(value="Profiling")
@Story(value="Default Core Event Tracer")
@RunnerDelegateTo(value=Parameterized.class)
public class OverrideUntilSuccessfulSuccessOpenTelemetryTracingTestCase
extends OpenTelemetryTracingSnifferTestCase
implements OpenTelemetryTracingTestRunnerConfigAnnotation {
    private static final int TIMEOUT_MILLIS = 30000;
    private static final int POLL_DELAY_MILLIS = 100;
    private static final String FLOW_NAME = "until-successful-flow";
    private static final String CONFIG_FILE = "tracing/until-successful-success.xml";
    private static final String OVERRIDE_FOLDER_NAME = "override/until-successful";
    private static final String EXPECTED_FLOW_SPAN_NAME = "mule:flow";
    private static final String EXPECTED_UNTIL_SUCCESSFUL_SPAN_NAME = "mule:until-successful";
    private static final String EXPECTED_ATTEMPT_SPAN_NAME = "mule:until-successful:attempt";
    private static final String EXPECTED_LOGGER_SPAN_NAME = "mule:logger";
    private static final String EXPECTED_SET_PAYLOAD_SPAN_NAME = "mule:set-payload";
    private final String tracingLevelConf;
    private final int expectedSpans;
    private final Function<Collection<CapturedExportedSpan>, SpanTestHierarchy> spanHierarchyRetriever;
    @Inject
    PrivilegedProfilingService profilingService;

    @Parameterized.Parameters(name="TracingLevelConf: {0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({"overview-until-successful-debug", 5, OverrideUntilSuccessfulSuccessOpenTelemetryTracingTestCase.getOverviewUntilSuccessfulDebugExpectedSpanTestHierarchy()}, {"overview-until-successful-monitoring", 5, OverrideUntilSuccessfulSuccessOpenTelemetryTracingTestCase.getOverviewUntilSuccessfulMonitoringExpectedSpanTestHierarchy()}, {"monitoring-until-successful-debug", 5, OverrideUntilSuccessfulSuccessOpenTelemetryTracingTestCase.getMonitoringUntilSuccessfulDebugExpectedSpanTestHierarchy()}, {"monitoring-until-successful-overview", 1, OverrideUntilSuccessfulSuccessOpenTelemetryTracingTestCase.getMonitoringUntilSuccessfulOverviewExpectedSpanTestHierarchy()}, {"debug-until-successful-monitoring", 5, OverrideUntilSuccessfulSuccessOpenTelemetryTracingTestCase.getDebugUntilSuccessfulMonitoringExpectedSpanTestHierarchy()}, {"debug-until-successful-overview", 1, OverrideUntilSuccessfulSuccessOpenTelemetryTracingTestCase.getDebugUntilSuccessfulOverviewExpectedSpanTestHierarchy()});
    }

    public OverrideUntilSuccessfulSuccessOpenTelemetryTracingTestCase(String tracingLevelConf, int expectedSpans, Function<Collection<CapturedExportedSpan>, SpanTestHierarchy> spanHierarchyRetriever) {
        this.tracingLevelConf = tracingLevelConf;
        this.expectedSpans = expectedSpans;
        this.spanHierarchyRetriever = spanHierarchyRetriever;
        String tracingLevelConfigurationFolderResourcePath = String.format("%s/%s", OVERRIDE_FOLDER_NAME, tracingLevelConf);
        this.configureTracingLevelSystemProperties(tracingLevelConfigurationFolderResourcePath);
    }

    protected String getConfigFile() {
        return CONFIG_FILE;
    }

    private static Function<Collection<CapturedExportedSpan>, SpanTestHierarchy> getOverviewUntilSuccessfulDebugExpectedSpanTestHierarchy() {
        return exportedSpans -> {
            List attributesToAssertExistence = TracingTestUtils.getDefaultAttributesToAssertExistence();
            SpanTestHierarchy expectedSpanHierarchy = new SpanTestHierarchy(exportedSpans);
            expectedSpanHierarchy.withRoot(EXPECTED_FLOW_SPAN_NAME).addAttributesToAssertExistence(attributesToAssertExistence).beginChildren().child(EXPECTED_UNTIL_SUCCESSFUL_SPAN_NAME).addAttributesToAssertExistence(attributesToAssertExistence).beginChildren().child(EXPECTED_ATTEMPT_SPAN_NAME).addAttributesToAssertExistence(attributesToAssertExistence).beginChildren().child(EXPECTED_LOGGER_SPAN_NAME).addAttributesToAssertExistence(attributesToAssertExistence).child(EXPECTED_SET_PAYLOAD_SPAN_NAME).addAttributesToAssertExistence(attributesToAssertExistence).endChildren().endChildren().endChildren();
            return expectedSpanHierarchy;
        };
    }

    private static Function<Collection<CapturedExportedSpan>, SpanTestHierarchy> getOverviewUntilSuccessfulMonitoringExpectedSpanTestHierarchy() {
        return OverrideUntilSuccessfulSuccessOpenTelemetryTracingTestCase.getOverviewUntilSuccessfulDebugExpectedSpanTestHierarchy();
    }

    private static Function<Collection<CapturedExportedSpan>, SpanTestHierarchy> getMonitoringUntilSuccessfulDebugExpectedSpanTestHierarchy() {
        return OverrideUntilSuccessfulSuccessOpenTelemetryTracingTestCase.getOverviewUntilSuccessfulDebugExpectedSpanTestHierarchy();
    }

    private static Function<Collection<CapturedExportedSpan>, SpanTestHierarchy> getMonitoringUntilSuccessfulOverviewExpectedSpanTestHierarchy() {
        return exportedSpans -> {
            List attributesToAssertExistence = TracingTestUtils.getDefaultAttributesToAssertExistence();
            SpanTestHierarchy expectedSpanHierarchy = new SpanTestHierarchy(exportedSpans);
            expectedSpanHierarchy.withRoot(EXPECTED_FLOW_SPAN_NAME).addAttributesToAssertExistence(attributesToAssertExistence);
            return expectedSpanHierarchy;
        };
    }

    private static Function<Collection<CapturedExportedSpan>, SpanTestHierarchy> getDebugUntilSuccessfulMonitoringExpectedSpanTestHierarchy() {
        return OverrideUntilSuccessfulSuccessOpenTelemetryTracingTestCase.getOverviewUntilSuccessfulDebugExpectedSpanTestHierarchy();
    }

    private static Function<Collection<CapturedExportedSpan>, SpanTestHierarchy> getDebugUntilSuccessfulOverviewExpectedSpanTestHierarchy() {
        return OverrideUntilSuccessfulSuccessOpenTelemetryTracingTestCase.getMonitoringUntilSuccessfulOverviewExpectedSpanTestHierarchy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFlow() throws Exception {
        final ExportedSpanSniffer spanCapturer = this.profilingService.getSpanExportManager().getExportedSpanSniffer();
        try {
            ((FlowRunner)this.flowRunner(FLOW_NAME).withPayload((Object)"test")).run().getMessage();
            PollingProber prober = new PollingProber(30000L, 100L);
            prober.check((Probe)new JUnitProbe(){

                protected boolean test() {
                    Collection exportedSpans = spanCapturer.getExportedSpans();
                    return exportedSpans.size() == OverrideUntilSuccessfulSuccessOpenTelemetryTracingTestCase.this.expectedSpans;
                }

                public String describeFailure() {
                    return "The exact amount of spans was not captured.";
                }
            });
            Collection exportedSpans = spanCapturer.getExportedSpans();
            this.spanHierarchyRetriever.apply(exportedSpans).assertSpanTree();
        }
        finally {
            spanCapturer.dispose();
        }
    }
}

