/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.components.tracing;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import jakarta.inject.Inject;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.Function;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.runtime.core.privileged.profiling.PrivilegedProfilingService;
import org.mule.runtime.tracer.api.sniffer.CapturedExportedSpan;
import org.mule.runtime.tracer.api.sniffer.ExportedSpanSniffer;
import org.mule.runtime.tracing.level.api.config.TracingLevel;
import org.mule.tck.probe.JUnitProbe;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;
import org.mule.test.components.tracing.OpenTelemetryTracingSnifferTestCase;
import org.mule.test.components.tracing.OpenTelemetryTracingTestRunnerConfigAnnotation;
import org.mule.test.infrastructure.profiling.tracing.SpanTestHierarchy;
import org.mule.test.runner.RunnerDelegateTo;

@Feature(value="Profiling")
@Story(value="Default Core Event Tracer")
@RunnerDelegateTo(value=Parameterized.class)
public class UntilSuccessfulErrorOpenTelemetryTracingTestCase
extends OpenTelemetryTracingSnifferTestCase
implements OpenTelemetryTracingTestRunnerConfigAnnotation {
    private static final int TIMEOUT_MILLIS = 30000;
    private static final int POLL_DELAY_MILLIS = 100;
    public static final String EXPECTED_ATTEMPT_SPAN_NAME = "mule:until-successful:attempt";
    public static final String EXPECTED_UNTIL_SUCCESSFUL_SPAN_NAME = "mule:until-successful";
    public static final String EXPECTED_LOGGER_SPAN_NAME = "mule:logger";
    public static final String UNTIL_SUCCESSFUL_FLOW = "until-successful-flow";
    public static final String EXPECTED_FLOW_SPAN_NAME = "mule:flow";
    public static final String EXPECTED_HTTP_REQUEST_SPAN_NAME = "http:request";
    public static final String ON_ERROR_PROPAGATE_SPAN_NAME = "mule:on-error-propagate";
    public static final String EXPECTED_RAISE_ERROR_SPAN = "mule:raise-error";
    public static final String NO_PARENT_SPAN = "0000000000000000";
    public static final int NUMBER_OF_RETRIES = 2;
    private final int expectedSpansCount;
    private final Function<Collection<CapturedExportedSpan>, SpanTestHierarchy> spanHierarchyRetriever;
    @Inject
    PrivilegedProfilingService profilingService;

    @Parameterized.Parameters(name="tracingLevel: {0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({TracingLevel.OVERVIEW.name(), 1, UntilSuccessfulErrorOpenTelemetryTracingTestCase.getOverviewExpectedSpanTestHierarchy()}, {TracingLevel.MONITORING.name(), 12, UntilSuccessfulErrorOpenTelemetryTracingTestCase.getMonitoringExpectedSpanTestHierarchy()}, {TracingLevel.DEBUG.name(), 12, UntilSuccessfulErrorOpenTelemetryTracingTestCase.getDebugExpectedSpanTestHierarchy()});
    }

    private static Function<Collection<CapturedExportedSpan>, SpanTestHierarchy> getOverviewExpectedSpanTestHierarchy() {
        return exportedSpans -> {
            SpanTestHierarchy expectedSpanHierarchy = new SpanTestHierarchy(exportedSpans);
            expectedSpanHierarchy.withRoot(EXPECTED_FLOW_SPAN_NAME).addExceptionData("MULE:RETRY_EXHAUSTED");
            return expectedSpanHierarchy;
        };
    }

    private static Function<Collection<CapturedExportedSpan>, SpanTestHierarchy> getMonitoringExpectedSpanTestHierarchy() {
        return exportedSpans -> {
            SpanTestHierarchy expectedSpanHierarchy = new SpanTestHierarchy(exportedSpans);
            expectedSpanHierarchy.withRoot(EXPECTED_FLOW_SPAN_NAME).addExceptionData("MULE:RETRY_EXHAUSTED").beginChildren().child(EXPECTED_UNTIL_SUCCESSFUL_SPAN_NAME).addExceptionData("MULE:RETRY_EXHAUSTED").beginChildren().child(EXPECTED_ATTEMPT_SPAN_NAME).addExceptionData("ANY:EXPECTED").beginChildren().child(EXPECTED_LOGGER_SPAN_NAME).child(EXPECTED_RAISE_ERROR_SPAN).addExceptionData("ANY:EXPECTED").endChildren().child(EXPECTED_ATTEMPT_SPAN_NAME).addExceptionData("ANY:EXPECTED").beginChildren().child(EXPECTED_LOGGER_SPAN_NAME).child(EXPECTED_RAISE_ERROR_SPAN).addExceptionData("ANY:EXPECTED").endChildren().child(EXPECTED_ATTEMPT_SPAN_NAME).addExceptionData("ANY:EXPECTED").beginChildren().child(EXPECTED_LOGGER_SPAN_NAME).child(EXPECTED_RAISE_ERROR_SPAN).addExceptionData("ANY:EXPECTED").endChildren().endChildren().child(ON_ERROR_PROPAGATE_SPAN_NAME).endChildren();
            return expectedSpanHierarchy;
        };
    }

    private static Function<Collection<CapturedExportedSpan>, SpanTestHierarchy> getDebugExpectedSpanTestHierarchy() {
        return UntilSuccessfulErrorOpenTelemetryTracingTestCase.getMonitoringExpectedSpanTestHierarchy();
    }

    public UntilSuccessfulErrorOpenTelemetryTracingTestCase(String traceLevel, int expectedSpansCount, Function<Collection<CapturedExportedSpan>, SpanTestHierarchy> spanHierarchyRetriever) {
        this.expectedSpansCount = expectedSpansCount;
        this.spanHierarchyRetriever = spanHierarchyRetriever;
        this.configureTracingLevelSystemProperties(traceLevel.toLowerCase());
    }

    protected String getConfigFile() {
        return "tracing/until-successful-error.xml";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUntilSuccessfulFlowWithError() throws Exception {
        final ExportedSpanSniffer spanCapturer = this.profilingService.getSpanExportManager().getExportedSpanSniffer();
        try {
            ((FlowRunner)this.flowRunner(UNTIL_SUCCESSFUL_FLOW).withPayload((Object)"test")).dispatch();
            PollingProber prober = new PollingProber(30000L, 100L);
            prober.check((Probe)new JUnitProbe(){

                protected boolean test() {
                    Collection exportedSpans = spanCapturer.getExportedSpans();
                    return exportedSpans.size() == UntilSuccessfulErrorOpenTelemetryTracingTestCase.this.expectedSpansCount;
                }

                public String describeFailure() {
                    return "The exact amount of spans was not captured";
                }
            });
            Collection exportedSpans = spanCapturer.getExportedSpans();
            this.spanHierarchyRetriever.apply(exportedSpans).assertSpanTree();
        }
        finally {
            spanCapturer.dispose();
        }
    }
}

